/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column.page.mem;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.UnknownColumnException;
import org.apache.parquet.column.page.DataPage;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.column.page.PageReader;
import org.apache.parquet.column.page.PageWriteStore;
import org.apache.parquet.column.page.PageWriter;
import org.apache.parquet.column.page.mem.MemPageReader;
import org.apache.parquet.column.page.mem.MemPageWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemPageStore
implements PageReadStore,
PageWriteStore {
    private static final Logger LOG = LoggerFactory.getLogger(MemPageStore.class);
    private Map<ColumnDescriptor, MemPageWriter> pageWriters = new HashMap<ColumnDescriptor, MemPageWriter>();
    private long rowCount;

    public MemPageStore(long rowCount) {
        this.rowCount = rowCount;
    }

    public PageWriter getPageWriter(ColumnDescriptor path) {
        MemPageWriter pageWriter = this.pageWriters.get(path);
        if (pageWriter == null) {
            pageWriter = new MemPageWriter();
            this.pageWriters.put(path, pageWriter);
        }
        return pageWriter;
    }

    public PageReader getPageReader(ColumnDescriptor descriptor) {
        MemPageWriter pageWriter = this.pageWriters.get(descriptor);
        if (pageWriter == null) {
            throw new UnknownColumnException(descriptor);
        }
        ArrayList<DataPage> pages = new ArrayList<DataPage>(pageWriter.getPages());
        LOG.debug("initialize page reader with {} values and {} pages", (Object)pageWriter.getTotalValueCount(), (Object)pages.size());
        return new MemPageReader(pageWriter.getTotalValueCount(), pages.iterator(), pageWriter.getDictionaryPage());
    }

    public long getRowCount() {
        return this.rowCount;
    }

    public void close() {
    }

    public void addRowCount(long count) {
        this.rowCount += count;
    }
}

