/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column.impl;

import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.parquet.CorruptDeltaByteArrays;
import org.apache.parquet.SemanticVersion;
import org.apache.parquet.VersionParser;
import org.apache.parquet.bytes.ByteBufferAllocator;
import org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.bytes.HeapByteBufferAllocator;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.column.impl.ColumnReaderImpl;
import org.apache.parquet.column.page.PageWriter;
import org.apache.parquet.column.page.mem.MemPageStore;
import org.apache.parquet.column.statistics.BinaryStatistics;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.column.values.ValuesReader;
import org.apache.parquet.column.values.ValuesWriter;
import org.apache.parquet.column.values.deltastrings.DeltaByteArrayReader;
import org.apache.parquet.column.values.deltastrings.DeltaByteArrayWriter;
import org.apache.parquet.column.values.dictionary.DictionaryValuesReader;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.PrimitiveConverter;
import org.apache.parquet.schema.PrimitiveType;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestCorruptDeltaByteArrays {
    @Test
    public void testCorruptDeltaByteArrayVersions() {
        Assert.assertTrue((boolean)CorruptDeltaByteArrays.requiresSequentialReads((String)"parquet-mr version 1.6.0 (build abcd)", (Encoding)Encoding.DELTA_BYTE_ARRAY));
        Assert.assertTrue((boolean)CorruptDeltaByteArrays.requiresSequentialReads((String)null, (Encoding)Encoding.DELTA_BYTE_ARRAY));
        Assert.assertTrue((boolean)CorruptDeltaByteArrays.requiresSequentialReads((VersionParser.ParsedVersion)null, (Encoding)Encoding.DELTA_BYTE_ARRAY));
        Assert.assertTrue((boolean)CorruptDeltaByteArrays.requiresSequentialReads((SemanticVersion)null, (Encoding)Encoding.DELTA_BYTE_ARRAY));
        Assert.assertTrue((boolean)CorruptDeltaByteArrays.requiresSequentialReads((String)"parquet-mr version 1.8.0-SNAPSHOT (build abcd)", (Encoding)Encoding.DELTA_BYTE_ARRAY));
        Assert.assertFalse((boolean)CorruptDeltaByteArrays.requiresSequentialReads((String)"parquet-mr version 1.6.0 (build abcd)", (Encoding)Encoding.DELTA_BINARY_PACKED));
        Assert.assertFalse((boolean)CorruptDeltaByteArrays.requiresSequentialReads((String)null, (Encoding)Encoding.DELTA_LENGTH_BYTE_ARRAY));
        Assert.assertFalse((boolean)CorruptDeltaByteArrays.requiresSequentialReads((VersionParser.ParsedVersion)null, (Encoding)Encoding.PLAIN));
        Assert.assertFalse((boolean)CorruptDeltaByteArrays.requiresSequentialReads((SemanticVersion)null, (Encoding)Encoding.RLE));
        Assert.assertFalse((boolean)CorruptDeltaByteArrays.requiresSequentialReads((String)"parquet-mr version 1.8.0-SNAPSHOT (build abcd)", (Encoding)Encoding.RLE_DICTIONARY));
        Assert.assertFalse((boolean)CorruptDeltaByteArrays.requiresSequentialReads((String)"parquet-mr version 1.8.0-SNAPSHOT (build abcd)", (Encoding)Encoding.PLAIN_DICTIONARY));
        Assert.assertFalse((boolean)CorruptDeltaByteArrays.requiresSequentialReads((String)"parquet-mr version 1.8.0-SNAPSHOT (build abcd)", (Encoding)Encoding.BIT_PACKED));
        Assert.assertFalse((boolean)CorruptDeltaByteArrays.requiresSequentialReads((String)"parquet-mr version 1.8.0 (build abcd)", (Encoding)Encoding.DELTA_BYTE_ARRAY));
    }

    @Test
    public void testEncodingRequiresSequentialRead() {
        VersionParser.ParsedVersion impala = new VersionParser.ParsedVersion("impala", "1.2.0", "abcd");
        Assert.assertFalse((boolean)CorruptDeltaByteArrays.requiresSequentialReads((VersionParser.ParsedVersion)impala, (Encoding)Encoding.DELTA_BYTE_ARRAY));
        VersionParser.ParsedVersion broken = new VersionParser.ParsedVersion("parquet-mr", "1.8.0-SNAPSHOT", "abcd");
        Assert.assertTrue((boolean)CorruptDeltaByteArrays.requiresSequentialReads((VersionParser.ParsedVersion)broken, (Encoding)Encoding.DELTA_BYTE_ARRAY));
        VersionParser.ParsedVersion fixed = new VersionParser.ParsedVersion("parquet-mr", "1.8.0", "abcd");
        Assert.assertFalse((boolean)CorruptDeltaByteArrays.requiresSequentialReads((VersionParser.ParsedVersion)fixed, (Encoding)Encoding.DELTA_BYTE_ARRAY));
    }

    private DeltaByteArrayWriter getDeltaByteArrayWriter() {
        return new DeltaByteArrayWriter(10, 100, (ByteBufferAllocator)new HeapByteBufferAllocator());
    }

    @Test
    public void testReassemblyWithCorruptPage() throws Exception {
        DeltaByteArrayWriter writer = this.getDeltaByteArrayWriter();
        String lastValue = null;
        for (int i = 0; i < 10; ++i) {
            lastValue = this.str(i);
            writer.writeBytes(Binary.fromString((String)lastValue));
        }
        ByteBuffer firstPageBytes = writer.getBytes().toByteBuffer();
        writer.reset();
        this.corruptWriter(writer, lastValue);
        for (int i = 10; i < 20; ++i) {
            writer.writeBytes(Binary.fromString((String)this.str(i)));
        }
        ByteBuffer corruptPageBytes = writer.getBytes().toByteBuffer();
        DeltaByteArrayReader firstPageReader = new DeltaByteArrayReader();
        firstPageReader.initFromPage(10, ByteBufferInputStream.wrap((ByteBuffer[])new ByteBuffer[]{firstPageBytes}));
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((Object)this.str(i), (Object)firstPageReader.readBytes().toStringUsingUTF8());
        }
        DeltaByteArrayReader corruptPageReader = new DeltaByteArrayReader();
        corruptPageReader.initFromPage(10, ByteBufferInputStream.wrap((ByteBuffer[])new ByteBuffer[]{corruptPageBytes}));
        try {
            corruptPageReader.readBytes();
            Assert.fail((String)"Corrupt page did not throw an exception when read");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        DeltaByteArrayReader secondPageReader = new DeltaByteArrayReader();
        secondPageReader.initFromPage(10, ByteBufferInputStream.wrap((ByteBuffer[])new ByteBuffer[]{corruptPageBytes}));
        secondPageReader.setPreviousReader((ValuesReader)firstPageReader);
        for (int i = 10; i < 20; ++i) {
            Assert.assertEquals((Object)secondPageReader.readBytes().toStringUsingUTF8(), (Object)this.str(i));
        }
    }

    @Test
    public void testReassemblyWithoutCorruption() throws Exception {
        DeltaByteArrayWriter writer = this.getDeltaByteArrayWriter();
        for (int i = 0; i < 10; ++i) {
            writer.writeBytes(Binary.fromString((String)this.str(i)));
        }
        ByteBuffer firstPageBytes = writer.getBytes().toByteBuffer();
        writer.reset();
        for (int i = 10; i < 20; ++i) {
            writer.writeBytes(Binary.fromString((String)this.str(i)));
        }
        ByteBuffer secondPageBytes = writer.getBytes().toByteBuffer();
        DeltaByteArrayReader firstPageReader = new DeltaByteArrayReader();
        firstPageReader.initFromPage(10, ByteBufferInputStream.wrap((ByteBuffer[])new ByteBuffer[]{firstPageBytes}));
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((Object)firstPageReader.readBytes().toStringUsingUTF8(), (Object)this.str(i));
        }
        DeltaByteArrayReader secondPageReader = new DeltaByteArrayReader();
        secondPageReader.initFromPage(10, ByteBufferInputStream.wrap((ByteBuffer[])new ByteBuffer[]{secondPageBytes}));
        secondPageReader.setPreviousReader((ValuesReader)firstPageReader);
        for (int i = 10; i < 20; ++i) {
            Assert.assertEquals((Object)secondPageReader.readBytes().toStringUsingUTF8(), (Object)this.str(i));
        }
    }

    @Test
    public void testOldReassemblyWithoutCorruption() throws Exception {
        DeltaByteArrayWriter writer = this.getDeltaByteArrayWriter();
        for (int i = 0; i < 10; ++i) {
            writer.writeBytes(Binary.fromString((String)this.str(i)));
        }
        ByteBuffer firstPageBytes = writer.getBytes().toByteBuffer();
        writer.reset();
        for (int i = 10; i < 20; ++i) {
            writer.writeBytes(Binary.fromString((String)this.str(i)));
        }
        ByteBuffer secondPageBytes = writer.getBytes().toByteBuffer();
        DeltaByteArrayReader firstPageReader = new DeltaByteArrayReader();
        firstPageReader.initFromPage(10, ByteBufferInputStream.wrap((ByteBuffer[])new ByteBuffer[]{firstPageBytes}));
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((Object)firstPageReader.readBytes().toStringUsingUTF8(), (Object)this.str(i));
        }
        DeltaByteArrayReader secondPageReader = new DeltaByteArrayReader();
        secondPageReader.initFromPage(10, ByteBufferInputStream.wrap((ByteBuffer[])new ByteBuffer[]{secondPageBytes}));
        for (int i = 10; i < 20; ++i) {
            Assert.assertEquals((Object)secondPageReader.readBytes().toStringUsingUTF8(), (Object)this.str(i));
        }
    }

    @Test
    public void testColumnReaderImplWithCorruptPage() throws Exception {
        int i;
        ColumnDescriptor column = new ColumnDescriptor(new String[]{"s"}, PrimitiveType.PrimitiveTypeName.BINARY, 0, 0);
        MemPageStore pages = new MemPageStore(0L);
        PageWriter memWriter = pages.getPageWriter(column);
        ParquetProperties parquetProps = ParquetProperties.builder().withDictionaryEncoding(false).build();
        ValuesWriter rdValues = parquetProps.newDefinitionLevelWriter(column);
        for (int i2 = 0; i2 < 10; ++i2) {
            rdValues.writeInteger(0);
        }
        BytesInput rd = BytesInput.from((byte[])rdValues.getBytes().toByteArray());
        DeltaByteArrayWriter writer = this.getDeltaByteArrayWriter();
        String lastValue = null;
        ArrayList<String> values = new ArrayList<String>();
        for (i = 0; i < 10; ++i) {
            lastValue = this.str(i);
            writer.writeBytes(Binary.fromString((String)lastValue));
            values.add(lastValue);
        }
        memWriter.writePage(BytesInput.concat((BytesInput[])new BytesInput[]{rd, rd, writer.getBytes()}), 10, (Statistics)new BinaryStatistics(), rdValues.getEncoding(), rdValues.getEncoding(), writer.getEncoding());
        pages.addRowCount(10L);
        writer.reset();
        this.corruptWriter(writer, lastValue);
        for (i = 10; i < 20; ++i) {
            String value = this.str(i);
            writer.writeBytes(Binary.fromString((String)value));
            values.add(value);
        }
        memWriter.writePage(BytesInput.concat((BytesInput[])new BytesInput[]{rd, rd, writer.getBytes()}), 10, (Statistics)new BinaryStatistics(), rdValues.getEncoding(), rdValues.getEncoding(), writer.getEncoding());
        pages.addRowCount(10L);
        final ArrayList actualValues = new ArrayList();
        PrimitiveConverter converter = new PrimitiveConverter(){

            public void addBinary(Binary value) {
                actualValues.add(value.toStringUsingUTF8());
            }
        };
        ColumnReaderImpl columnReader = new ColumnReaderImpl(column, pages.getPageReader(column), converter, new VersionParser.ParsedVersion("parquet-mr", "1.6.0", "abcd"));
        while ((long)actualValues.size() < columnReader.getTotalValueCount()) {
            columnReader.writeCurrentValueToConverter();
            columnReader.consume();
        }
        Assert.assertEquals(values, actualValues);
    }

    @Test
    public void testPreviousReaderSetting() {
        Binary previous = Binary.fromString((String)"<<<PREVIOUS>>>");
        DeltaByteArrayReader previousReader = new DeltaByteArrayReader();
        this.setPrevious(previousReader, previous);
        DeltaByteArrayReader reader = new DeltaByteArrayReader();
        reader.setPreviousReader((ValuesReader)previousReader);
        Assert.assertSame((Object)previous, (Object)this.getPrevious(reader));
        reader.setPreviousReader(null);
        Assert.assertSame((String)"The previous field should have not changed", (Object)previous, (Object)this.getPrevious(reader));
        reader.setPreviousReader((ValuesReader)Mockito.mock(DictionaryValuesReader.class));
        Assert.assertSame((String)"The previous field should have not changed", (Object)previous, (Object)this.getPrevious(reader));
    }

    private Binary getPrevious(DeltaByteArrayReader reader) {
        try {
            Field previousField = reader.getClass().getDeclaredField("previous");
            previousField.setAccessible(true);
            return (Binary)previousField.get(reader);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new AssertionError("Unable to get the private field \"previous\" of the reader" + reader, e);
        }
    }

    private void setPrevious(DeltaByteArrayReader reader, Binary previous) {
        try {
            Field previousField = reader.getClass().getDeclaredField("previous");
            previousField.setAccessible(true);
            previousField.set(reader, previous);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new AssertionError("Unable to set the private field \"previous\" of the reader" + reader, e);
        }
    }

    public void corruptWriter(DeltaByteArrayWriter writer, String data) throws Exception {
        Field previous = writer.getClass().getDeclaredField("previous");
        previous.setAccessible(true);
        previous.set(writer, Binary.fromString((String)data).getBytesUnsafe());
    }

    public String str(int i) {
        int c = 97;
        return "aaaaaaaaaaa" + (char)(c + i);
    }
}

