/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.internal.column.columnindex;

import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.Random;
import org.apache.parquet.internal.column.columnindex.BinaryTruncator;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveComparator;
import org.apache.parquet.schema.PrimitiveStringifier;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Types;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestBinaryTruncator {
    private static final Logger LOG = LoggerFactory.getLogger(TestBinaryTruncator.class);
    private static final PrimitiveStringifier HEXA_STRINGIFIER = ((PrimitiveType)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("dummy_type")).stringifier();
    private static final Random RANDOM = new Random(42L);
    private static final CharsetDecoder UTF8_DECODER = StandardCharsets.UTF_8.newDecoder();
    private static final String UTF8_1BYTE_MAX_CHAR = "\u007f";
    private static final String UTF8_2BYTES_MAX_CHAR = "\u07ff";
    private static final String UTF8_3BYTES_MAX_CHAR = "\uffff";
    private static final String UTF8_4BYTES_MAX_CHAR = "\udbff\udfff";

    @Test
    public void testNonStringTruncate() {
        BinaryTruncator truncator = BinaryTruncator.getTruncator((PrimitiveType)((PrimitiveType)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.DECIMAL)).precision(10)).scale(2)).named("test_binary_decimal")));
        Assert.assertEquals((Object)TestBinaryTruncator.binary(255, 254, 253, 252, 251, 250), (Object)truncator.truncateMin(TestBinaryTruncator.binary(255, 254, 253, 252, 251, 250), 2));
        Assert.assertEquals((Object)TestBinaryTruncator.binary(1, 2, 3, 4, 5, 6), (Object)truncator.truncateMax(TestBinaryTruncator.binary(1, 2, 3, 4, 5, 6), 2));
    }

    @Test
    public void testContractNonStringTypes() {
        this.testTruncator((PrimitiveType)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(8)).as(OriginalType.DECIMAL)).precision(18)).scale(4)).named("test_fixed_decimal"), false);
        this.testTruncator((PrimitiveType)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(12)).as(OriginalType.INTERVAL)).named("test_fixed_interval"), false);
        this.testTruncator((PrimitiveType)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.DECIMAL)).precision(10)).scale(2)).named("test_binary_decimal"), false);
        this.testTruncator((PrimitiveType)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT96).named("test_int96"), false);
    }

    @Test
    public void testStringTruncate() {
        BinaryTruncator truncator = BinaryTruncator.getTruncator((PrimitiveType)((PrimitiveType)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.UTF8)).named("test_utf8")));
        Assert.assertEquals((Object)Binary.fromString((String)"abc"), (Object)truncator.truncateMin(Binary.fromString((String)"abcdef"), 3));
        Assert.assertEquals((Object)Binary.fromString((String)"abd"), (Object)truncator.truncateMax(Binary.fromString((String)"abcdef"), 3));
        Assert.assertEquals((Object)Binary.fromString((String)"\u00e1rv\u00edzt"), (Object)truncator.truncateMin(Binary.fromString((String)"\u00e1rv\u00edzt\u0171r\u0151"), 9));
        Assert.assertEquals((Object)Binary.fromString((String)"\u00e1rv\u00edzu"), (Object)truncator.truncateMax(Binary.fromString((String)"\u00e1rv\u00edzt\u0171r\u0151"), 9));
        Assert.assertEquals((Object)Binary.fromString((String)"\u007f\u07ff"), (Object)truncator.truncateMin(Binary.fromString((String)"\u007f\u07ff\uffff\udbff\udfff"), 5));
        Assert.assertEquals((Object)Binary.fromString((String)"\u007f\u07ff\uffff\udbff\udfff"), (Object)truncator.truncateMax(Binary.fromString((String)"\u007f\u07ff\uffff\udbff\udfff"), 5));
        Assert.assertEquals((Object)Binary.fromString((String)"\u007f\u07ffb\uffff"), (Object)truncator.truncateMax(Binary.fromString((String)"\u007f\u07ffa\uffff\udbff\udfff"), 10));
        Assert.assertEquals((Object)TestBinaryTruncator.binary(255, 254, 253), (Object)truncator.truncateMin(TestBinaryTruncator.binary(255, 254, 253, 252, 251, 250), 3));
        Assert.assertEquals((Object)TestBinaryTruncator.binary(255, 254, 254), (Object)truncator.truncateMax(TestBinaryTruncator.binary(255, 254, 253, 252, 251, 250), 3));
        Assert.assertEquals((Object)TestBinaryTruncator.binary(255, 254, 254, 0, 0), (Object)truncator.truncateMax(TestBinaryTruncator.binary(255, 254, 253, 255, 255, 255), 5));
    }

    @Test
    public void testContractStringTypes() {
        this.testTruncator((PrimitiveType)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("test_binary"), true);
        this.testTruncator((PrimitiveType)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.UTF8)).named("test_utf8"), true);
        this.testTruncator((PrimitiveType)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.ENUM)).named("test_enum"), true);
        this.testTruncator((PrimitiveType)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.JSON)).named("test_json"), true);
        this.testTruncator((PrimitiveType)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.BSON)).named("test_bson"), true);
        this.testTruncator((PrimitiveType)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(5)).named("test_fixed"), true);
    }

    private void testTruncator(PrimitiveType type, boolean strict) {
        BinaryTruncator truncator = BinaryTruncator.getTruncator((PrimitiveType)type);
        PrimitiveComparator comparator = type.comparator();
        this.checkContract(truncator, (Comparator<Binary>)comparator, Binary.fromString((String)"aaaaaaaaaa"), strict, strict);
        this.checkContract(truncator, (Comparator<Binary>)comparator, Binary.fromString((String)"\u00e1rv\u00edzt\u0171r\u0151 t\u00fck\u00f6rf\u00far\u00f3g\u00e9p"), strict, strict);
        this.checkContract(truncator, (Comparator<Binary>)comparator, Binary.fromString((String)"aaaaaaaaaa\uffff"), strict, strict);
        this.checkContract(truncator, (Comparator<Binary>)comparator, Binary.fromString((String)"a\uffff\u007f"), strict, strict);
        this.checkContract(truncator, (Comparator<Binary>)comparator, Binary.fromConstantByteArray((byte[])new byte[]{-2, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, -1}), strict, strict);
        this.checkContract(truncator, (Comparator<Binary>)comparator, Binary.fromString((String)""), false, false);
        this.checkContract(truncator, (Comparator<Binary>)comparator, Binary.fromString((String)"\u007f\udbff\udfff\uffff\udbff\udfff\u07ff\uffff\uffff\u007f\u07ff\uffff\udbff\udfff"), strict, false);
        this.checkContract(truncator, (Comparator<Binary>)comparator, TestBinaryTruncator.binary(255, 255, 255, 255, 255, 255, 255, 255, 255, 255), strict, false);
    }

    private void checkContract(BinaryTruncator truncator, Comparator<Binary> comparator, Binary value, boolean strictMin, boolean strictMax) {
        int length = value.length();
        Assert.assertSame((Object)value, (Object)truncator.truncateMin(value, length));
        Assert.assertSame((Object)value, (Object)truncator.truncateMax(value, length));
        Assert.assertSame((Object)value, (Object)truncator.truncateMin(value, TestBinaryTruncator.random(length + 1, length * 2 + 1)));
        Assert.assertSame((Object)value, (Object)truncator.truncateMax(value, TestBinaryTruncator.random(length + 1, length * 2 + 1)));
        if (length > 1) {
            this.checkMinContract(truncator, comparator, value, length - 1, strictMin);
            this.checkMaxContract(truncator, comparator, value, length - 1, strictMax);
            this.checkMinContract(truncator, comparator, value, TestBinaryTruncator.random(1, length - 1), strictMin);
            this.checkMaxContract(truncator, comparator, value, TestBinaryTruncator.random(1, length - 1), strictMax);
        }
        this.checkMinContract(truncator, comparator, value, 0, strictMin);
        Assert.assertSame((Object)value, (Object)truncator.truncateMax(value, 0));
    }

    private void checkMinContract(BinaryTruncator truncator, Comparator<Binary> comparator, Binary value, int length, boolean strict) {
        Binary truncated = truncator.truncateMin(value, length);
        LOG.debug("\"{}\" --truncMin({})--> \"{}\" [{}]", new Object[]{value.toStringUsingUTF8(), length, truncated.toStringUsingUTF8(), HEXA_STRINGIFIER.stringify(truncated)});
        Assert.assertTrue((String)"truncatedMin(value) should be <= than value", (comparator.compare(truncated, value) <= 0 ? 1 : 0) != 0);
        Assert.assertFalse((String)"length of truncateMin(value) should not be > than the length of value", (truncated.length() > value.length() ? 1 : 0) != 0);
        if (TestBinaryTruncator.isValidUtf8(value)) {
            TestBinaryTruncator.checkValidUtf8(truncated);
        }
        if (strict) {
            Assert.assertTrue((String)"length of truncateMin(value) ahould be < than the length of value", (truncated.length() < value.length() ? 1 : 0) != 0);
        }
    }

    private void checkMaxContract(BinaryTruncator truncator, Comparator<Binary> comparator, Binary value, int length, boolean strict) {
        Binary truncated = truncator.truncateMax(value, length);
        LOG.debug("\"{}\" --truncMax({})--> \"{}\" [{}]", new Object[]{value.toStringUsingUTF8(), length, truncated.toStringUsingUTF8(), HEXA_STRINGIFIER.stringify(truncated)});
        Assert.assertTrue((String)"truncatedMax(value) should be >= than value", (comparator.compare(truncated, value) >= 0 ? 1 : 0) != 0);
        Assert.assertFalse((String)"length of truncateMax(value) should not be > than the length of value", (truncated.length() > value.length() ? 1 : 0) != 0);
        if (TestBinaryTruncator.isValidUtf8(value)) {
            TestBinaryTruncator.checkValidUtf8(truncated);
        }
        if (strict) {
            Assert.assertTrue((String)"length of truncateMax(value) ahould be < than the length of value", (truncated.length() < value.length() ? 1 : 0) != 0);
        }
    }

    private static boolean isValidUtf8(Binary binary) {
        try {
            UTF8_DECODER.decode(binary.toByteBuffer());
            return true;
        }
        catch (CharacterCodingException e) {
            return false;
        }
    }

    private static void checkValidUtf8(Binary binary) {
        try {
            UTF8_DECODER.decode(binary.toByteBuffer());
        }
        catch (CharacterCodingException e) {
            throw new AssertionError("Truncated value should be a valid UTF-8 string", e);
        }
    }

    private static int random(int min, int max) {
        return RANDOM.nextInt(max - min + 1) + min;
    }

    private static Binary binary(int ... unsignedBytes) {
        byte[] byteArray = new byte[unsignedBytes.length];
        int n = byteArray.length;
        for (int i = 0; i < n; ++i) {
            int b = unsignedBytes[i];
            assert ((0xFFFFFF00 & b) == 0);
            byteArray[i] = (byte)b;
        }
        return Binary.fromConstantByteArray((byte[])byteArray);
    }

    static {
        UTF8_DECODER.onMalformedInput(CodingErrorAction.REPORT);
        UTF8_DECODER.onUnmappableCharacter(CodingErrorAction.REPORT);
    }
}

