/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.filter2.predicate;

import org.apache.parquet.filter2.predicate.DummyUdp;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.filter2.predicate.Operators;
import org.apache.parquet.filter2.predicate.SchemaCompatibilityValidator;
import org.apache.parquet.filter2.predicate.Statistics;
import org.apache.parquet.filter2.predicate.UserDefinedPredicate;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;
import org.junit.Assert;
import org.junit.Test;

public class TestSchemaCompatibilityValidator {
    private static final Operators.BinaryColumn stringC = FilterApi.binaryColumn((String)"c");
    private static final Operators.LongColumn longBar = FilterApi.longColumn((String)"x.bar");
    private static final Operators.IntColumn intBar = FilterApi.intColumn((String)"x.bar");
    private static final Operators.LongColumn lotsOfLongs = FilterApi.longColumn((String)"lotsOfLongs");
    private static final String schemaString = "message Document {\n  required int32 a;\n  required binary b;\n  required binary c (UTF8);\n  required group x { required int32 bar; }\n  repeated int64 lotsOfLongs;\n}\n";
    private static final MessageType schema = MessageTypeParser.parseMessageType((String)"message Document {\n  required int32 a;\n  required binary b;\n  required binary c (UTF8);\n  required group x { required int32 bar; }\n  repeated int64 lotsOfLongs;\n}\n");
    private static final FilterPredicate complexValid = FilterApi.and((FilterPredicate)FilterApi.or((FilterPredicate)FilterApi.ltEq((Operators.Column)stringC, (Comparable)Binary.fromString((String)"foo")), (FilterPredicate)FilterApi.and((FilterPredicate)FilterApi.not((FilterPredicate)FilterApi.or((FilterPredicate)FilterApi.eq((Operators.Column)intBar, (Comparable)Integer.valueOf(17)), (FilterPredicate)FilterApi.notEq((Operators.Column)intBar, (Comparable)Integer.valueOf(17)))), (FilterPredicate)FilterApi.userDefined((Operators.Column)intBar, DummyUdp.class))), (FilterPredicate)FilterApi.or((FilterPredicate)FilterApi.gt((Operators.Column)stringC, (Comparable)Binary.fromString((String)"bar")), (FilterPredicate)FilterApi.notEq((Operators.Column)stringC, (Comparable)Binary.fromString((String)"baz"))));
    private static final FilterPredicate complexWrongType = FilterApi.and((FilterPredicate)FilterApi.or((FilterPredicate)FilterApi.ltEq((Operators.Column)stringC, (Comparable)Binary.fromString((String)"foo")), (FilterPredicate)FilterApi.and((FilterPredicate)FilterApi.not((FilterPredicate)FilterApi.or((FilterPredicate)FilterApi.eq((Operators.Column)longBar, (Comparable)Long.valueOf(17L)), (FilterPredicate)FilterApi.notEq((Operators.Column)longBar, (Comparable)Long.valueOf(17L)))), (FilterPredicate)FilterApi.userDefined((Operators.Column)longBar, LongDummyUdp.class))), (FilterPredicate)FilterApi.or((FilterPredicate)FilterApi.gt((Operators.Column)stringC, (Comparable)Binary.fromString((String)"bar")), (FilterPredicate)FilterApi.notEq((Operators.Column)stringC, (Comparable)Binary.fromString((String)"baz"))));
    private static final FilterPredicate complexMixedType = FilterApi.and((FilterPredicate)FilterApi.or((FilterPredicate)FilterApi.ltEq((Operators.Column)stringC, (Comparable)Binary.fromString((String)"foo")), (FilterPredicate)FilterApi.and((FilterPredicate)FilterApi.not((FilterPredicate)FilterApi.or((FilterPredicate)FilterApi.eq((Operators.Column)intBar, (Comparable)Integer.valueOf(17)), (FilterPredicate)FilterApi.notEq((Operators.Column)longBar, (Comparable)Long.valueOf(17L)))), (FilterPredicate)FilterApi.userDefined((Operators.Column)longBar, LongDummyUdp.class))), (FilterPredicate)FilterApi.or((FilterPredicate)FilterApi.gt((Operators.Column)stringC, (Comparable)Binary.fromString((String)"bar")), (FilterPredicate)FilterApi.notEq((Operators.Column)stringC, (Comparable)Binary.fromString((String)"baz"))));

    @Test
    public void testValidType() {
        SchemaCompatibilityValidator.validate((FilterPredicate)complexValid, (MessageType)schema);
    }

    @Test
    public void testFindsInvalidTypes() {
        try {
            SchemaCompatibilityValidator.validate((FilterPredicate)complexWrongType, (MessageType)schema);
            Assert.fail((String)"this should throw");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"FilterPredicate column: x.bar's declared type (java.lang.Long) does not match the schema found in file metadata. Column x.bar is of type: INT32\nValid types for this column are: [class java.lang.Integer]", (Object)e.getMessage());
        }
    }

    @Test
    public void testTwiceDeclaredColumn() {
        SchemaCompatibilityValidator.validate((FilterPredicate)FilterApi.eq((Operators.Column)stringC, (Comparable)Binary.fromString((String)"larry")), (MessageType)schema);
        try {
            SchemaCompatibilityValidator.validate((FilterPredicate)complexMixedType, (MessageType)schema);
            Assert.fail((String)"this should throw");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Column: x.bar was provided with different types in the same predicate. Found both: (class java.lang.Integer, class java.lang.Long)", (Object)e.getMessage());
        }
    }

    @Test
    public void testRepeatedNotSupportedForPrimitivePredicates() {
        try {
            SchemaCompatibilityValidator.validate((FilterPredicate)FilterApi.eq((Operators.Column)lotsOfLongs, (Comparable)Long.valueOf(10L)), (MessageType)schema);
            Assert.fail((String)"this should throw");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"FilterPredicates do not currently support repeated columns. Column lotsOfLongs is repeated.", (Object)e.getMessage());
        }
    }

    @Test
    public void testRepeatedSupportedForContainsPredicates() {
        try {
            SchemaCompatibilityValidator.validate((FilterPredicate)FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.eq((Operators.Column)lotsOfLongs, (Comparable)Long.valueOf(10L))), (MessageType)schema);
            SchemaCompatibilityValidator.validate((FilterPredicate)FilterApi.and((FilterPredicate)FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.eq((Operators.Column)lotsOfLongs, (Comparable)Long.valueOf(10L))), (FilterPredicate)FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.eq((Operators.Column)lotsOfLongs, (Comparable)Long.valueOf(5L)))), (MessageType)schema);
            SchemaCompatibilityValidator.validate((FilterPredicate)FilterApi.or((FilterPredicate)FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.eq((Operators.Column)lotsOfLongs, (Comparable)Long.valueOf(10L))), (FilterPredicate)FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.eq((Operators.Column)lotsOfLongs, (Comparable)Long.valueOf(5L)))), (MessageType)schema);
        }
        catch (IllegalArgumentException e) {
            Assert.fail((String)"Valid repeated column predicates should not throw exceptions");
        }
    }

    @Test
    public void testNonRepeatedNotSupportedForContainsPredicates() {
        try {
            SchemaCompatibilityValidator.validate((FilterPredicate)FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.eq((Operators.Column)longBar, (Comparable)Long.valueOf(10L))), (MessageType)schema);
            Assert.fail((String)("Non-repeated field " + longBar + " should fail to validate a containsEq() predicate"));
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"FilterPredicate for column x.bar requires a repeated schema, but found max repetition level 0", (Object)e.getMessage());
        }
    }

    static class LongDummyUdp
    extends UserDefinedPredicate<Long> {
        LongDummyUdp() {
        }

        public boolean keep(Long value) {
            return false;
        }

        public boolean canDrop(Statistics<Long> statistics) {
            return false;
        }

        public boolean inverseCanDrop(Statistics<Long> statistics) {
            return false;
        }
    }
}

