/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column.mem;

import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.ColumnReader;
import org.apache.parquet.column.ColumnWriter;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.column.impl.ColumnReadStoreImpl;
import org.apache.parquet.column.impl.ColumnWriteStoreV1;
import org.apache.parquet.column.impl.ColumnWriteStoreV2;
import org.apache.parquet.column.page.DataPage;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.column.page.PageReader;
import org.apache.parquet.column.page.PageWriteStore;
import org.apache.parquet.column.page.mem.MemPageStore;
import org.apache.parquet.example.DummyRecordConverter;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Types;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestMemColumn {
    private static final Logger LOG = LoggerFactory.getLogger(TestMemColumn.class);

    @Test
    public void testMemColumn() throws Exception {
        MessageType schema = MessageTypeParser.parseMessageType((String)"message msg { required group foo { required int64 bar; } }");
        ColumnDescriptor path = schema.getColumnDescription(new String[]{"foo", "bar"});
        MemPageStore memPageStore = new MemPageStore(10L);
        ColumnWriteStoreV1 memColumnsStore = this.newColumnWriteStoreImpl(memPageStore);
        ColumnWriter columnWriter = memColumnsStore.getColumnWriter(path);
        columnWriter.write(42L, 0, 0);
        memColumnsStore.endRecord();
        memColumnsStore.flush();
        ColumnReader columnReader = this.getColumnReader(memPageStore, path, schema);
        int i = 0;
        while ((long)i < columnReader.getTotalValueCount()) {
            Assert.assertEquals((long)columnReader.getCurrentRepetitionLevel(), (long)0L);
            Assert.assertEquals((long)columnReader.getCurrentDefinitionLevel(), (long)0L);
            Assert.assertEquals((long)columnReader.getLong(), (long)42L);
            columnReader.consume();
            ++i;
        }
    }

    private ColumnWriter getColumnWriter(ColumnDescriptor path, MemPageStore memPageStore) {
        ColumnWriteStoreV1 memColumnsStore = this.newColumnWriteStoreImpl(memPageStore);
        ColumnWriter columnWriter = memColumnsStore.getColumnWriter(path);
        return columnWriter;
    }

    private ColumnReader getColumnReader(MemPageStore memPageStore, ColumnDescriptor path, MessageType schema) {
        return new ColumnReadStoreImpl((PageReadStore)memPageStore, new DummyRecordConverter(schema).getRootConverter(), schema, null).getColumnReader(path);
    }

    @Test
    public void testMemColumnBinary() throws Exception {
        ColumnDescriptor path1;
        MessageType mt = MessageTypeParser.parseMessageType((String)"message msg { required group foo { required binary bar; } }");
        String[] col = new String[]{"foo", "bar"};
        MemPageStore memPageStore = new MemPageStore(10L);
        ColumnWriteStoreV1 memColumnsStore = this.newColumnWriteStoreImpl(memPageStore);
        ColumnDescriptor path = path1 = mt.getColumnDescription(col);
        ColumnWriter columnWriter = memColumnsStore.getColumnWriter(path);
        columnWriter.write(Binary.fromString((String)"42"), 0, 0);
        memColumnsStore.endRecord();
        memColumnsStore.flush();
        ColumnReader columnReader = this.getColumnReader(memPageStore, path, mt);
        int i = 0;
        while ((long)i < columnReader.getTotalValueCount()) {
            Assert.assertEquals((long)columnReader.getCurrentRepetitionLevel(), (long)0L);
            Assert.assertEquals((long)columnReader.getCurrentDefinitionLevel(), (long)0L);
            Assert.assertEquals((Object)columnReader.getBinary().toStringUsingUTF8(), (Object)"42");
            columnReader.consume();
            ++i;
        }
    }

    @Test
    public void testMemColumnBinaryExceedIntMaxValue() throws Exception {
        MessageType mt = MessageTypeParser.parseMessageType((String)"message msg { required group v (LIST) { repeated group list { optional binary element; } } }");
        String[] col = new String[]{"v", "list", "element"};
        MemPageStore memPageStore = new MemPageStore(100L);
        ColumnWriteStoreV1 memColumnsStore = this.newColumnWriteStoreImpl(memPageStore);
        ColumnDescriptor path = mt.getColumnDescription(col);
        ColumnWriter columnWriter = memColumnsStore.getColumnWriter(path);
        int numRows = 20000;
        int numEntries = 110000;
        for (int row = 0; row < numRows; ++row) {
            columnWriter.writeNull(0, 1);
            for (int i = 1; i < numEntries; ++i) {
                columnWriter.writeNull(1, 1);
            }
            memColumnsStore.endRecord();
        }
        memColumnsStore.flush();
        ColumnReader columnReader = this.getColumnReader(memPageStore, path, mt);
        Assert.assertEquals((String)"parquet page value-count should fit on the signed-int range", (long)columnReader.getTotalValueCount(), (long)((long)numRows * (long)numEntries));
    }

    @Test
    public void testMemColumnSeveralPages() throws Exception {
        ColumnDescriptor path1;
        MessageType mt = MessageTypeParser.parseMessageType((String)"message msg { required group foo { required int64 bar; } }");
        String[] col = new String[]{"foo", "bar"};
        MemPageStore memPageStore = new MemPageStore(10L);
        ColumnWriteStoreV1 memColumnsStore = this.newColumnWriteStoreImpl(memPageStore);
        ColumnDescriptor path = path1 = mt.getColumnDescription(col);
        ColumnWriter columnWriter = memColumnsStore.getColumnWriter(path);
        for (int i = 0; i < 2000; ++i) {
            columnWriter.write(42L, 0, 0);
            memColumnsStore.endRecord();
        }
        memColumnsStore.flush();
        ColumnReader columnReader = this.getColumnReader(memPageStore, path, mt);
        int i = 0;
        while ((long)i < columnReader.getTotalValueCount()) {
            Assert.assertEquals((long)columnReader.getCurrentRepetitionLevel(), (long)0L);
            Assert.assertEquals((long)columnReader.getCurrentDefinitionLevel(), (long)0L);
            Assert.assertEquals((long)columnReader.getLong(), (long)42L);
            columnReader.consume();
            ++i;
        }
    }

    @Test
    public void testMemColumnSeveralPagesRepeated() throws Exception {
        ColumnDescriptor path1;
        MessageType mt = MessageTypeParser.parseMessageType((String)"message msg { repeated group foo { repeated int64 bar; } }");
        String[] col = new String[]{"foo", "bar"};
        MemPageStore memPageStore = new MemPageStore(10L);
        ColumnWriteStoreV1 memColumnsStore = this.newColumnWriteStoreImpl(memPageStore);
        ColumnDescriptor path = path1 = mt.getColumnDescription(col);
        ColumnWriter columnWriter = memColumnsStore.getColumnWriter(path);
        int[] rs = new int[]{0, 0, 0, 1, 1, 1, 2, 2, 2};
        int[] ds = new int[]{0, 1, 2, 0, 1, 2, 0, 1, 2};
        for (int i = 0; i < 837; ++i) {
            int r = rs[i % rs.length];
            int d = ds[i % ds.length];
            LOG.debug("write i: {}", (Object)i);
            if (i != 0 && r == 0) {
                memColumnsStore.endRecord();
            }
            if (d == 2) {
                columnWriter.write((long)i, r, d);
                continue;
            }
            columnWriter.writeNull(r, d);
        }
        memColumnsStore.endRecord();
        memColumnsStore.flush();
        ColumnReader columnReader = this.getColumnReader(memPageStore, path, mt);
        int i = 0;
        int j = 0;
        while ((long)j < columnReader.getTotalValueCount()) {
            int r = rs[i % rs.length];
            int d = ds[i % ds.length];
            LOG.debug("read i: {}", (Object)i);
            Assert.assertEquals((String)("r row " + i), (long)r, (long)columnReader.getCurrentRepetitionLevel());
            Assert.assertEquals((String)("d row " + i), (long)d, (long)columnReader.getCurrentDefinitionLevel());
            if (d == 2) {
                Assert.assertEquals((String)("data row " + i), (long)i, (long)columnReader.getLong());
            }
            columnReader.consume();
            ++i;
            ++j;
        }
    }

    @Test
    public void testPageSize() {
        DataPage page;
        MessageType schema = (MessageType)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildMessage().requiredList().requiredElement(PrimitiveType.PrimitiveTypeName.BINARY).named("binary_col")).requiredList().requiredElement(PrimitiveType.PrimitiveTypeName.INT32).named("int32_col")).named("msg");
        MemPageStore memPageStore = new MemPageStore(123L);
        ColumnWriteStoreV2 writeStore = new ColumnWriteStoreV2(schema, (PageWriteStore)memPageStore, ParquetProperties.builder().withPageSize(1024).withMinRowCountForPageSizeCheck(1).withPageRowCountLimit(10).withDictionaryEncoding(false).build());
        ColumnDescriptor binaryCol = schema.getColumnDescription(new String[]{"binary_col", "list", "element"});
        ColumnWriter binaryColWriter = writeStore.getColumnWriter(binaryCol);
        ColumnDescriptor int32Col = schema.getColumnDescription(new String[]{"int32_col", "list", "element"});
        ColumnWriter int32ColWriter = writeStore.getColumnWriter(int32Col);
        for (int i = 0; i < 123; ++i) {
            for (int j = 0; j < 10; ++j) {
                binaryColWriter.write(Binary.fromString((String)"aaaaaaaaaaaa"), j == 0 ? 0 : binaryCol.getMaxRepetitionLevel(), binaryCol.getMaxDefinitionLevel());
                int32ColWriter.write(42, j == 0 ? 0 : int32Col.getMaxRepetitionLevel(), int32Col.getMaxDefinitionLevel());
            }
            writeStore.endRecord();
        }
        writeStore.flush();
        PageReader binaryColPageReader = memPageStore.getPageReader(binaryCol);
        Assert.assertEquals((long)1230L, (long)binaryColPageReader.getTotalValueCount());
        int pageCnt = 0;
        int valueCnt = 0;
        while ((long)valueCnt < binaryColPageReader.getTotalValueCount()) {
            page = binaryColPageReader.readPage();
            valueCnt += page.getValueCount();
            LOG.info("binary_col page-{}: {} bytes, {} rows", new Object[]{++pageCnt, page.getCompressedSize(), page.getIndexRowCount().get()});
            Assert.assertTrue((String)"Compressed size should be less than 1024", (page.getCompressedSize() <= 1024 ? 1 : 0) != 0);
        }
        PageReader int32ColPageReader = memPageStore.getPageReader(int32Col);
        Assert.assertEquals((long)1230L, (long)int32ColPageReader.getTotalValueCount());
        pageCnt = 0;
        valueCnt = 0;
        while ((long)valueCnt < int32ColPageReader.getTotalValueCount()) {
            page = int32ColPageReader.readPage();
            valueCnt += page.getValueCount();
            LOG.info("int32_col page-{}: {} bytes, {} rows", new Object[]{++pageCnt, page.getCompressedSize(), page.getIndexRowCount().get()});
            Assert.assertTrue((String)"Row count should be less than 10", ((Integer)page.getIndexRowCount().get() <= 10 ? 1 : 0) != 0);
        }
    }

    private ColumnWriteStoreV1 newColumnWriteStoreImpl(MemPageStore memPageStore) {
        return new ColumnWriteStoreV1((PageWriteStore)memPageStore, ParquetProperties.builder().withDictionaryEncoding(false).build());
    }
}

