/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.internal.filter2.columnindex;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.util.Arrays;
import java.util.PrimitiveIterator;
import org.apache.parquet.internal.column.columnindex.OffsetIndex;
import org.apache.parquet.internal.column.columnindex.OffsetIndexBuilder;
import org.apache.parquet.internal.filter2.columnindex.RowRanges;
import org.junit.Assert;
import org.junit.Test;

public class TestRowRanges {
    private static RowRanges buildRanges(final long ... rowIndexes) {
        if (rowIndexes.length == 0) {
            return RowRanges.EMPTY;
        }
        OffsetIndexBuilder builder = OffsetIndexBuilder.getBuilder();
        int n = rowIndexes.length;
        for (int i = 0; i < n; i += 2) {
            long from = rowIndexes[i];
            long to = rowIndexes[i + 1];
            builder.add(0L, 0, from);
            builder.add(0L, 0, to + 1L);
        }
        PrimitiveIterator.OfInt pageIndexes = new PrimitiveIterator.OfInt(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < rowIndexes.length;
            }

            @Override
            public int nextInt() {
                int ret = this.index;
                this.index += 2;
                return ret;
            }
        };
        return RowRanges.create((long)rowIndexes[rowIndexes.length - 1], (PrimitiveIterator.OfInt)pageIndexes, (OffsetIndex)builder.build());
    }

    private static void assertAllRowsEqual(PrimitiveIterator.OfLong actualIt, long ... expectedValues) {
        LongArrayList actualList = new LongArrayList();
        actualIt.forEachRemaining(arg_0 -> TestRowRanges.lambda$assertAllRowsEqual$0((LongList)actualList, arg_0));
        Assert.assertArrayEquals((String)(Arrays.toString(expectedValues) + "!= " + actualList), (long[])expectedValues, (long[])actualList.toLongArray());
    }

    @Test
    public void testCreate() {
        RowRanges ranges = TestRowRanges.buildRanges(1L, 2L, 3L, 4L, 6L, 7L, 7L, 10L, 15L, 17L);
        TestRowRanges.assertAllRowsEqual(ranges.iterator(), 1L, 2L, 3L, 4L, 6L, 7L, 8L, 9L, 10L, 15L, 16L, 17L);
        Assert.assertEquals((long)12L, (long)ranges.rowCount());
        Assert.assertTrue((boolean)ranges.isOverlapping(4L, 5L));
        Assert.assertFalse((boolean)ranges.isOverlapping(5L, 5L));
        Assert.assertTrue((boolean)ranges.isOverlapping(10L, 14L));
        Assert.assertFalse((boolean)ranges.isOverlapping(11L, 14L));
        Assert.assertFalse((boolean)ranges.isOverlapping(18L, Long.MAX_VALUE));
        ranges = RowRanges.createSingle((long)5L);
        TestRowRanges.assertAllRowsEqual(ranges.iterator(), 0L, 1L, 2L, 3L, 4L);
        Assert.assertEquals((long)5L, (long)ranges.rowCount());
        Assert.assertTrue((boolean)ranges.isOverlapping(0L, 100L));
        Assert.assertFalse((boolean)ranges.isOverlapping(5L, Long.MAX_VALUE));
        ranges = RowRanges.EMPTY;
        TestRowRanges.assertAllRowsEqual(ranges.iterator(), new long[0]);
        Assert.assertEquals((long)0L, (long)ranges.rowCount());
        Assert.assertFalse((boolean)ranges.isOverlapping(0L, Long.MAX_VALUE));
    }

    @Test
    public void testUnion() {
        RowRanges ranges1 = TestRowRanges.buildRanges(2L, 5L, 7L, 9L, 14L, 14L, 20L, 24L);
        RowRanges ranges2 = TestRowRanges.buildRanges(1L, 2L, 4L, 5L, 11L, 12L, 14L, 15L, 21L, 22L);
        RowRanges empty = TestRowRanges.buildRanges(new long[0]);
        TestRowRanges.assertAllRowsEqual(RowRanges.union((RowRanges)ranges1, (RowRanges)ranges2).iterator(), 1L, 2L, 3L, 4L, 5L, 7L, 8L, 9L, 11L, 12L, 14L, 15L, 20L, 21L, 22L, 23L, 24L);
        TestRowRanges.assertAllRowsEqual(RowRanges.union((RowRanges)ranges2, (RowRanges)ranges1).iterator(), 1L, 2L, 3L, 4L, 5L, 7L, 8L, 9L, 11L, 12L, 14L, 15L, 20L, 21L, 22L, 23L, 24L);
        TestRowRanges.assertAllRowsEqual(RowRanges.union((RowRanges)ranges1, (RowRanges)ranges1).iterator(), 2L, 3L, 4L, 5L, 7L, 8L, 9L, 14L, 20L, 21L, 22L, 23L, 24L);
        TestRowRanges.assertAllRowsEqual(RowRanges.union((RowRanges)ranges1, (RowRanges)empty).iterator(), 2L, 3L, 4L, 5L, 7L, 8L, 9L, 14L, 20L, 21L, 22L, 23L, 24L);
        TestRowRanges.assertAllRowsEqual(RowRanges.union((RowRanges)empty, (RowRanges)ranges1).iterator(), 2L, 3L, 4L, 5L, 7L, 8L, 9L, 14L, 20L, 21L, 22L, 23L, 24L);
        TestRowRanges.assertAllRowsEqual(RowRanges.union((RowRanges)ranges2, (RowRanges)ranges2).iterator(), 1L, 2L, 4L, 5L, 11L, 12L, 14L, 15L, 21L, 22L);
        TestRowRanges.assertAllRowsEqual(RowRanges.union((RowRanges)ranges2, (RowRanges)empty).iterator(), 1L, 2L, 4L, 5L, 11L, 12L, 14L, 15L, 21L, 22L);
        TestRowRanges.assertAllRowsEqual(RowRanges.union((RowRanges)empty, (RowRanges)ranges2).iterator(), 1L, 2L, 4L, 5L, 11L, 12L, 14L, 15L, 21L, 22L);
        TestRowRanges.assertAllRowsEqual(RowRanges.union((RowRanges)empty, (RowRanges)empty).iterator(), new long[0]);
    }

    @Test
    public void testIntersection() {
        RowRanges ranges1 = TestRowRanges.buildRanges(2L, 5L, 7L, 9L, 14L, 14L, 20L, 24L);
        RowRanges ranges2 = TestRowRanges.buildRanges(1L, 2L, 6L, 7L, 9L, 9L, 11L, 12L, 14L, 15L, 21L, 22L);
        RowRanges empty = TestRowRanges.buildRanges(new long[0]);
        TestRowRanges.assertAllRowsEqual(RowRanges.intersection((RowRanges)ranges1, (RowRanges)ranges2).iterator(), 2L, 7L, 9L, 14L, 21L, 22L);
        TestRowRanges.assertAllRowsEqual(RowRanges.intersection((RowRanges)ranges2, (RowRanges)ranges1).iterator(), 2L, 7L, 9L, 14L, 21L, 22L);
        TestRowRanges.assertAllRowsEqual(RowRanges.intersection((RowRanges)ranges1, (RowRanges)ranges1).iterator(), 2L, 3L, 4L, 5L, 7L, 8L, 9L, 14L, 20L, 21L, 22L, 23L, 24L);
        TestRowRanges.assertAllRowsEqual(RowRanges.intersection((RowRanges)ranges1, (RowRanges)empty).iterator(), new long[0]);
        TestRowRanges.assertAllRowsEqual(RowRanges.intersection((RowRanges)empty, (RowRanges)ranges1).iterator(), new long[0]);
        TestRowRanges.assertAllRowsEqual(RowRanges.intersection((RowRanges)ranges2, (RowRanges)ranges2).iterator(), 1L, 2L, 6L, 7L, 9L, 11L, 12L, 14L, 15L, 21L, 22L);
        TestRowRanges.assertAllRowsEqual(RowRanges.intersection((RowRanges)ranges2, (RowRanges)empty).iterator(), new long[0]);
        TestRowRanges.assertAllRowsEqual(RowRanges.intersection((RowRanges)empty, (RowRanges)ranges2).iterator(), new long[0]);
        TestRowRanges.assertAllRowsEqual(RowRanges.intersection((RowRanges)empty, (RowRanges)empty).iterator(), new long[0]);
    }

    private static /* synthetic */ void lambda$assertAllRowsEqual$0(LongList actualList, long value) {
        actualList.add(value);
    }
}

