/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.internal.column.columnindex;

import org.apache.parquet.internal.column.columnindex.OffsetIndex;
import org.apache.parquet.internal.column.columnindex.OffsetIndexBuilder;
import org.junit.Assert;
import org.junit.Test;

public class TestOffsetIndexBuilder {
    @Test
    public void testBuilderWithSizeAndRowCount() {
        OffsetIndexBuilder builder = OffsetIndexBuilder.getBuilder();
        Assert.assertNull((Object)builder.build());
        Assert.assertNull((Object)builder.build(1234L));
        builder.add(1000, 10L);
        builder.add(2000, 19L);
        builder.add(3000, 27L);
        builder.add(1200, 9L);
        this.assertCorrectValues(builder.build(), 0L, 1000L, 0L, 1000L, 2000L, 10L, 3000L, 3000L, 29L, 6000L, 1200L, 56L);
        this.assertCorrectValues(builder.build(10000L), 10000L, 1000L, 0L, 11000L, 2000L, 10L, 13000L, 3000L, 29L, 16000L, 1200L, 56L);
    }

    @Test
    public void testNoOpBuilderWithSizeAndRowCount() {
        OffsetIndexBuilder builder = OffsetIndexBuilder.getNoOpBuilder();
        builder.add(1, 2L);
        builder.add(3, 4L);
        builder.add(5, 6L);
        builder.add(7, 8L);
        Assert.assertNull((Object)builder.build());
        Assert.assertNull((Object)builder.build(1000L));
    }

    @Test
    public void testBuilderWithOffsetSizeIndex() {
        OffsetIndexBuilder builder = OffsetIndexBuilder.getBuilder();
        Assert.assertNull((Object)builder.build());
        Assert.assertNull((Object)builder.build(1234L));
        builder.add(1000L, 10000, 0L);
        builder.add(22000L, 12000, 100L);
        builder.add(48000L, 22000, 211L);
        builder.add(90000L, 30000, 361L);
        this.assertCorrectValues(builder.build(), 1000L, 10000L, 0L, 22000L, 12000L, 100L, 48000L, 22000L, 211L, 90000L, 30000L, 361L);
        this.assertCorrectValues(builder.build(100000L), 101000L, 10000L, 0L, 122000L, 12000L, 100L, 148000L, 22000L, 211L, 190000L, 30000L, 361L);
    }

    @Test
    public void testNoOpBuilderWithOffsetSizeIndex() {
        OffsetIndexBuilder builder = OffsetIndexBuilder.getNoOpBuilder();
        builder.add(1L, 2, 3L);
        builder.add(4L, 5, 6L);
        builder.add(7L, 8, 9L);
        builder.add(10L, 11, 12L);
        Assert.assertNull((Object)builder.build());
        Assert.assertNull((Object)builder.build(1000L));
    }

    private void assertCorrectValues(OffsetIndex offsetIndex, long ... offset_size_rowIndex_triplets) {
        Assert.assertEquals((long)(offset_size_rowIndex_triplets.length % 3), (long)0L);
        int pageCount = offset_size_rowIndex_triplets.length / 3;
        Assert.assertEquals((String)"Invalid pageCount", (long)pageCount, (long)offsetIndex.getPageCount());
        for (int i = 0; i < pageCount; ++i) {
            Assert.assertEquals((String)("Invalid offsetIndex at page " + i), (long)offset_size_rowIndex_triplets[3 * i], (long)offsetIndex.getOffset(i));
            Assert.assertEquals((String)("Invalid compressedPageSize at page " + i), (long)offset_size_rowIndex_triplets[3 * i + 1], (long)offsetIndex.getCompressedPageSize(i));
            Assert.assertEquals((String)("Invalid firstRowIndex at page " + i), (long)offset_size_rowIndex_triplets[3 * i + 2], (long)offsetIndex.getFirstRowIndex(i));
            long expectedLastPageIndex = i < pageCount - 1 ? offset_size_rowIndex_triplets[3 * i + 5] - 1L : 999L;
            Assert.assertEquals((String)("Invalid lastRowIndex at page " + i), (long)expectedLastPageIndex, (long)offsetIndex.getLastRowIndex(i, 1000L));
        }
    }
}

