/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column.values.deltastrings.benchmark;

import com.carrotsearch.junitbenchmarks.BenchmarkOptions;
import com.carrotsearch.junitbenchmarks.BenchmarkRule;
import com.carrotsearch.junitbenchmarks.annotation.AxisRange;
import com.carrotsearch.junitbenchmarks.annotation.BenchmarkMethodChart;
import java.io.IOException;
import java.util.Arrays;
import org.apache.parquet.bytes.ByteBufferAllocator;
import org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.parquet.bytes.DirectByteBufferAllocator;
import org.apache.parquet.column.values.Utils;
import org.apache.parquet.column.values.ValuesReader;
import org.apache.parquet.column.values.ValuesWriter;
import org.apache.parquet.column.values.deltastrings.DeltaByteArrayReader;
import org.apache.parquet.column.values.deltastrings.DeltaByteArrayWriter;
import org.apache.parquet.column.values.plain.BinaryPlainValuesReader;
import org.apache.parquet.column.values.plain.PlainValuesWriter;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;

@AxisRange(min=0.0, max=1.0)
@BenchmarkMethodChart(filePrefix="benchmark-encoding-writing-random")
public class BenchmarkDeltaByteArray {
    @Rule
    public TestRule benchmarkRun = new BenchmarkRule();
    static String[] values = Utils.getRandomStringSamples(1000000, 32);
    static String[] sortedVals = Arrays.copyOf(values, values.length);

    @BenchmarkOptions(benchmarkRounds=20, warmupRounds=4)
    @Test
    public void benchmarkRandomStringsWithPlainValuesWriter() throws IOException {
        PlainValuesWriter writer = new PlainValuesWriter(65536, 65536, (ByteBufferAllocator)new DirectByteBufferAllocator());
        BinaryPlainValuesReader reader = new BinaryPlainValuesReader();
        Utils.writeData((ValuesWriter)writer, values);
        ByteBufferInputStream data = writer.getBytes().toInputStream();
        Utils.readData((ValuesReader)reader, data, values.length);
        System.out.println("size " + data.position());
    }

    @BenchmarkOptions(benchmarkRounds=20, warmupRounds=4)
    @Test
    public void benchmarkRandomStringsWithDeltaLengthByteArrayValuesWriter() throws IOException {
        DeltaByteArrayWriter writer = new DeltaByteArrayWriter(65536, 65536, (ByteBufferAllocator)new DirectByteBufferAllocator());
        DeltaByteArrayReader reader = new DeltaByteArrayReader();
        Utils.writeData((ValuesWriter)writer, values);
        ByteBufferInputStream data = writer.getBytes().toInputStream();
        Utils.readData((ValuesReader)reader, data, values.length);
        System.out.println("size " + data.position());
    }

    @BenchmarkOptions(benchmarkRounds=20, warmupRounds=4)
    @Test
    public void benchmarkSortedStringsWithPlainValuesWriter() throws IOException {
        PlainValuesWriter writer = new PlainValuesWriter(65536, 65536, (ByteBufferAllocator)new DirectByteBufferAllocator());
        BinaryPlainValuesReader reader = new BinaryPlainValuesReader();
        Utils.writeData((ValuesWriter)writer, sortedVals);
        ByteBufferInputStream data = writer.getBytes().toInputStream();
        Utils.readData((ValuesReader)reader, data, values.length);
        System.out.println("size " + data.position());
    }

    @BenchmarkOptions(benchmarkRounds=20, warmupRounds=4)
    @Test
    public void benchmarkSortedStringsWithDeltaLengthByteArrayValuesWriter() throws IOException {
        DeltaByteArrayWriter writer = new DeltaByteArrayWriter(65536, 65536, (ByteBufferAllocator)new DirectByteBufferAllocator());
        DeltaByteArrayReader reader = new DeltaByteArrayReader();
        Utils.writeData((ValuesWriter)writer, sortedVals);
        ByteBufferInputStream data = writer.getBytes().toInputStream();
        Utils.readData((ValuesReader)reader, data, values.length);
        System.out.println("size " + data.position());
    }

    static {
        Arrays.sort(sortedVals);
    }
}

