/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column.values.dictionary;

import junit.framework.Assert;
import org.apache.parquet.column.values.dictionary.IntList;
import org.junit.Test;

public class IntListTest {
    @Test
    public void testSmallList() {
        int testSize = 3996;
        this.doTestIntList(testSize, 4096);
    }

    @Test
    public void testListGreaterThanInitialSlabSize() {
        int testSize = 4196;
        this.doTestIntList(testSize, 8192);
    }

    @Test
    public void testListGreaterThanMaxSlabSize() {
        int testSize = 262244;
        this.doTestIntList(testSize, 65536);
    }

    private void doTestIntList(int testSize, int expectedSlabSize) {
        IntList testList = new IntList();
        this.populateList(testList, testSize);
        this.verifyIteratorResults(testSize, testList);
        Assert.assertEquals((int)expectedSlabSize, (int)testList.getCurrentSlabSize());
    }

    private void populateList(IntList testList, int size) {
        for (int i = 0; i < size; ++i) {
            testList.add(i);
        }
    }

    private void verifyIteratorResults(int testSize, IntList testList) {
        IntList.IntIterator iterator = testList.iterator();
        int expected = 0;
        while (iterator.hasNext()) {
            int val = iterator.next();
            Assert.assertEquals((int)expected, (int)val);
            ++expected;
        }
        Assert.assertEquals((int)testSize, (int)expected);
    }
}

