/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column.values.factory;

import junit.framework.Assert;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.column.values.ValuesWriter;
import org.apache.parquet.column.values.delta.DeltaBinaryPackingValuesWriter;
import org.apache.parquet.column.values.delta.DeltaBinaryPackingValuesWriterForLong;
import org.apache.parquet.column.values.deltastrings.DeltaByteArrayWriter;
import org.apache.parquet.column.values.dictionary.DictionaryValuesWriter;
import org.apache.parquet.column.values.factory.DefaultValuesWriterFactory;
import org.apache.parquet.column.values.factory.ValuesWriterFactory;
import org.apache.parquet.column.values.fallback.FallbackValuesWriter;
import org.apache.parquet.column.values.plain.BooleanPlainValuesWriter;
import org.apache.parquet.column.values.plain.FixedLenByteArrayPlainValuesWriter;
import org.apache.parquet.column.values.plain.PlainValuesWriter;
import org.apache.parquet.column.values.rle.RunLengthBitPackingHybridValuesWriter;
import org.apache.parquet.schema.PrimitiveType;
import org.junit.Test;
import org.mockito.Mockito;

public class DefaultValuesWriterFactoryTest {
    @Test
    public void testBoolean() {
        this.doTestValueWriter(PrimitiveType.PrimitiveTypeName.BOOLEAN, ParquetProperties.WriterVersion.PARQUET_1_0, true, BooleanPlainValuesWriter.class);
    }

    @Test
    public void testBoolean_V2() {
        this.doTestValueWriter(PrimitiveType.PrimitiveTypeName.BOOLEAN, ParquetProperties.WriterVersion.PARQUET_2_0, true, RunLengthBitPackingHybridValuesWriter.class);
    }

    @Test
    public void testFixedLenByteArray() {
        this.doTestValueWriter(PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, ParquetProperties.WriterVersion.PARQUET_1_0, true, FixedLenByteArrayPlainValuesWriter.class);
    }

    @Test
    public void testFixedLenByteArray_V2() {
        this.doTestValueWriter(PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, ParquetProperties.WriterVersion.PARQUET_2_0, true, DictionaryValuesWriter.class, DeltaByteArrayWriter.class);
    }

    @Test
    public void testFixedLenByteArray_V2_NoDict() {
        this.doTestValueWriter(PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, ParquetProperties.WriterVersion.PARQUET_2_0, false, DeltaByteArrayWriter.class);
    }

    @Test
    public void testBinary() {
        this.doTestValueWriter(PrimitiveType.PrimitiveTypeName.BINARY, ParquetProperties.WriterVersion.PARQUET_1_0, true, DictionaryValuesWriter.PlainBinaryDictionaryValuesWriter.class, PlainValuesWriter.class);
    }

    @Test
    public void testBinary_NoDict() {
        this.doTestValueWriter(PrimitiveType.PrimitiveTypeName.BINARY, ParquetProperties.WriterVersion.PARQUET_1_0, false, PlainValuesWriter.class);
    }

    @Test
    public void testBinary_V2() {
        this.doTestValueWriter(PrimitiveType.PrimitiveTypeName.BINARY, ParquetProperties.WriterVersion.PARQUET_2_0, true, DictionaryValuesWriter.PlainBinaryDictionaryValuesWriter.class, DeltaByteArrayWriter.class);
    }

    @Test
    public void testBinary_V2_NoDict() {
        this.doTestValueWriter(PrimitiveType.PrimitiveTypeName.BINARY, ParquetProperties.WriterVersion.PARQUET_2_0, false, DeltaByteArrayWriter.class);
    }

    @Test
    public void testInt32() {
        this.doTestValueWriter(PrimitiveType.PrimitiveTypeName.INT32, ParquetProperties.WriterVersion.PARQUET_1_0, true, DictionaryValuesWriter.PlainIntegerDictionaryValuesWriter.class, PlainValuesWriter.class);
    }

    @Test
    public void testInt32_NoDict() {
        this.doTestValueWriter(PrimitiveType.PrimitiveTypeName.INT32, ParquetProperties.WriterVersion.PARQUET_1_0, false, PlainValuesWriter.class);
    }

    @Test
    public void testInt32_V2() {
        this.doTestValueWriter(PrimitiveType.PrimitiveTypeName.INT32, ParquetProperties.WriterVersion.PARQUET_2_0, true, DictionaryValuesWriter.PlainIntegerDictionaryValuesWriter.class, DeltaBinaryPackingValuesWriter.class);
    }

    @Test
    public void testInt32_V2_NoDict() {
        this.doTestValueWriter(PrimitiveType.PrimitiveTypeName.INT32, ParquetProperties.WriterVersion.PARQUET_2_0, false, DeltaBinaryPackingValuesWriter.class);
    }

    @Test
    public void testInt64() {
        this.doTestValueWriter(PrimitiveType.PrimitiveTypeName.INT64, ParquetProperties.WriterVersion.PARQUET_1_0, true, DictionaryValuesWriter.PlainLongDictionaryValuesWriter.class, PlainValuesWriter.class);
    }

    @Test
    public void testInt64_NoDict() {
        this.doTestValueWriter(PrimitiveType.PrimitiveTypeName.INT64, ParquetProperties.WriterVersion.PARQUET_1_0, false, PlainValuesWriter.class);
    }

    @Test
    public void testInt64_V2() {
        this.doTestValueWriter(PrimitiveType.PrimitiveTypeName.INT64, ParquetProperties.WriterVersion.PARQUET_2_0, true, DictionaryValuesWriter.PlainLongDictionaryValuesWriter.class, DeltaBinaryPackingValuesWriterForLong.class);
    }

    @Test
    public void testInt64_V2_NoDict() {
        this.doTestValueWriter(PrimitiveType.PrimitiveTypeName.INT64, ParquetProperties.WriterVersion.PARQUET_2_0, false, DeltaBinaryPackingValuesWriterForLong.class);
    }

    @Test
    public void testInt96() {
        this.doTestValueWriter(PrimitiveType.PrimitiveTypeName.INT96, ParquetProperties.WriterVersion.PARQUET_1_0, true, DictionaryValuesWriter.PlainFixedLenArrayDictionaryValuesWriter.class, FixedLenByteArrayPlainValuesWriter.class);
    }

    @Test
    public void testInt96_NoDict() {
        this.doTestValueWriter(PrimitiveType.PrimitiveTypeName.INT96, ParquetProperties.WriterVersion.PARQUET_1_0, false, FixedLenByteArrayPlainValuesWriter.class);
    }

    @Test
    public void testInt96_V2() {
        this.doTestValueWriter(PrimitiveType.PrimitiveTypeName.INT96, ParquetProperties.WriterVersion.PARQUET_2_0, true, DictionaryValuesWriter.PlainFixedLenArrayDictionaryValuesWriter.class, FixedLenByteArrayPlainValuesWriter.class);
    }

    @Test
    public void testInt96_V2_NoDict() {
        this.doTestValueWriter(PrimitiveType.PrimitiveTypeName.INT96, ParquetProperties.WriterVersion.PARQUET_2_0, false, FixedLenByteArrayPlainValuesWriter.class);
    }

    @Test
    public void testDouble() {
        this.doTestValueWriter(PrimitiveType.PrimitiveTypeName.DOUBLE, ParquetProperties.WriterVersion.PARQUET_1_0, true, DictionaryValuesWriter.PlainDoubleDictionaryValuesWriter.class, PlainValuesWriter.class);
    }

    @Test
    public void testDouble_NoDict() {
        this.doTestValueWriter(PrimitiveType.PrimitiveTypeName.DOUBLE, ParquetProperties.WriterVersion.PARQUET_1_0, false, PlainValuesWriter.class);
    }

    @Test
    public void testDouble_V2() {
        this.doTestValueWriter(PrimitiveType.PrimitiveTypeName.DOUBLE, ParquetProperties.WriterVersion.PARQUET_2_0, true, DictionaryValuesWriter.PlainDoubleDictionaryValuesWriter.class, PlainValuesWriter.class);
    }

    @Test
    public void testDouble_V2_NoDict() {
        this.doTestValueWriter(PrimitiveType.PrimitiveTypeName.DOUBLE, ParquetProperties.WriterVersion.PARQUET_2_0, false, PlainValuesWriter.class);
    }

    @Test
    public void testFloat() {
        this.doTestValueWriter(PrimitiveType.PrimitiveTypeName.FLOAT, ParquetProperties.WriterVersion.PARQUET_1_0, true, DictionaryValuesWriter.PlainFloatDictionaryValuesWriter.class, PlainValuesWriter.class);
    }

    @Test
    public void testFloat_NoDict() {
        this.doTestValueWriter(PrimitiveType.PrimitiveTypeName.FLOAT, ParquetProperties.WriterVersion.PARQUET_1_0, false, PlainValuesWriter.class);
    }

    @Test
    public void testFloat_V2() {
        this.doTestValueWriter(PrimitiveType.PrimitiveTypeName.FLOAT, ParquetProperties.WriterVersion.PARQUET_2_0, true, DictionaryValuesWriter.PlainFloatDictionaryValuesWriter.class, PlainValuesWriter.class);
    }

    @Test
    public void testFloat_V2_NoDict() {
        this.doTestValueWriter(PrimitiveType.PrimitiveTypeName.FLOAT, ParquetProperties.WriterVersion.PARQUET_2_0, false, PlainValuesWriter.class);
    }

    private void doTestValueWriter(PrimitiveType.PrimitiveTypeName typeName, ParquetProperties.WriterVersion version, boolean enableDictionary, Class<? extends ValuesWriter> expectedValueWriterClass) {
        ColumnDescriptor mockPath = this.getMockColumn(typeName);
        ValuesWriterFactory factory = this.getDefaultFactory(version, enableDictionary);
        ValuesWriter writer = factory.newValuesWriter(mockPath);
        this.validateWriterType(writer, expectedValueWriterClass);
    }

    private void doTestValueWriter(PrimitiveType.PrimitiveTypeName typeName, ParquetProperties.WriterVersion version, boolean enableDictionary, Class<? extends ValuesWriter> initialValueWriterClass, Class<? extends ValuesWriter> fallbackValueWriterClass) {
        ColumnDescriptor mockPath = this.getMockColumn(typeName);
        ValuesWriterFactory factory = this.getDefaultFactory(version, enableDictionary);
        ValuesWriter writer = factory.newValuesWriter(mockPath);
        this.validateFallbackWriter(writer, initialValueWriterClass, fallbackValueWriterClass);
    }

    private ColumnDescriptor getMockColumn(PrimitiveType.PrimitiveTypeName typeName) {
        ColumnDescriptor mockPath = (ColumnDescriptor)Mockito.mock(ColumnDescriptor.class);
        Mockito.when((Object)mockPath.getType()).thenReturn((Object)typeName);
        return mockPath;
    }

    private ValuesWriterFactory getDefaultFactory(ParquetProperties.WriterVersion writerVersion, boolean enableDictionary) {
        DefaultValuesWriterFactory factory = new DefaultValuesWriterFactory();
        ParquetProperties.builder().withDictionaryEncoding(enableDictionary).withWriterVersion(writerVersion).withValuesWriterFactory((ValuesWriterFactory)factory).build();
        return factory;
    }

    private void validateWriterType(ValuesWriter writer, Class<? extends ValuesWriter> valuesWriterClass) {
        Assert.assertTrue((String)("Not instance of: " + valuesWriterClass.getName()), (boolean)valuesWriterClass.isInstance(writer));
    }

    private void validateFallbackWriter(ValuesWriter writer, Class<? extends ValuesWriter> initialWriterClass, Class<? extends ValuesWriter> fallbackWriterClass) {
        this.validateWriterType(writer, FallbackValuesWriter.class);
        FallbackValuesWriter wr = (FallbackValuesWriter)writer;
        this.validateWriterType(wr.initialWriter, initialWriterClass);
        this.validateWriterType(wr.fallBackWriter, fallbackWriterClass);
    }
}

