/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.system;

import java.io.IOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.manifest.PartitionEntry;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.shade.guava30.com.google.common.collect.Iterators;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.ReadonlyTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.source.InnerTableRead;
import org.apache.paimon.table.source.InnerTableScan;
import org.apache.paimon.table.source.ReadOnceTableScan;
import org.apache.paimon.table.source.Split;
import org.apache.paimon.table.source.TableRead;
import org.apache.paimon.table.source.TableScan;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.IteratorRecordReader;
import org.apache.paimon.utils.ProjectedRow;
import org.apache.paimon.utils.RowDataToObjectArrayConverter;
import org.apache.paimon.utils.SerializationUtils;

public class PartitionsTable
implements ReadonlyTable {
    private static final long serialVersionUID = 1L;
    public static final String PARTITIONS = "partitions";
    public static final RowType TABLE_TYPE = new RowType(Arrays.asList(new DataField(0, "partition", SerializationUtils.newStringType(true)), new DataField(1, "record_count", new BigIntType(false)), new DataField(2, "file_size_in_bytes", new BigIntType(false)), new DataField(3, "file_count", new BigIntType(false)), new DataField(4, "last_update_time", DataTypes.TIMESTAMP_MILLIS())));
    private final FileStoreTable storeTable;

    public PartitionsTable(FileStoreTable storeTable) {
        this.storeTable = storeTable;
    }

    @Override
    public String name() {
        return this.storeTable.name() + "$" + PARTITIONS;
    }

    @Override
    public RowType rowType() {
        return TABLE_TYPE;
    }

    @Override
    public List<String> primaryKeys() {
        return Collections.singletonList("partition");
    }

    @Override
    public InnerTableScan newScan() {
        return new PartitionsScan();
    }

    @Override
    public InnerTableRead newRead() {
        return new PartitionsRead(this.storeTable);
    }

    @Override
    public Table copy(Map<String, String> dynamicOptions) {
        return new PartitionsTable((FileStoreTable)this.storeTable.copy((Map)dynamicOptions));
    }

    private static class PartitionsRead
    implements InnerTableRead {
        private final FileStoreTable fileStoreTable;
        private int[][] projection;

        public PartitionsRead(FileStoreTable table) {
            this.fileStoreTable = table;
        }

        @Override
        public InnerTableRead withFilter(Predicate predicate) {
            return this;
        }

        @Override
        public InnerTableRead withProjection(int[][] projection) {
            this.projection = projection;
            return this;
        }

        @Override
        public TableRead withIOManager(IOManager ioManager) {
            return this;
        }

        @Override
        public RecordReader<InternalRow> createReader(Split split) throws IOException {
            if (!(split instanceof PartitionsSplit)) {
                throw new IllegalArgumentException("Unsupported split: " + split.getClass());
            }
            List<PartitionEntry> partitions = this.fileStoreTable.newSnapshotReader().partitionEntries();
            RowDataToObjectArrayConverter converter = new RowDataToObjectArrayConverter(this.fileStoreTable.schema().logicalPartitionType());
            ArrayList<GenericRow> results = new ArrayList<GenericRow>(partitions.size());
            for (PartitionEntry entry : partitions) {
                results.add(this.toRow(entry, converter));
            }
            Iterator<Object> iterator = results.iterator();
            if (this.projection != null) {
                iterator = Iterators.transform(iterator, row -> ProjectedRow.from(this.projection).replaceRow((InternalRow)row));
            }
            return new IteratorRecordReader<InternalRow>(iterator);
        }

        private GenericRow toRow(PartitionEntry entry, RowDataToObjectArrayConverter partitionConverter) {
            BinaryString partitionId = BinaryString.fromString(Arrays.toString(partitionConverter.convert(entry.partition())));
            return GenericRow.of(partitionId, entry.recordCount(), entry.fileSizeInBytes(), entry.fileCount(), Timestamp.fromLocalDateTime(LocalDateTime.ofInstant(Instant.ofEpochMilli(entry.lastFileCreationTime()), ZoneId.systemDefault())));
        }
    }

    private static class PartitionsSplit
    implements Split {
        private static final long serialVersionUID = 1L;

        private PartitionsSplit() {
        }

        @Override
        public long rowCount() {
            return 1L;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        public int hashCode() {
            return 1;
        }
    }

    private static class PartitionsScan
    extends ReadOnceTableScan {
        private PartitionsScan() {
        }

        @Override
        public InnerTableScan withFilter(Predicate predicate) {
            return this;
        }

        @Override
        public TableScan.Plan innerPlan() {
            return () -> Collections.singletonList(new PartitionsSplit());
        }
    }
}

