/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.sort;

import java.util.List;
import org.apache.paimon.spark.sort.SparkZOrderUDF;
import org.apache.paimon.spark.sort.TableSorter;
import org.apache.paimon.table.FileStoreTable;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.functions;
import org.apache.spark.sql.types.StructType;

public class ZorderSorter
extends TableSorter {
    private static final String Z_COLUMN = "ZVALUE";

    public ZorderSorter(FileStoreTable table, List<String> zOrderColNames) {
        super(table, zOrderColNames);
        this.checkNotEmpty();
    }

    @Override
    public Dataset<Row> sort(Dataset<Row> df) {
        Column zColumn = this.zValue(df);
        Dataset zValueDF = df.withColumn(Z_COLUMN, zColumn);
        Dataset sortedDF = zValueDF.repartitionByRange(new Column[]{zValueDF.col(Z_COLUMN)}).sortWithinPartitions(new Column[]{zValueDF.col(Z_COLUMN)});
        return sortedDF.drop(Z_COLUMN);
    }

    private Column zValue(Dataset<Row> df) {
        SparkZOrderUDF zOrderUDF = new SparkZOrderUDF(this.orderColNames.size(), this.table.store().options().varTypeSize(), Integer.MAX_VALUE);
        Column[] zOrderCols = (Column[])this.orderColNames.stream().map(arg_0 -> ((StructType)df.schema()).apply(arg_0)).map(col -> zOrderUDF.sortedLexicographically(df.col(col.name()), col.dataType())).toArray(Column[]::new);
        return zOrderUDF.interleaveBytes(functions.array((Column[])zOrderCols));
    }
}

