/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.fileindex.bloomfilter;

import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.shade.net.openhft.hashing.LongHashFunction;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.BinaryType;
import org.apache.paimon.types.BooleanType;
import org.apache.paimon.types.CharType;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeVisitor;
import org.apache.paimon.types.DateType;
import org.apache.paimon.types.DecimalType;
import org.apache.paimon.types.DoubleType;
import org.apache.paimon.types.FloatType;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.LocalZonedTimestampType;
import org.apache.paimon.types.MapType;
import org.apache.paimon.types.MultisetType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.SmallIntType;
import org.apache.paimon.types.TimeType;
import org.apache.paimon.types.TimestampType;
import org.apache.paimon.types.TinyIntType;
import org.apache.paimon.types.VarBinaryType;
import org.apache.paimon.types.VarCharType;

public interface FastHash {
    public long hash(Object var1);

    public static FastHash getHashFunction(DataType type) {
        return type.accept(FastHashVisitor.INSTANCE);
    }

    public static class FastHashVisitor
    implements DataTypeVisitor<FastHash> {
        private static final FastHashVisitor INSTANCE = new FastHashVisitor();

        @Override
        public FastHash visit(CharType charType) {
            return o -> FastHashVisitor.hash64(((BinaryString)o).toBytes());
        }

        @Override
        public FastHash visit(VarCharType varCharType) {
            return o -> FastHashVisitor.hash64(((BinaryString)o).toBytes());
        }

        @Override
        public FastHash visit(BooleanType booleanType) {
            throw new UnsupportedOperationException("Does not support type boolean");
        }

        @Override
        public FastHash visit(BinaryType binaryType) {
            return o -> FastHashVisitor.hash64((byte[])o);
        }

        @Override
        public FastHash visit(VarBinaryType varBinaryType) {
            return o -> FastHashVisitor.hash64((byte[])o);
        }

        @Override
        public FastHash visit(DecimalType decimalType) {
            throw new UnsupportedOperationException("Does not support decimal");
        }

        @Override
        public FastHash visit(TinyIntType tinyIntType) {
            return o -> FastHashVisitor.getLongHash(((Byte)o).byteValue());
        }

        @Override
        public FastHash visit(SmallIntType smallIntType) {
            return o -> FastHashVisitor.getLongHash(((Short)o).shortValue());
        }

        @Override
        public FastHash visit(IntType intType) {
            return o -> FastHashVisitor.getLongHash(((Integer)o).intValue());
        }

        @Override
        public FastHash visit(BigIntType bigIntType) {
            return o -> FastHashVisitor.getLongHash((Long)o);
        }

        @Override
        public FastHash visit(FloatType floatType) {
            return o -> FastHashVisitor.getLongHash(Float.floatToIntBits(((Float)o).floatValue()));
        }

        @Override
        public FastHash visit(DoubleType doubleType) {
            return o -> FastHashVisitor.getLongHash(Double.doubleToLongBits((Double)o));
        }

        @Override
        public FastHash visit(DateType dateType) {
            return o -> FastHashVisitor.getLongHash(((Integer)o).intValue());
        }

        @Override
        public FastHash visit(TimeType timeType) {
            return o -> FastHashVisitor.getLongHash(((Integer)o).intValue());
        }

        @Override
        public FastHash visit(TimestampType timestampType) {
            int precision = timestampType.getPrecision();
            return o -> {
                if (o == null) {
                    return 0L;
                }
                if (precision <= 3) {
                    return FastHashVisitor.getLongHash(((Timestamp)o).getMillisecond());
                }
                return FastHashVisitor.getLongHash(((Timestamp)o).toMicros());
            };
        }

        @Override
        public FastHash visit(LocalZonedTimestampType localZonedTimestampType) {
            int precision = localZonedTimestampType.getPrecision();
            return o -> {
                if (o == null) {
                    return 0L;
                }
                if (precision <= 3) {
                    return FastHashVisitor.getLongHash(((Timestamp)o).getMillisecond());
                }
                return FastHashVisitor.getLongHash(((Timestamp)o).toMicros());
            };
        }

        @Override
        public FastHash visit(ArrayType arrayType) {
            throw new UnsupportedOperationException("Does not support type array");
        }

        @Override
        public FastHash visit(MultisetType multisetType) {
            throw new UnsupportedOperationException("Does not support type mutiset");
        }

        @Override
        public FastHash visit(MapType mapType) {
            throw new UnsupportedOperationException("Does not support type map");
        }

        @Override
        public FastHash visit(RowType rowType) {
            throw new UnsupportedOperationException("Does not support type row");
        }

        static long getLongHash(long key) {
            key = (key ^ 0xFFFFFFFFFFFFFFFFL) + (key << 21);
            key ^= key >> 24;
            key = key + (key << 3) + (key << 8);
            key ^= key >> 14;
            key = key + (key << 2) + (key << 4);
            key ^= key >> 28;
            key += key << 31;
            return key;
        }

        static long hash64(byte[] data) {
            return LongHashFunction.xx().hashBytes(data);
        }
    }
}

