/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.sql;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.paimon.fs.Path;
import org.apache.paimon.spark.PaimonSparkTestBase;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.source.DataSplit;
import org.apache.paimon.table.source.Split;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.junit.jupiter.api.Assertions;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t3Aa\u0001\u0003\u0001\u001f!)A\u0003\u0001C\u0001+!)\u0001\u0004\u0001C\u00053\ty\u0001+Y5n_:\fV/\u001a:z)\u0016\u001cHO\u0003\u0002\u0006\r\u0005\u00191/\u001d7\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\u0001\u0018-[7p]*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\t\u0011\u0005E\u0011R\"\u0001\u0004\n\u0005M1!a\u0005)bS6|gn\u00159be.$Vm\u001d;CCN,\u0017A\u0002\u001fj]&$h\bF\u0001\u0017!\t9\u0002!D\u0001\u0005\u0003-9W\r^!mY\u001aKG.Z:\u0015\tiYS\u0006\u000f\t\u00047y\u0001S\"\u0001\u000f\u000b\u0003u\tQa]2bY\u0006L!a\b\u000f\u0003\u000b\u0005\u0013(/Y=\u0011\u0005\u0005BcB\u0001\u0012'!\t\u0019C$D\u0001%\u0015\t)c\"\u0001\u0004=e>|GOP\u0005\u0003Oq\ta\u0001\u0015:fI\u00164\u0017BA\u0015+\u0005\u0019\u0019FO]5oO*\u0011q\u0005\b\u0005\u0006Y\t\u0001\r\u0001I\u0001\ni\u0006\u0014G.\u001a(b[\u0016DQA\f\u0002A\u0002=\n!\u0002]1si&$\u0018n\u001c8t!\r\u0001T\u0007\t\b\u0003cMr!a\t\u001a\n\u0003uI!\u0001\u000e\u000f\u0002\u000fA\f7m[1hK&\u0011ag\u000e\u0002\u0004'\u0016\f(B\u0001\u001b\u001d\u0011\u0015I$\u00011\u0001;\u0003=\u0001\u0018M\u001d;ji&|gNR5mi\u0016\u0014\b\u0003B\u001eAA\u0001j\u0011\u0001\u0010\u0006\u0003{y\nA!\u001e;jY*\tq(\u0001\u0003kCZ\f\u0017BA!=\u0005\ri\u0015\r\u001d")
public class PaimonQueryTest
extends PaimonSparkTestBase {
    private String[] getAllFiles(String tableName, Seq<String> partitions, Map<String, String> partitionFilter) {
        FileStoreTable paimonTable = this.loadTable(tableName);
        Path location = paimonTable.location();
        Buffer files = (Buffer)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(paimonTable.newSnapshotReader().withPartitionFilter(partitionFilter).read().splits()).asScala()).collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Split, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                DataSplit dataSplit;
                A1 A1 = x1;
                Object object = A1 instanceof DataSplit ? (dataSplit = (DataSplit)A1) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Split x1) {
                Split split = x1;
                boolean bl = split instanceof DataSplit;
                return bl;
            }
        }, Buffer$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)ds -> {
            String string;
            if (partitions.isEmpty()) {
                string = new StringBuilder(8).append(location).append("/bucket-").append(ds.bucket()).toString();
            } else {
                String partitionPath = ((TraversableOnce)((TraversableLike)partitions.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    String pt = (String)tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    String string = new StringBuilder(1).append(pt).append("=").append(ds.partition().getString(index)).toString();
                    return string;
                }, Seq$.MODULE$.canBuildFrom())).mkString("/");
                string = new StringBuilder(9).append(location).append("/").append(partitionPath).append("/bucket-").append(ds.bucket()).toString();
            }
            String prefix = string;
            return (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(ds.dataFiles()).asScala()).map((Function1 & Serializable & scala.Serializable)f -> new StringBuilder(1).append(prefix).append("/").append(f.fileName()).toString(), Buffer$.MODULE$.canBuildFrom());
        }, Buffer$.MODULE$.canBuildFrom());
        return (String[])((TraversableOnce)files.sorted((Ordering)Ordering.String$.MODULE$)).toArray(ClassTag$.MODULE$.apply(String.class));
    }

    public static final /* synthetic */ void $anonfun$new$1(PaimonQueryTest $this, String fileFormat) {
        $this.bucketModes().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)bucketMode -> $this.test(new StringBuilder(46).append("Query input_file_name(): file.format=").append(fileFormat).append(", bucket=").append(bucketMode).toString(), (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkSession _spark = $this.spark();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"T"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(168).append("\n                           |CREATE TABLE T (id INT, name STRING)\n                           |TBLPROPERTIES ('file.format'='").append(fileFormat).append("', 'bucket'='").append(bucketMode).append("')\n                           |").toString())).stripMargin());
                String location = $this.loadTable("T").location().toUri().toString();
                $this.spark().sql("INSERT INTO T VALUES (1, 'x1'), (3, 'x3')");
                Dataset res1 = $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(348).append("\n                                      |SELECT *,\n                                      |startswith(input_file_name(), '").append(location).append("') AS start,\n                                      |endswith(input_file_name(), '.").append(fileFormat).append("') AS end\n                                      |FROM T\n                                      |ORdER BY id\n                                      |").toString())).stripMargin());
                Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "x1", BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)true)}));
                Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "x3", BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)true)}));
                $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> res1, (Seq)Nil$.MODULE$.$colon$colon((Object)row2).$colon$colon((Object)row));
                $this.spark().sql("INSERT INTO T VALUES (2, 'x2'), (4, 'x4'), (6, 'x6')");
                String[] res2 = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.spark().sql("SELECT input_file_name() FROM T").distinct().as(_spark.implicits().newStringEncoder()).collect())).sorted((Ordering)Ordering.String$.MODULE$);
                String[] allDataFiles = $this.getAllFiles("T", (Seq<String>)((Seq)Nil$.MODULE$), null);
                Assertions.assertTrue((boolean)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])res2)).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])allDataFiles)));
            });
        }, new Position("PaimonQueryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37)));
    }

    public static final /* synthetic */ void $anonfun$new$6(PaimonQueryTest $this, String fileFormat) {
        $this.bucketModes().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)bucketMode -> $this.test(new StringBuilder(68).append("Query input_file_name() for partitioned table: file.format=").append(fileFormat).append(", bucket=").append(bucketMode).toString(), (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkSession _spark = $this.spark();
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"T"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(227).append("\n                           |CREATE TABLE T (id INT, name STRING, pt STRING)\n                           |PARTITIONED BY (pt)\n                           |TBLPROPERTIES ('file.format'='").append(fileFormat).append("', 'bucket'='").append(bucketMode).append("')\n                           |").toString())).stripMargin());
                String location = $this.loadTable("T").location().toUri().toString();
                $this.spark().sql("INSERT INTO T VALUES (1, 'x1', '2024'), (3, 'x3', '2024')");
                Dataset res1 = $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(359).append("\n                                      |SELECT id, name, pt,\n                                      |startswith(input_file_name(), '").append(location).append("') AS start,\n                                      |endswith(input_file_name(), '.").append(fileFormat).append("') AS end\n                                      |FROM T\n                                      |ORdER BY id\n                                      |").toString())).stripMargin());
                Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "x1", "2024", BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)true)}));
                Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "x3", "2024", BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)true)}));
                $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> res1, (Seq)Nil$.MODULE$.$colon$colon((Object)row2).$colon$colon((Object)row));
                $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                          |INSERT INTO T\n                          |VALUES (2, 'x2', '2025'), (4, 'x4', '2025'), (6, 'x6', '2026')\n                          |")).stripMargin());
                String[] res2 = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.spark().sql("SELECT input_file_name() FROM T WHERE pt='2026'").distinct().as(_spark.implicits().newStringEncoder()).collect())).sorted((Ordering)Ordering.String$.MODULE$);
                HashMap<String, String> partitionFilter = new HashMap<String, String>();
                partitionFilter.put("pt", "2026");
                String[] partialDataFiles = $this.getAllFiles("T", (Seq<String>)((Seq)new .colon.colon((Object)"pt", (List)Nil$.MODULE$)), partitionFilter);
                Assertions.assertTrue((boolean)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])res2)).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])partialDataFiles)));
                String[] res3 = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.spark().sql("SELECT input_file_name() FROM T").distinct().as(_spark.implicits().newStringEncoder()).collect())).sorted((Ordering)Ordering.String$.MODULE$);
                String[] allDataFiles = $this.getAllFiles("T", (Seq<String>)((Seq)new .colon.colon((Object)"pt", (List)Nil$.MODULE$)), null);
                Assertions.assertTrue((boolean)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])res3)).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])allDataFiles)));
            });
        }, new Position("PaimonQueryTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77)));
    }

    public PaimonQueryTest() {
        this.fileFormats().foreach((Function1 & Serializable & scala.Serializable)fileFormat -> {
            PaimonQueryTest.$anonfun$new$1(this, fileFormat);
            return BoxedUnit.UNIT;
        });
        this.fileFormats().foreach((Function1 & Serializable & scala.Serializable)fileFormat -> {
            PaimonQueryTest.$anonfun$new$6(this, fileFormat);
            return BoxedUnit.UNIT;
        });
    }
}

