/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.sql;

import java.io.Serializable;
import org.apache.paimon.spark.PaimonSparkTestBase;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001]1AAA\u0002\u0001\u001d!)1\u0003\u0001C\u0001)\t1B)\u001f8b[&\u001c')^2lKR$\u0016M\u00197f)\u0016\u001cHO\u0003\u0002\u0005\u000b\u0005\u00191/\u001d7\u000b\u0005\u00199\u0011!B:qCJ\\'B\u0001\u0005\n\u0003\u0019\u0001\u0018-[7p]*\u0011!bC\u0001\u0007CB\f7\r[3\u000b\u00031\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\b\u0011\u0005A\tR\"A\u0003\n\u0005I)!a\u0005)bS6|gn\u00159be.$Vm\u001d;CCN,\u0017A\u0002\u001fj]&$h\bF\u0001\u0016!\t1\u0002!D\u0001\u0004\u0001")
public class DynamicBucketTableTest
extends PaimonSparkTestBase {
    public DynamicBucketTableTest() {
        this.test("Paimon dynamic bucket table: write with assign parallelism", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                 |CREATE TABLE T (\n                 |  pk STRING,\n                 |  v STRING,\n                 |  pt STRING)\n                 |TBLPROPERTIES (\n                 |  'primary-key' = 'pk, pt',\n                 |  'bucket' = '-1',\n                 |  'dynamic-bucket.target-row-num'='3',\n                 |  'dynamic-bucket.assigner-parallelism'='3'\n                 |)\n                 |PARTITIONED BY (pt)\n                 |")).stripMargin());
            this.spark().sql("INSERT INTO T VALUES ('1', 'a', 'p'), ('2', 'b', 'p'), ('3', 'c', 'p'), ('4', 'd', 'p'), ('5', 'e', 'p')");
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1", "a", "p"}));
            Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2", "b", "p"}));
            Row row3 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"3", "c", "p"}));
            Row row4 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"4", "d", "p"}));
            Row row5 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"5", "e", "p"}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql("SELECT * FROM T ORDER BY pk"), (Seq)Nil$.MODULE$.$colon$colon((Object)row5).$colon$colon((Object)row4).$colon$colon((Object)row3).$colon$colon((Object)row2).$colon$colon((Object)row));
            Row row6 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0)}));
            Row row7 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)}));
            Row row8 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2)}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql("SELECT DISTINCT bucket FROM `T$FILES`"), (Seq)Nil$.MODULE$.$colon$colon((Object)row8).$colon$colon((Object)row7).$colon$colon((Object)row6));
        }, new Position("DynamicBucketTableTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 27));
        this.test("Paimon dynamic bucket table: write with dynamic-bucket.initial-buckets", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                 |CREATE TABLE T (\n                 |  pk STRING,\n                 |  v STRING,\n                 |  pt STRING)\n                 |TBLPROPERTIES (\n                 |  'primary-key' = 'pk, pt',\n                 |  'bucket' = '-1',\n                 |  'dynamic-bucket.target-row-num'='3',\n                 |  'dynamic-bucket.initial-buckets'='3',\n                 |  'dynamic-bucket.assigner-parallelism'='10'\n                 |)\n                 |PARTITIONED BY (pt)\n                 |")).stripMargin());
            this.spark().sql("INSERT INTO T VALUES ('1', 'a', 'p'), ('2', 'b', 'p'), ('3', 'c', 'p'), ('4', 'd', 'p'), ('5', 'e', 'p')");
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1", "a", "p"}));
            Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2", "b", "p"}));
            Row row3 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"3", "c", "p"}));
            Row row4 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"4", "d", "p"}));
            Row row5 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"5", "e", "p"}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql("SELECT * FROM T ORDER BY pk"), (Seq)Nil$.MODULE$.$colon$colon((Object)row5).$colon$colon((Object)row4).$colon$colon((Object)row3).$colon$colon((Object)row2).$colon$colon((Object)row));
            Row row6 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0)}));
            Row row7 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)}));
            Row row8 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2)}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql("SELECT DISTINCT bucket FROM `T$FILES`"), (Seq)Nil$.MODULE$.$colon$colon((Object)row8).$colon$colon((Object)row7).$colon$colon((Object)row6));
        }, new Position("DynamicBucketTableTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
        this.test("Paimon dynamic bucket table: write with global dynamic bucket", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            String error;
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                 |CREATE TABLE T (\n                 |  pk STRING,\n                 |  v STRING,\n                 |  pt STRING)\n                 |TBLPROPERTIES (\n                 |  'primary-key' = 'pk',\n                 |  'bucket' = '-1'\n                 |)\n                 |PARTITIONED BY (pt)\n                 |")).stripMargin());
            String $org_scalatest_assert_macro_left = error = ((Throwable)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.spark().sql("INSERT INTO T VALUES ('1', 'a', 'p')"), ClassTag$.MODULE$.apply(UnsupportedOperationException.class), new Position("DynamicBucketTableTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102))).getMessage();
            String $org_scalatest_assert_macro_right = "Spark doesn't support GLOBAL_DYNAMIC mode";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DynamicBucketTableTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
        }, new Position("DynamicBucketTableTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
    }
}

