/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.sql;

import java.util.Objects;
import org.apache.paimon.spark.PaimonSparkTestBase;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.junit.jupiter.api.Assertions;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001=2Aa\u0001\u0003\u0001\u001f!)A\u0003\u0001C\u0001+!)\u0001\u0004\u0001C\u00013\t\tB)Z:de&\u0014W\rV1cY\u0016$Vm\u001d;\u000b\u0005\u00151\u0011aA:rY*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta\u0001]1j[>t'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001!A\u0011\u0011CE\u0007\u0002\r%\u00111C\u0002\u0002\u0014!\u0006LWn\u001c8Ta\u0006\u00148\u000eV3ti\n\u000b7/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003Y\u0001\"a\u0006\u0001\u000e\u0003\u0011\tac\u00195fG.$\u0016M\u00197f\u0007>lW.\u001a8u\u000bF,\u0018\r\u001c\u000b\u00045\u0001j\u0003CA\u000e\u001f\u001b\u0005a\"\"A\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}a\"\u0001B+oSRDQ!\t\u0002A\u0002\t\n\u0011\u0002^1cY\u0016t\u0015-\\3\u0011\u0005\rRcB\u0001\u0013)!\t)C$D\u0001'\u0015\t9c\"\u0001\u0004=e>|GOP\u0005\u0003Sq\ta\u0001\u0015:fI\u00164\u0017BA\u0016-\u0005\u0019\u0019FO]5oO*\u0011\u0011\u0006\b\u0005\u0006]\t\u0001\rAI\u0001\bG>lW.\u001a8u\u0001")
public class DescribeTableTest
extends PaimonSparkTestBase {
    public void checkTableCommentEqual(String tableName, String comment) {
        Nil$ nil$;
        Function0 & java.io.Serializable & Serializable intersect = (Function0 & java.io.Serializable & Serializable)() -> this.spark().sql(new StringBuilder(24).append("DESCRIBE TABLE EXTENDED ").append(tableName).toString()).filter("col_name = 'Comment'").select("col_name", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"data_type"}));
        if (comment == null) {
            nil$ = Nil$.MODULE$;
        } else {
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Comment", comment}));
            nil$ = Nil$.MODULE$.$colon$colon((Object)row);
        }
        this.checkAnswer(intersect, (Seq)nil$);
        Assertions.assertTrue((boolean)Objects.equals(comment, this.loadTable(tableName).schema().comment()));
    }

    public DescribeTableTest() {
        this.test("Paimon describe: describe table comment", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> {
            String comment = "test comment";
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(196).append("\n                 |CREATE TABLE T (\n                 |  id INT COMMENT 'id comment',\n                 |  name STRING,\n                 |  dt STRING)\n                 |COMMENT '").append(comment).append("'\n                 |").toString())).stripMargin());
            this.checkTableCommentEqual("T", comment);
            comment = "new comment";
            this.spark().sql(new StringBuilder(48).append("ALTER TABLE T SET TBLPROPERTIES ('comment' = '").append(comment).append("')").toString());
            this.checkTableCommentEqual("T", comment);
            comment = "  ";
            this.spark().sql(new StringBuilder(48).append("ALTER TABLE T SET TBLPROPERTIES ('comment' = '").append(comment).append("')").toString());
            this.checkTableCommentEqual("T", comment);
            comment = "";
            this.spark().sql(new StringBuilder(48).append("ALTER TABLE T SET TBLPROPERTIES ('comment' = '").append(comment).append("')").toString());
            this.checkTableCommentEqual("T", comment);
            this.spark().sql("ALTER TABLE T UNSET TBLPROPERTIES ('comment')");
            this.checkTableCommentEqual("T", null);
            comment = "new comment";
            this.spark().sql(new StringBuilder(48).append("ALTER TABLE T SET TBLPROPERTIES ('comment' = '").append(comment).append("')").toString());
            this.checkTableCommentEqual("T", comment);
        }, new Position("DescribeTableTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 30));
        this.test("Paimon describe: describe table with no comment", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                 |CREATE TABLE T (\n                 |  id INT COMMENT 'id comment',\n                 |  name STRING,\n                 |  dt STRING)\n                 |")).stripMargin());
            this.checkTableCommentEqual("T", null);
        }, new Position("DescribeTableTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
    }
}

