/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.sql;

import java.io.File;
import java.io.Serializable;
import org.apache.paimon.spark.PaimonHiveTestBase;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.junit.jupiter.api.Assertions;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u00013Qa\u0002\u0005\u0002\u0002MAQ\u0001\u0007\u0001\u0005\u0002eAQ\u0001\b\u0001\u0005\u0002uAQ\u0001\n\u0001\u0005\u0002\u0015BQa\r\u0001\u0005\u0002QBQA\u000e\u0001\u0005\u0002]BQ\u0001\u0010\u0001\u0005\u0002u\u0012!\u0004\u0012#M/&$\b\u000eS5wK\u000e\u000bG/\u00197pOR+7\u000f\u001e\"bg\u0016T!!\u0003\u0006\u0002\u0007M\fHN\u0003\u0002\f\u0019\u0005)1\u000f]1sW*\u0011QBD\u0001\u0007a\u0006LWn\u001c8\u000b\u0005=\u0001\u0012AB1qC\u000eDWMC\u0001\u0012\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0003\u0005\u0002\u0016-5\t!\"\u0003\u0002\u0018\u0015\t\u0011\u0002+Y5n_:D\u0015N^3UKN$()Y:f\u0003\u0019a\u0014N\\5u}Q\t!\u0004\u0005\u0002\u001c\u00015\t\u0001\"\u0001\u0015tkB\u0004xN\u001d;EK\u001a\fW\u000f\u001c;ECR\f'-Y:f/&$\bnU3tg&|gnQ1uC2|w-F\u0001\u001f!\ty\"%D\u0001!\u0015\u0005\t\u0013!B:dC2\f\u0017BA\u0012!\u0005\u001d\u0011un\u001c7fC:\f1cZ3u\t\u0006$\u0018MY1tK2{7-\u0019;j_:$\"AJ\u0019\u0011\u0005\u001drcB\u0001\u0015-!\tI\u0003%D\u0001+\u0015\tY##\u0001\u0004=e>|GOP\u0005\u0003[\u0001\na\u0001\u0015:fI\u00164\u0017BA\u00181\u0005\u0019\u0019FO]5oO*\u0011Q\u0006\t\u0005\u0006e\r\u0001\rAJ\u0001\u0007I\nt\u0015-\\3\u0002%\u001d,G\u000fR1uC\n\f7/Z\"p[6,g\u000e\u001e\u000b\u0003MUBQA\r\u0003A\u0002\u0019\n\u0001cZ3u\t\u0006$\u0018MY1tKB\u0013x\u000e]:\u0015\u0005aZ\u0004\u0003B\u0014:M\u0019J!A\u000f\u0019\u0003\u00075\u000b\u0007\u000fC\u00033\u000b\u0001\u0007a%\u0001\thKR$\u0016M\u00197f\u0019>\u001c\u0017\r^5p]R\u0011aE\u0010\u0005\u0006\u007f\u0019\u0001\rAJ\u0001\bi\ndg*Y7f\u0001")
public abstract class DDLWithHiveCatalogTestBase
extends PaimonHiveTestBase {
    public boolean supportDefaultDatabaseWithSessionCatalog() {
        return true;
    }

    public String getDatabaseLocation(String dbName) {
        return ((String)((Row)this.spark().sql(new StringBuilder(14).append("DESC DATABASE ").append(dbName).toString()).filter("info_name == 'Location'").head()).getAs("info_value")).split(":")[1];
    }

    public String getDatabaseComment(String dbName) {
        return (String)((Row)this.spark().sql(new StringBuilder(14).append("DESC DATABASE ").append(dbName).toString()).filter("info_name == 'Comment'").head()).getAs("info_value");
    }

    public Map<String, String> getDatabaseProps(String dbName) {
        String dbPropsStr = (String)((Row)this.spark().sql(new StringBuilder(23).append("DESC DATABASE EXTENDED ").append(dbName).toString()).filter("info_name == 'Properties'").head()).getAs("info_value");
        Regex pattern = new StringOps(Predef$.MODULE$.augmentString("\\(([^,]+),([^)]+)\\)")).r();
        return pattern.findAllIn((CharSequence)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(dbPropsStr)).drop(1))).dropRight(1)).matchData().map((Function1 & Serializable & scala.Serializable)m -> {
            String key = m.group(1).trim();
            String value = m.group(2).trim();
            return new Tuple2((Object)key, (Object)value);
        }).toMap(Predef$.MODULE$.$conforms());
    }

    public String getTableLocation(String tblName) {
        String tablePropsStr = (String)((Row)this.spark().sql(new StringBuilder(20).append("DESC TABLE EXTENDED ").append(tblName).toString()).filter("col_name == 'Table Properties'").head()).getAs("data_type");
        Map tableProps = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tablePropsStr.substring(1, tablePropsStr.length() - 1).split(","))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.split("="), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            String[] stringArray = x0$1;
            Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
            if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(2) != 0) {
                throw new MatchError((Object)stringArray);
            }
            String key = (String)((SeqLike)option.get()).apply(0);
            String value = (String)((SeqLike)option.get()).apply(1);
            Tuple2 tuple2 = new Tuple2((Object)key, (Object)value);
            return tuple2;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        return ((String)tableProps.apply((Object)"path")).split(":")[1];
    }

    public static final /* synthetic */ void $anonfun$new$2(DDLWithHiveCatalogTestBase $this, String catalogName) {
        $this.spark().sql(new StringBuilder(4).append("USE ").append(catalogName).toString());
        $this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dBLocation -> {
            $this.withDatabase((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"paimon_db"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                String comment = "this is a test comment";
                $this.spark().sql(new StringBuilder(48).append("CREATE DATABASE paimon_db LOCATION '").append(dBLocation.getCanonicalPath()).append("' COMMENT '").append(comment).append("'").toString());
                Assertions.assertEquals((Object)$this.getDatabaseLocation("paimon_db"), (Object)dBLocation.getCanonicalPath());
                Assertions.assertEquals((Object)$this.getDatabaseComment("paimon_db"), (Object)comment);
                $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"paimon_db.paimon_tbl"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                             |CREATE TABLE paimon_db.paimon_tbl (id STRING, name STRING, pt STRING)\n                             |USING PAIMON\n                             |TBLPROPERTIES ('primary-key' = 'id')\n                             |")).stripMargin());
                    Assertions.assertEquals((Object)$this.getTableLocation("paimon_db.paimon_tbl"), (Object)new StringBuilder(11).append(dBLocation.getCanonicalPath()).append("/paimon_tbl").toString());
                });
            });
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$7(DDLWithHiveCatalogTestBase $this, String catalogName) {
        $this.spark().sql(new StringBuilder(4).append("USE ").append(catalogName).toString());
        $this.withDatabase((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"paimon_db"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.spark().sql("CREATE DATABASE paimon_db WITH DBPROPERTIES ('k1' = 'v1', 'k2' = 'v2')");
            Map<String, String> props = $this.getDatabaseProps("paimon_db");
            Assertions.assertEquals((Object)props.apply((Object)"k1"), (Object)"v1");
            Assertions.assertEquals((Object)props.apply((Object)"k2"), (Object)"v2");
        });
    }

    public DDLWithHiveCatalogTestBase() {
        this.test("Paimon DDL with hive catalog: create database with location and comment", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)"spark_catalog", (List)new .colon.colon((Object)this.paimonHiveCatalogName(), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)catalogName -> {
            DDLWithHiveCatalogTestBase.$anonfun$new$2(this, catalogName);
            return BoxedUnit.UNIT;
        }), new Position("DDLWithHiveCatalogTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 28));
        this.test("Paimon DDL with hive catalog: create database with props", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)"spark_catalog", (List)new .colon.colon((Object)this.paimonHiveCatalogName(), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)catalogName -> {
            DDLWithHiveCatalogTestBase.$anonfun$new$7(this, catalogName);
            return BoxedUnit.UNIT;
        }), new Position("DDLWithHiveCatalogTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
        this.test("Paimon DDL with hive catalog: set default database", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ObjectRef reusedSpark = ObjectRef.create((Object)this.spark());
            ((IterableLike)new .colon.colon((Object)"paimon", (List)new .colon.colon((Object)"spark_catalog", (List)new .colon.colon((Object)this.paimonHiveCatalogName(), (List)Nil$.MODULE$)))).foreach((Function1 & Serializable & scala.Serializable)catalogName -> {
                BoxedUnit boxedUnit;
                String dbName = new StringBuilder(11).append((String)catalogName).append("_default_db").toString();
                String tblName = new StringBuilder(4).append(dbName).append("_tbl").toString();
                ((SparkSession)reusedSpark$1.elem).sql(new StringBuilder(4).append("use ").append((String)catalogName).toString());
                ((SparkSession)reusedSpark$1.elem).sql(new StringBuilder(16).append("create database ").append(dbName).toString());
                ((SparkSession)reusedSpark$1.elem).sql(new StringBuilder(4).append("use ").append(dbName).toString());
                ((SparkSession)reusedSpark$1.elem).sql(new StringBuilder(59).append("create table ").append(tblName).append(" (id int, name string, dt string) using paimon").toString());
                ((SparkSession)reusedSpark$1.elem).stop();
                reusedSpark$1.elem = SparkSession$.MODULE$.builder().master("local[2]").config(this.sparkConf()).config("spark.sql.defaultCatalog", catalogName).config(new StringBuilder(34).append("spark.sql.catalog.").append((String)catalogName).append(".defaultDatabase").toString(), dbName).getOrCreate();
                if (catalogName.equals("spark_catalog") && !this.supportDefaultDatabaseWithSessionCatalog()) {
                    this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> ((SparkSession)reusedSpark$1.elem).sql("show tables").select("tableName", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])), (Seq)Nil$.MODULE$);
                    boxedUnit = ((SparkSession)reusedSpark$1.elem).sql(new StringBuilder(4).append("use ").append(dbName).toString());
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tblName}));
                this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> ((SparkSession)reusedSpark$1.elem).sql("show tables").select("tableName", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])), (Seq)Nil$.MODULE$.$colon$colon((Object)row));
                return ((SparkSession)reusedSpark$1.elem).sql(new StringBuilder(11).append("drop table ").append(tblName).toString());
            });
            ((SparkSession)reusedSpark.elem).stop();
        }, new Position("DDLWithHiveCatalogTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
    }
}

