/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.sql;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.spark.PaimonSparkTestBase;
import org.apache.paimon.stats.ColStats;
import org.apache.paimon.stats.Statistics;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.utils.DateTimeUtils;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2ScanRelation;
import org.assertj.core.api.Assertions;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.BigInt;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u000193Q!\u0002\u0004\u0002\u0002EAQA\u0006\u0001\u0005\u0002]AQA\u0007\u0001\u0005\u0012mAQa\f\u0001\u0005\u0012ABQ!\u0013\u0001\u0005\u0012)\u0013A#\u00118bYfTX\rV1cY\u0016$Vm\u001d;CCN,'BA\u0004\t\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\rA\f\u0017.\\8o\u0015\tia\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001f\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0005\t\u0003'Qi\u0011\u0001C\u0005\u0003+!\u00111\u0003U1j[>t7\u000b]1sWR+7\u000f\u001e\"bg\u0016\fa\u0001P5oSRtD#\u0001\r\u0011\u0005e\u0001Q\"\u0001\u0004\u0002\u001dM$\u0018\r^:GS2,7i\\;oiR\u0019AD\t\u0016\u0011\u0005u\u0001S\"\u0001\u0010\u000b\u0003}\tQa]2bY\u0006L!!\t\u0010\u0003\u0007%sG\u000fC\u0003$\u0005\u0001\u0007A%A\u0007uC\ndW\rT8dCRLwN\u001c\t\u0003K!j\u0011A\n\u0006\u0003O)\t!AZ:\n\u0005%2#\u0001\u0002)bi\"DQa\u000b\u0002A\u00021\naAZ5mK&{\u0005CA\u0013.\u0013\tqcE\u0001\u0004GS2,\u0017jT\u0001\u0011O\u0016$8kY1o'R\fG/[:uS\u000e$\"!M\u001f\u0011\u0005IZT\"A\u001a\u000b\u0005Q*\u0014a\u00027pO&\u001c\u0017\r\u001c\u0006\u0003m]\nQ\u0001\u001d7b]NT!\u0001O\u001d\u0002\u0011\r\fG/\u00197zgRT!a\u0002\u001e\u000b\u0005%a\u0011B\u0001\u001f4\u0005)\u0019F/\u0019;jgRL7m\u001d\u0005\u0006\u000f\r\u0001\rA\u0010\t\u0003\u007f\u0019s!\u0001\u0011#\u0011\u0005\u0005sR\"\u0001\"\u000b\u0005\r\u0003\u0012A\u0002\u001fs_>$h(\u0003\u0002F=\u00051\u0001K]3eK\u001aL!a\u0012%\u0003\rM#(/\u001b8h\u0015\t)e$\u0001\ttkB\u0004xN\u001d;t\u0007>d7\u000b^1ugR\t1\n\u0005\u0002\u001e\u0019&\u0011QJ\b\u0002\b\u0005>|G.Z1o\u0001")
public abstract class AnalyzeTableTestBase
extends PaimonSparkTestBase {
    public int statsFileCount(Path tableLocation, FileIO fileIO) {
        return fileIO.listStatus(new Path(tableLocation, "statistics")).length;
    }

    public org.apache.spark.sql.catalyst.plans.logical.Statistics getScanStatistic(String sql) {
        DataSourceV2ScanRelation relation = (DataSourceV2ScanRelation)this.spark().sql(sql).queryExecution().optimizedPlan().collectFirst((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                DataSourceV2ScanRelation dataSourceV2ScanRelation;
                A1 A1 = x1;
                Object object = A1 instanceof DataSourceV2ScanRelation ? (dataSourceV2ScanRelation = (DataSourceV2ScanRelation)A1) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                boolean bl = logicalPlan instanceof DataSourceV2ScanRelation;
                return bl;
            }
        }).get();
        return relation.computeStats();
    }

    public boolean supportsColStats() {
        return true;
    }

    public AnalyzeTableTestBase() {
        this.test("Paimon analyze: analyze table only", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                 |CREATE TABLE T (id STRING, name STRING, i INT, l LONG)\n                 |USING PAIMON\n                 |TBLPROPERTIES ('primary-key'='id')\n                 |")).stripMargin());
            this.spark().sql("INSERT INTO T VALUES ('1', 'a', 1, 1)");
            this.spark().sql("INSERT INTO T VALUES ('2', 'aaa', 1, 2)");
            this.spark().sql("ANALYZE TABLE T COMPUTE STATISTICS");
            Statistics stats = (Statistics)this.loadTable("T").statistics().get();
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)stats.mergedRecordCount().getAsLong());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)stats.mergedRecordSize().isPresent());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)stats.colStats().isEmpty());
        }, new Position("AnalyzeTableTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 35));
        this.test("Paimon analyze: test statistic system table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                 |CREATE TABLE T (id STRING, name STRING, i INT, l LONG)\n                 |USING PAIMON\n                 |TBLPROPERTIES ('primary-key'='id')\n                 |")).stripMargin());
            this.spark().sql("INSERT INTO T VALUES ('1', 'a', 1, 1)");
            this.spark().sql("INSERT INTO T VALUES ('2', 'aaa', 1, 2)");
            this.spark().sql("ANALYZE TABLE T COMPUTE STATISTICS");
            Dataset df = this.spark().sql("select snapshot_id, schema_id, mergedRecordCount, colstat from `T$statistics`");
            org.junit.jupiter.api.Assertions.assertEquals((int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.collect())).size(), (int)1);
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql("SELECT snapshot_id, schema_id, mergedRecordCount, colstat from `T$statistics`"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)2), "{ }"})));
        }, new Position("AnalyzeTableTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
        this.test("Paimon analyze: analyze no scan", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            this.spark().sql("CREATE TABLE T (id STRING, name STRING)");
            return Assertions.assertThatThrownBy(() -> this.spark().sql("ANALYZE TABLE T COMPUTE STATISTICS NOSCAN")).hasMessageContaining("NOSCAN is ineffective with paimon");
        }, new Position("AnalyzeTableTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
        this.test("Paimon analyze: analyze table partition", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            this.spark().sql("CREATE TABLE T (id STRING, name STRING, pt STRING) PARTITIONED BY (id, pt) ");
            return Assertions.assertThatThrownBy(() -> this.spark().sql("ANALYZE TABLE T PARTITION (pt = '1') COMPUTE STATISTICS")).hasMessageContaining("Analyze table partition is not supported");
        }, new Position("AnalyzeTableTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
        this.test("Paimon analyze: analyze all supported cols", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE T (id STRING, name STRING, byte_col BYTE, short_col SHORT, int_col INT, long_col LONG,\n         |float_col FLOAT, double_col DOUBLE, decimal_col DECIMAL(10, 5), boolean_col BOOLEAN, date_col DATE,\n         |timestamp_col TIMESTAMP, binary BINARY)\n         |USING PAIMON\n         |TBLPROPERTIES ('primary-key'='id')\n         |")).stripMargin());
            this.spark().sql("INSERT INTO T VALUES ('1', 'a', 1, 1, 1, 1, 1.0, 1.0, 12.12345, true, cast('2020-01-01' as date), cast('2020-01-01 00:00:00' as timestamp), binary('example binary1'))");
            this.spark().sql("INSERT INTO T VALUES ('2', 'aaa', 1, null, 1, 1, 1.0, 1.0, 12.12345, true, cast('2020-01-02' as date), cast('2020-01-02 00:00:00' as timestamp), binary('example binary1'))");
            this.spark().sql("INSERT INTO T VALUES ('3', 'bbbb', 2, 1, 1, 1, 1.0, 1.0, 22.12345, true, cast('2020-01-02' as date), cast('2020-01-02 00:00:00' as timestamp), null)");
            this.spark().sql("INSERT INTO T VALUES ('4', 'bbbbbbbb', 2, 2, 2, 2, 2.0, 2.0, 22.12345, false, cast('2020-01-01' as date), cast('2020-01-01 00:00:00' as timestamp), binary('example binary2'))");
            this.spark().sql("ANALYZE TABLE T COMPUTE STATISTICS FOR ALL COLUMNS");
            Statistics stats = (Statistics)this.loadTable("T").statistics().get();
            org.junit.jupiter.api.Assertions.assertEquals((long)4L, (long)stats.mergedRecordCount().getAsLong());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)stats.mergedRecordSize().isPresent());
            Map colStats = stats.colStats();
            org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)0, (Long)Predef$.MODULE$.long2Long(4L), null, null, (Long)Predef$.MODULE$.long2Long(0L), (Long)Predef$.MODULE$.long2Long(1L), (Long)Predef$.MODULE$.long2Long(1L)), colStats.get("id"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)1, (Long)Predef$.MODULE$.long2Long(4L), null, null, (Long)Predef$.MODULE$.long2Long(0L), (Long)Predef$.MODULE$.long2Long(4L), (Long)Predef$.MODULE$.long2Long(8L)), colStats.get("name"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)2, (Long)Predef$.MODULE$.long2Long(2L), (Comparable)Predef$.MODULE$.byte2Byte((byte)1), (Comparable)Predef$.MODULE$.byte2Byte((byte)2), (Long)Predef$.MODULE$.long2Long(0L), (Long)Predef$.MODULE$.long2Long(1L), (Long)Predef$.MODULE$.long2Long(1L)), colStats.get("byte_col"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)3, (Long)Predef$.MODULE$.long2Long(2L), (Comparable)Predef$.MODULE$.short2Short((short)1), (Comparable)Predef$.MODULE$.short2Short((short)2), (Long)Predef$.MODULE$.long2Long(1L), (Long)Predef$.MODULE$.long2Long(2L), (Long)Predef$.MODULE$.long2Long(2L)), colStats.get("short_col"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)4, (Long)Predef$.MODULE$.long2Long(2L), (Comparable)Predef$.MODULE$.int2Integer(1), (Comparable)Predef$.MODULE$.int2Integer(2), (Long)Predef$.MODULE$.long2Long(0L), (Long)Predef$.MODULE$.long2Long(4L), (Long)Predef$.MODULE$.long2Long(4L)), colStats.get("int_col"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)5, (Long)Predef$.MODULE$.long2Long(2L), (Comparable)Predef$.MODULE$.long2Long(1L), (Comparable)Predef$.MODULE$.long2Long(2L), (Long)Predef$.MODULE$.long2Long(0L), (Long)Predef$.MODULE$.long2Long(8L), (Long)Predef$.MODULE$.long2Long(8L)), colStats.get("long_col"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)6, (Long)Predef$.MODULE$.long2Long(2L), (Comparable)Predef$.MODULE$.float2Float(1.0f), (Comparable)Predef$.MODULE$.float2Float(2.0f), (Long)Predef$.MODULE$.long2Long(0L), (Long)Predef$.MODULE$.long2Long(4L), (Long)Predef$.MODULE$.long2Long(4L)), colStats.get("float_col"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)7, (Long)Predef$.MODULE$.long2Long(2L), (Comparable)Predef$.MODULE$.double2Double(1.0), (Comparable)Predef$.MODULE$.double2Double(2.0), (Long)Predef$.MODULE$.long2Long(0L), (Long)Predef$.MODULE$.long2Long(8L), (Long)Predef$.MODULE$.long2Long(8L)), colStats.get("double_col"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)8, (Long)Predef$.MODULE$.long2Long(2L), (Comparable)Decimal.fromBigDecimal((BigDecimal)new BigDecimal("12.12345"), (int)10, (int)5), (Comparable)Decimal.fromBigDecimal((BigDecimal)new BigDecimal("22.12345"), (int)10, (int)5), (Long)Predef$.MODULE$.long2Long(0L), (Long)Predef$.MODULE$.long2Long(8L), (Long)Predef$.MODULE$.long2Long(8L)), colStats.get("decimal_col"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)9, (Long)Predef$.MODULE$.long2Long(2L), (Comparable)Predef$.MODULE$.boolean2Boolean(false), (Comparable)Predef$.MODULE$.boolean2Boolean(true), (Long)Predef$.MODULE$.long2Long(0L), (Long)Predef$.MODULE$.long2Long(1L), (Long)Predef$.MODULE$.long2Long(1L)), colStats.get("boolean_col"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)10, (Long)Predef$.MODULE$.long2Long(2L), (Comparable)Predef$.MODULE$.int2Integer(18262), (Comparable)Predef$.MODULE$.int2Integer(18263), (Long)Predef$.MODULE$.long2Long(0L), (Long)Predef$.MODULE$.long2Long(4L), (Long)Predef$.MODULE$.long2Long(4L)), colStats.get("date_col"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)11, (Long)Predef$.MODULE$.long2Long(2L), (Comparable)DateTimeUtils.parseTimestampData((String)"2020-01-01 00:00:00", (int)0), (Comparable)DateTimeUtils.parseTimestampData((String)"2020-01-02 00:00:00", (int)0), (Long)Predef$.MODULE$.long2Long(0L), (Long)Predef$.MODULE$.long2Long(8L), (Long)Predef$.MODULE$.long2Long(8L)), colStats.get("timestamp_col"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)12, (Long)Predef$.MODULE$.long2Long(2L), null, null, (Long)Predef$.MODULE$.long2Long(1L), (Long)Predef$.MODULE$.long2Long(15L), (Long)Predef$.MODULE$.long2Long(15L)), colStats.get("binary"));
            this.spark().sql("INSERT INTO T VALUES ('5', 'bbbbbbbbbbbbbbbb', 3, 3, 3, 3, 3.0, 3.0, 32.12345, false, cast('2020-01-03' as date), cast('2020-01-03 00:00:00' as timestamp), binary('binary3'))");
            this.spark().sql("ANALYZE TABLE T COMPUTE STATISTICS FOR ALL COLUMNS");
            stats = (Statistics)this.loadTable("T").statistics().get();
            org.junit.jupiter.api.Assertions.assertEquals((long)5L, (long)stats.mergedRecordCount().getAsLong());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)stats.mergedRecordSize().isPresent());
            colStats = stats.colStats();
            org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)0, (Long)Predef$.MODULE$.long2Long(5L), null, null, (Long)Predef$.MODULE$.long2Long(0L), (Long)Predef$.MODULE$.long2Long(1L), (Long)Predef$.MODULE$.long2Long(1L)), colStats.get("id"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)1, (Long)Predef$.MODULE$.long2Long(5L), null, null, (Long)Predef$.MODULE$.long2Long(0L), (Long)Predef$.MODULE$.long2Long(7L), (Long)Predef$.MODULE$.long2Long(16L)), colStats.get("name"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)2, (Long)Predef$.MODULE$.long2Long(3L), (Comparable)Predef$.MODULE$.byte2Byte((byte)1), (Comparable)Predef$.MODULE$.byte2Byte((byte)3), (Long)Predef$.MODULE$.long2Long(0L), (Long)Predef$.MODULE$.long2Long(1L), (Long)Predef$.MODULE$.long2Long(1L)), colStats.get("byte_col"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)3, (Long)Predef$.MODULE$.long2Long(3L), (Comparable)Predef$.MODULE$.short2Short((short)1), (Comparable)Predef$.MODULE$.short2Short((short)3), (Long)Predef$.MODULE$.long2Long(1L), (Long)Predef$.MODULE$.long2Long(2L), (Long)Predef$.MODULE$.long2Long(2L)), colStats.get("short_col"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)4, (Long)Predef$.MODULE$.long2Long(3L), (Comparable)Predef$.MODULE$.int2Integer(1), (Comparable)Predef$.MODULE$.int2Integer(3), (Long)Predef$.MODULE$.long2Long(0L), (Long)Predef$.MODULE$.long2Long(4L), (Long)Predef$.MODULE$.long2Long(4L)), colStats.get("int_col"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)5, (Long)Predef$.MODULE$.long2Long(3L), (Comparable)Predef$.MODULE$.long2Long(1L), (Comparable)Predef$.MODULE$.long2Long(3L), (Long)Predef$.MODULE$.long2Long(0L), (Long)Predef$.MODULE$.long2Long(8L), (Long)Predef$.MODULE$.long2Long(8L)), colStats.get("long_col"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)6, (Long)Predef$.MODULE$.long2Long(3L), (Comparable)Predef$.MODULE$.float2Float(1.0f), (Comparable)Predef$.MODULE$.float2Float(3.0f), (Long)Predef$.MODULE$.long2Long(0L), (Long)Predef$.MODULE$.long2Long(4L), (Long)Predef$.MODULE$.long2Long(4L)), colStats.get("float_col"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)7, (Long)Predef$.MODULE$.long2Long(3L), (Comparable)Predef$.MODULE$.double2Double(1.0), (Comparable)Predef$.MODULE$.double2Double(3.0), (Long)Predef$.MODULE$.long2Long(0L), (Long)Predef$.MODULE$.long2Long(8L), (Long)Predef$.MODULE$.long2Long(8L)), colStats.get("double_col"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)8, (Long)Predef$.MODULE$.long2Long(3L), (Comparable)Decimal.fromBigDecimal((BigDecimal)new BigDecimal("12.12345"), (int)10, (int)5), (Comparable)Decimal.fromBigDecimal((BigDecimal)new BigDecimal("32.12345"), (int)10, (int)5), (Long)Predef$.MODULE$.long2Long(0L), (Long)Predef$.MODULE$.long2Long(8L), (Long)Predef$.MODULE$.long2Long(8L)), colStats.get("decimal_col"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)9, (Long)Predef$.MODULE$.long2Long(2L), (Comparable)Predef$.MODULE$.boolean2Boolean(false), (Comparable)Predef$.MODULE$.boolean2Boolean(true), (Long)Predef$.MODULE$.long2Long(0L), (Long)Predef$.MODULE$.long2Long(1L), (Long)Predef$.MODULE$.long2Long(1L)), colStats.get("boolean_col"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)10, (Long)Predef$.MODULE$.long2Long(3L), (Comparable)Predef$.MODULE$.int2Integer(18262), (Comparable)Predef$.MODULE$.int2Integer(18264), (Long)Predef$.MODULE$.long2Long(0L), (Long)Predef$.MODULE$.long2Long(4L), (Long)Predef$.MODULE$.long2Long(4L)), colStats.get("date_col"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)11, (Long)Predef$.MODULE$.long2Long(3L), (Comparable)DateTimeUtils.parseTimestampData((String)"2020-01-01 00:00:00", (int)0), (Comparable)DateTimeUtils.parseTimestampData((String)"2020-01-03 00:00:00", (int)0), (Long)Predef$.MODULE$.long2Long(0L), (Long)Predef$.MODULE$.long2Long(8L), (Long)Predef$.MODULE$.long2Long(8L)), colStats.get("timestamp_col"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)12, (Long)Predef$.MODULE$.long2Long(3L), null, null, (Long)Predef$.MODULE$.long2Long(1L), (Long)Predef$.MODULE$.long2Long(13L), (Long)Predef$.MODULE$.long2Long(15L)), colStats.get("binary"));
        }, new Position("AnalyzeTableTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
        this.test("Paimon analyze: analyze unsupported cols", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n         |CREATE TABLE T (id STRING, m MAP<INT, STRING>, l ARRAY<INT>, s STRUCT<i:INT, s:STRING>)\n         |USING PAIMON\n         |TBLPROPERTIES ('primary-key'='id')\n         |")).stripMargin());
            this.spark().sql("INSERT INTO T VALUES ('1', map(1, 'a'), array(1), struct(1, 'a'))");
            Assertions.assertThatThrownBy(() -> this.spark().sql("ANALYZE TABLE T COMPUTE STATISTICS FOR COLUMNS m")).hasMessageContaining("not supported");
            Assertions.assertThatThrownBy(() -> this.spark().sql("ANALYZE TABLE T COMPUTE STATISTICS FOR COLUMNS l")).hasMessageContaining("not supported");
            return Assertions.assertThatThrownBy(() -> this.spark().sql("ANALYZE TABLE T COMPUTE STATISTICS FOR COLUMNS s")).hasMessageContaining("not supported");
        }, new Position("AnalyzeTableTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 218));
        this.test("Paimon analyze: analyze non-exist cols", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                 |CREATE TABLE T (id STRING, name STRING, i INT, l LONG)\n                 |USING PAIMON\n                 |TBLPROPERTIES ('primary-key'='id')\n                 |")).stripMargin());
            return Assertions.assertThatThrownBy(() -> this.spark().sql("ANALYZE TABLE T COMPUTE STATISTICS FOR COLUMNS fake_col")).hasMessageContaining("not found");
        }, new Position("AnalyzeTableTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 238));
        this.test("Paimon analyze: analyze specialized cols", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                 |CREATE TABLE T (id STRING, name STRING, i INT, l LONG)\n                 |USING PAIMON\n                 |TBLPROPERTIES ('primary-key'='id')\n                 |")).stripMargin());
            this.spark().sql("INSERT INTO T VALUES ('1', 'a', 1, 1)");
            this.spark().sql("INSERT INTO T VALUES ('2', 'aaa', 1, 2)");
            this.spark().sql("ANALYZE TABLE T COMPUTE STATISTICS FOR COLUMNS name, i");
            Map colStats = ((Statistics)this.loadTable("T").statistics().get()).colStats();
            org.junit.jupiter.api.Assertions.assertEquals(null, colStats.get("id"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)1, (Long)Predef$.MODULE$.long2Long(2L), null, null, (Long)Predef$.MODULE$.long2Long(0L), (Long)Predef$.MODULE$.long2Long(2L), (Long)Predef$.MODULE$.long2Long(3L)), colStats.get("name"));
            org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)2, (Long)Predef$.MODULE$.long2Long(1L), (Comparable)Predef$.MODULE$.int2Integer(1), (Comparable)Predef$.MODULE$.int2Integer(1), (Long)Predef$.MODULE$.long2Long(0L), (Long)Predef$.MODULE$.long2Long(4L), (Long)Predef$.MODULE$.long2Long(4L)), colStats.get("i"));
            org.junit.jupiter.api.Assertions.assertEquals(null, colStats.get("l"));
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1", "a", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1)}));
            Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2", "aaa", BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)}));
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql("SELECT * from T ORDER BY id"), (Seq)Nil$.MODULE$.$colon$colon((Object)row2).$colon$colon((Object)row));
        }, new Position("AnalyzeTableTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 249));
        this.test("Paimon analyze: statistics expire and clean", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                 |CREATE TABLE T (id STRING, name STRING)\n                 |USING PAIMON\n                 |TBLPROPERTIES ('primary-key'='id')\n                 |")).stripMargin());
            FileStoreTable table = this.loadTable("T");
            Path tableLocation = table.location();
            FileIO fileIO = table.fileIO();
            this.spark().sql("INSERT INTO T VALUES ('1', 'a')");
            this.spark().sql("ANALYZE TABLE T COMPUTE STATISTICS");
            this.spark().sql("INSERT INTO T VALUES ('2', 'b')");
            this.spark().sql("ANALYZE TABLE T COMPUTE STATISTICS");
            org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)this.statsFileCount(tableLocation, fileIO));
            this.spark().sql("CALL sys.expire_snapshots(table => 'test.T', retain_max => 1)");
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.statsFileCount(tableLocation, fileIO));
            Path orphanStats = new Path(tableLocation, "statistics/stats-orphan-0");
            fileIO.writeFileUtf8(orphanStats, "x");
            org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)this.statsFileCount(tableLocation, fileIO));
            Thread.sleep(1001L);
            String older_than = DateTimeUtils.formatLocalDateTime((LocalDateTime)DateTimeUtils.toLocalDateTime((long)System.currentTimeMillis()), (int)3);
            this.spark().sql(new StringBuilder(60).append("CALL sys.remove_orphan_files(table => 'T', older_than => '").append(older_than).append("')").toString());
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.statsFileCount(tableLocation, fileIO));
        }, new Position("AnalyzeTableTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 272));
        this.test("Paimon analyze: spark use table stats", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                 |CREATE TABLE T (id STRING, name STRING, i INT, l LONG)\n                 |USING PAIMON\n                 |TBLPROPERTIES ('primary-key'='id')\n                 |")).stripMargin());
            this.spark().sql("INSERT INTO T VALUES ('1', 'a', 1, 1)");
            this.spark().sql("INSERT INTO T VALUES ('2', 'aaa', 1, 2)");
            this.spark().sql("ANALYZE TABLE T COMPUTE STATISTICS");
            org.apache.spark.sql.catalyst.plans.logical.Statistics stats = this.getScanStatistic("SELECT * FROM T");
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)((BigInt)stats.rowCount().get()).longValue());
        }, new Position("AnalyzeTableTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 307));
        this.test("Paimon analyze: spark use col stats", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                 |CREATE TABLE T (id STRING, name STRING, i INT, l LONG)\n                 |USING PAIMON\n                 |TBLPROPERTIES ('primary-key'='id')\n                 |")).stripMargin());
            this.spark().sql("INSERT INTO T VALUES ('1', 'a', 1, 1)");
            this.spark().sql("INSERT INTO T VALUES ('2', 'aaa', 1, 2)");
            this.spark().sql("ANALYZE TABLE T COMPUTE STATISTICS FOR ALL COLUMNS");
            org.apache.spark.sql.catalyst.plans.logical.Statistics stats = this.getScanStatistic("SELECT * FROM T");
            org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)((BigInt)stats.rowCount().get()).longValue());
            org.junit.jupiter.api.Assertions.assertEquals((int)(this.supportsColStats() ? 4 : 0), (int)stats.attributeStats().size());
        }, new Position("AnalyzeTableTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 322));
        this.test("Paimon analyze: partition filter push down hit", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n                 |CREATE TABLE T (id INT, name STRING, pt INT)\n                 |TBLPROPERTIES ('primary-key'='id, pt', 'bucket'='2')\n                 |PARTITIONED BY (pt)\n                 |")).stripMargin());
            this.spark().sql("INSERT INTO T VALUES (1, 'a', 1), (2, 'b', 1), (3, 'c', 2), (4, 'd', 3)");
            this.spark().sql("ANALYZE TABLE T COMPUTE STATISTICS FOR ALL COLUMNS");
            ObjectRef sql = ObjectRef.create((Object)"SELECT * FROM T WHERE pt < 1");
            org.junit.jupiter.api.Assertions.assertEquals((long)(this.supportsColStats() ? 0L : 4L), (long)((BigInt)this.getScanStatistic((String)sql.elem).rowCount().get()).longValue());
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql((String)sql$1.elem), (Seq)Nil$.MODULE$);
            sql.elem = "SELECT id FROM T WHERE pt < 1";
            org.junit.jupiter.api.Assertions.assertEquals((long)(this.supportsColStats() ? 0L : 4L), (long)((BigInt)this.getScanStatistic((String)sql.elem).rowCount().get()).longValue());
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql((String)sql$1.elem), (Seq)Nil$.MODULE$);
            sql.elem = "SELECT * FROM T WHERE id < 1";
            org.junit.jupiter.api.Assertions.assertEquals((long)4L, (long)((BigInt)this.getScanStatistic((String)sql.elem).rowCount().get()).longValue());
            this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> this.spark().sql((String)sql$1.elem), (Seq)Nil$.MODULE$);
        }, new Position("AnalyzeTableTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 338));
    }
}

