/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark;

import java.util.List;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.spark.SparkReadTestBase;
import org.apache.paimon.testutils.assertj.PaimonAssertions;
import org.apache.spark.sql.Dataset;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.Test;

public class SparkTimeTravelWithDataFrameITCase
extends SparkReadTestBase {
    @Test
    public void testTravelToVersion() throws Exception {
        SparkTimeTravelWithDataFrameITCase.writeTable("t1", GenericRow.of((Object[])new Object[]{7, 2L, BinaryString.fromString((String)"7")}), GenericRow.of((Object[])new Object[]{8, 4L, BinaryString.fromString((String)"8")}));
        Dataset dataset = spark.read().format("paimon").option("path", tablePath1.toString()).option(CoreOptions.SCAN_SNAPSHOT_ID.key(), 1L).load();
        List results = dataset.collectAsList();
        Assertions.assertThat((String)results.toString()).isEqualTo("[[1,2,1], [5,6,3]]");
        dataset = spark.read().format("paimon").option("path", tablePath1.toString()).load();
        results = dataset.collectAsList();
        Assertions.assertThat((String)results.toString()).isEqualTo("[[1,2,1], [5,6,3], [7,2,7], [8,4,8]]");
    }

    @Test
    public void testTravelToTimestamp() throws Exception {
        long anchor = System.currentTimeMillis();
        SparkTimeTravelWithDataFrameITCase.writeTable("t1", GenericRow.of((Object[])new Object[]{7, 2L, BinaryString.fromString((String)"7")}), GenericRow.of((Object[])new Object[]{8, 4L, BinaryString.fromString((String)"8")}));
        Dataset dataset = spark.read().format("paimon").option(CoreOptions.SCAN_TIMESTAMP_MILLIS.key(), anchor).load(tablePath1.toString());
        List results = dataset.collectAsList();
        Assertions.assertThat((String)results.toString()).isEqualTo("[[1,2,1], [5,6,3]]");
        dataset = spark.read().format("paimon").load(tablePath1.toString());
        results = dataset.collectAsList();
        Assertions.assertThat((String)results.toString()).isEqualTo("[[1,2,1], [5,6,3], [7,2,7], [8,4,8]]");
    }

    @Test
    public void testTravelToOldSchema() throws Exception {
        long anchor = System.currentTimeMillis();
        spark.sql("ALTER TABLE t1 ADD COLUMN dt STRING");
        SparkTimeTravelWithDataFrameITCase.writeTable("t1", GenericRow.of((Object[])new Object[]{7, 2L, BinaryString.fromString((String)"7"), BinaryString.fromString((String)"7")}), GenericRow.of((Object[])new Object[]{8, 4L, BinaryString.fromString((String)"8"), BinaryString.fromString((String)"8")}));
        Dataset dataset = spark.read().format("paimon").option("path", tablePath1.toString()).option(CoreOptions.SCAN_TIMESTAMP_MILLIS.key(), anchor).load();
        List results = dataset.collectAsList();
        Assertions.assertThat((String)results.toString()).isEqualTo("[[1,2,1], [5,6,3]]");
        dataset = spark.read().format("paimon").option("path", tablePath1.toString()).load();
        results = dataset.collectAsList();
        Assertions.assertThat((String)results.toString()).isEqualTo("[[1,2,1,null], [5,6,3,null], [7,2,7,7], [8,4,8,8]]");
    }

    @Test
    public void testTravelToNonExistedVersion() {
        Assertions.assertThatThrownBy(() -> spark.read().format("paimon").option("path", tablePath1.toString()).option(CoreOptions.SCAN_SNAPSHOT_ID.key(), 3L).load().collectAsList()).satisfies(new ThrowingConsumer[]{PaimonAssertions.anyCauseMatches(RuntimeException.class, (String)"Fails to read snapshot from path file")});
    }

    @Test
    public void testTravelToNonExistedTimestamp() {
        Dataset dataset = spark.read().format("paimon").option("path", tablePath1.toString()).option(CoreOptions.SCAN_TIMESTAMP_MILLIS.key(), 0L).load();
        Assertions.assertThat((List)dataset.collectAsList()).isEmpty();
    }

    @Test
    public void testTravelToTag() throws Exception {
        SparkTimeTravelWithDataFrameITCase.writeTable("t1", GenericRow.of((Object[])new Object[]{7, 2L, BinaryString.fromString((String)"7")}), GenericRow.of((Object[])new Object[]{8, 4L, BinaryString.fromString((String)"8")}));
        SparkTimeTravelWithDataFrameITCase.getTable("t1").createTag("tag1", 1L);
        Dataset dataset = spark.read().format("paimon").option(CoreOptions.SCAN_TAG_NAME.key(), "tag1").load(tablePath1.toString());
        List results = dataset.collectAsList();
        Assertions.assertThat((String)results.toString()).isEqualTo("[[1,2,1], [5,6,3]]");
        dataset = spark.read().format("paimon").load(tablePath1.toString());
        results = dataset.collectAsList();
        Assertions.assertThat((String)results.toString()).isEqualTo("[[1,2,1], [5,6,3], [7,2,7], [8,4,8]]");
    }

    @Test
    public void testIllegalVersion() {
        Assertions.assertThatThrownBy(() -> spark.read().format("paimon").option("path", tablePath1.toString()).option(CoreOptions.SCAN_SNAPSHOT_ID.key(), 1.5).load().collectAsList()).satisfies(new ThrowingConsumer[]{PaimonAssertions.anyCauseMatches(IllegalArgumentException.class, (String)"Could not parse value '1.5' for key 'scan.snapshot-id'")});
    }
}

