/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.stats;

import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import javax.annotation.Nullable;
import org.apache.paimon.annotation.Experimental;
import org.apache.paimon.data.serializer.InternalSerializers;
import org.apache.paimon.data.serializer.Serializer;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.paimon.types.DataType;
import org.apache.paimon.utils.JsonSerdeUtil;
import org.apache.paimon.utils.OptionalUtils;

@Experimental
public class ColStats<T> {
    private static final String FIELD_COL_ID = "colId";
    private static final String FIELD_DISTINCT_COUNT = "distinctCount";
    private static final String FIELD_MIN = "min";
    private static final String FIELD_MAX = "max";
    private static final String FIELD_NULL_COUNT = "nullCount";
    private static final String FIELD_AVG_LEN = "avgLen";
    private static final String FIELD_MAX_LEN = "maxLen";
    @JsonProperty(value="colId")
    private final int colId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="distinctCount")
    @Nullable
    private final Long distinctCount;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="min")
    @Nullable
    private String serializedMin;
    @Nullable
    private Comparable<T> min;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="max")
    @Nullable
    private String serializedMax;
    @Nullable
    private Comparable<T> max;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="nullCount")
    @Nullable
    private final Long nullCount;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="avgLen")
    @Nullable
    private final Long avgLen;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="maxLen")
    @Nullable
    private final Long maxLen;

    @JsonCreator
    public ColStats(@JsonProperty(value="colId") int colId, @JsonProperty(value="distinctCount") @Nullable Long distinctCount, @JsonProperty(value="min") @Nullable String serializedMin, @JsonProperty(value="max") @Nullable String serializedMax, @JsonProperty(value="nullCount") @Nullable Long nullCount, @JsonProperty(value="avgLen") @Nullable Long avgLen, @JsonProperty(value="maxLen") @Nullable Long maxLen) {
        this.colId = colId;
        this.distinctCount = distinctCount;
        this.serializedMin = serializedMin;
        this.serializedMax = serializedMax;
        this.nullCount = nullCount;
        this.avgLen = avgLen;
        this.maxLen = maxLen;
    }

    private ColStats(int colId, @Nullable Long distinctCount, @Nullable Comparable<T> min, @Nullable Comparable<T> max, @Nullable Long nullCount, @Nullable Long avgLen, @Nullable Long maxLen) {
        this.colId = colId;
        this.distinctCount = distinctCount;
        this.min = min;
        this.max = max;
        this.nullCount = nullCount;
        this.avgLen = avgLen;
        this.maxLen = maxLen;
    }

    public static <T> ColStats<T> newColStats(int colId, @Nullable Long distinctCount, @Nullable Comparable<T> min, @Nullable Comparable<T> max, @Nullable Long nullCount, @Nullable Long avgLen, @Nullable Long maxLen) {
        return new ColStats<T>(colId, distinctCount, min, max, nullCount, avgLen, maxLen);
    }

    public int colId() {
        return this.colId;
    }

    public OptionalLong distinctCount() {
        return OptionalUtils.ofNullable(this.distinctCount);
    }

    public Optional<Comparable<T>> min() {
        return Optional.ofNullable(this.min);
    }

    public Optional<Comparable<T>> max() {
        return Optional.ofNullable(this.max);
    }

    public OptionalLong nullCount() {
        return OptionalUtils.ofNullable(this.nullCount);
    }

    public OptionalLong avgLen() {
        return OptionalUtils.ofNullable(this.avgLen);
    }

    public OptionalLong maxLen() {
        return OptionalUtils.ofNullable(this.maxLen);
    }

    public void serializeFieldsToString(DataType dataType) {
        if (this.min != null && this.serializedMin == null || this.max != null && this.serializedMax == null) {
            Serializer<Comparable<T>> serializer = InternalSerializers.create(dataType);
            if (this.min != null && this.serializedMin == null) {
                this.serializedMin = serializer.serializeToString(this.min);
            }
            if (this.max != null && this.serializedMax == null) {
                this.serializedMax = serializer.serializeToString(this.max);
            }
        }
    }

    public void deserializeFieldsFromString(DataType dataType) {
        if (this.serializedMin != null && this.min == null || this.serializedMax != null && this.max == null) {
            Serializer serializer = InternalSerializers.create(dataType);
            if (this.serializedMin != null && this.min == null) {
                this.min = (Comparable)serializer.deserializeFromString(this.serializedMin);
            }
            if (this.serializedMax != null && this.max == null) {
                this.max = (Comparable)serializer.deserializeFromString(this.serializedMax);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColStats colStats = (ColStats)o;
        return this.colId == colStats.colId && Objects.equals(this.distinctCount, colStats.distinctCount) && Objects.equals(this.min, colStats.min) && Objects.equals(this.max, colStats.max) && Objects.equals(this.nullCount, colStats.nullCount) && Objects.equals(this.avgLen, colStats.avgLen) && Objects.equals(this.maxLen, colStats.maxLen);
    }

    public int hashCode() {
        return Objects.hash(this.colId, this.distinctCount, this.min, this.max, this.nullCount, this.avgLen, this.maxLen);
    }

    public String toString() {
        return JsonSerdeUtil.toJson(this);
    }
}

