/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark;

import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.disk.IOManagerImpl;
import org.apache.paimon.utils.Pair;
import org.apache.paimon.utils.Preconditions;
import org.apache.spark.SparkEnv;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.catalyst.parser.ParserInterface;
import org.apache.spark.sql.connector.catalog.CatalogManager;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.Identifier;
import scala.collection.JavaConverters;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;

public class SparkUtils {
    public static IOManager createIOManager() {
        String[] localDirs = SparkEnv.get().blockManager().diskBlockManager().localDirsString();
        return new IOManagerImpl(localDirs);
    }

    public static <C, T> Pair<C, T> catalogAndIdentifier(List<String> nameParts, Function<String, C> catalogProvider, BiFunction<String[], String, T> identifierProvider, C currentCatalog, String[] currentNamespace) {
        Preconditions.checkArgument(!nameParts.isEmpty(), "Cannot determine catalog and identifier from empty name");
        int lastElementIndex = nameParts.size() - 1;
        String name = nameParts.get(lastElementIndex);
        if (nameParts.size() == 1) {
            return Pair.of(currentCatalog, identifierProvider.apply(currentNamespace, name));
        }
        C catalog = catalogProvider.apply(nameParts.get(0));
        if (catalog == null) {
            String[] namespace = nameParts.subList(0, lastElementIndex).toArray(new String[0]);
            return Pair.of(currentCatalog, identifierProvider.apply(namespace, name));
        }
        String[] namespace = nameParts.subList(1, lastElementIndex).toArray(new String[0]);
        return Pair.of(catalog, identifierProvider.apply(namespace, name));
    }

    public static CatalogAndIdentifier catalogAndIdentifier(SparkSession spark, List<String> nameParts, CatalogPlugin defaultCatalog) {
        CatalogManager catalogManager = spark.sessionState().catalogManager();
        String[] currentNamespace = defaultCatalog.equals(catalogManager.currentCatalog()) ? catalogManager.currentNamespace() : defaultCatalog.defaultNamespace();
        Pair<CatalogPlugin, Identifier> catalogIdentifier = SparkUtils.catalogAndIdentifier(nameParts, catalogName -> {
            try {
                return catalogManager.catalog(catalogName);
            }
            catch (Exception e) {
                return null;
            }
        }, Identifier::of, defaultCatalog, currentNamespace);
        return new CatalogAndIdentifier(catalogIdentifier);
    }

    public static CatalogAndIdentifier catalogAndIdentifier(SparkSession spark, String name, CatalogPlugin defaultCatalog) throws ParseException {
        ParserInterface parser = spark.sessionState().sqlParser();
        IndexedSeq multiPartIdentifier = parser.parseMultipartIdentifier(name).toIndexedSeq();
        List javaMultiPartIdentifier = JavaConverters.seqAsJavaList((Seq)multiPartIdentifier);
        return SparkUtils.catalogAndIdentifier(spark, javaMultiPartIdentifier, defaultCatalog);
    }

    public static CatalogAndIdentifier catalogAndIdentifier(String description, SparkSession spark, String name, CatalogPlugin defaultCatalog) {
        try {
            return SparkUtils.catalogAndIdentifier(spark, name, defaultCatalog);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Cannot parse " + description + ": " + name, e);
        }
    }

    public static class CatalogAndIdentifier {
        private final CatalogPlugin catalog;
        private final Identifier identifier;

        public CatalogAndIdentifier(Pair<CatalogPlugin, Identifier> identifier) {
            this.catalog = identifier.getLeft();
            this.identifier = identifier.getRight();
        }

        public CatalogPlugin catalog() {
            return this.catalog;
        }

        public Identifier identifier() {
            return this.identifier;
        }
    }
}

