/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.deletionvectors;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.CRC32;
import org.apache.paimon.deletionvectors.DeletionVector;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.fs.SeekableInputStream;
import org.apache.paimon.index.IndexFile;
import org.apache.paimon.utils.Pair;
import org.apache.paimon.utils.PathFactory;

public class DeletionVectorsIndexFile
extends IndexFile {
    public static final String DELETION_VECTORS_INDEX = "DELETION_VECTORS";
    public static final byte VERSION_ID_V1 = 1;

    public DeletionVectorsIndexFile(FileIO fileIO, PathFactory pathFactory) {
        super(fileIO, pathFactory);
    }

    public Map<String, DeletionVector> readAllDeletionVectors(String fileName, LinkedHashMap<String, Pair<Integer, Integer>> deletionVectorRanges) {
        HashMap<String, DeletionVector> deletionVectors = new HashMap<String, DeletionVector>();
        Path filePath = this.pathFactory.toPath(fileName);
        try (SeekableInputStream inputStream = this.fileIO.newInputStream(filePath);){
            this.checkVersion(inputStream);
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            for (Map.Entry<String, Pair<Integer, Integer>> entry : deletionVectorRanges.entrySet()) {
                deletionVectors.put(entry.getKey(), this.readDeletionVector(dataInputStream, entry.getValue().getRight()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to read deletion vectors from file: " + filePath + ", deletionVectorRanges: " + deletionVectorRanges, e);
        }
        return deletionVectors;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DeletionVector readDeletionVector(String fileName, Pair<Integer, Integer> deletionVectorRange) {
        Path filePath = this.pathFactory.toPath(fileName);
        try (SeekableInputStream inputStream = this.fileIO.newInputStream(filePath);){
            this.checkVersion(inputStream);
            inputStream.seek(deletionVectorRange.getLeft().intValue());
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            DeletionVector deletionVector = this.readDeletionVector(dataInputStream, deletionVectorRange.getRight());
            return deletionVector;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to read deletion vector from file: " + filePath + ", deletionVectorRange: " + deletionVectorRange, e);
        }
    }

    public Pair<String, LinkedHashMap<String, Pair<Integer, Integer>>> write(Map<String, DeletionVector> input) {
        int size = input.size();
        LinkedHashMap<String, Pair<Integer, Integer>> deletionVectorRanges = new LinkedHashMap<String, Pair<Integer, Integer>>(size);
        Path path = this.pathFactory.newPath();
        try (DataOutputStream dataOutputStream = new DataOutputStream(this.fileIO.newOutputStream(path, true));){
            dataOutputStream.writeByte(1);
            for (Map.Entry<String, DeletionVector> entry : input.entrySet()) {
                String key = entry.getKey();
                byte[] valueBytes = entry.getValue().serializeToBytes();
                deletionVectorRanges.put(key, Pair.of(dataOutputStream.size(), valueBytes.length));
                dataOutputStream.writeInt(valueBytes.length);
                dataOutputStream.write(valueBytes);
                dataOutputStream.writeInt(this.calculateChecksum(valueBytes));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to write deletion vectors to file: " + path.getName(), e);
        }
        return Pair.of(path.getName(), deletionVectorRanges);
    }

    private void checkVersion(InputStream in) throws IOException {
        int version = in.read();
        if (version != 1) {
            throw new RuntimeException("Version not match, actual version: " + version + ", expert version: " + 1);
        }
    }

    private DeletionVector readDeletionVector(DataInputStream inputStream, int size) {
        try {
            int actualSize = inputStream.readInt();
            if (actualSize != size) {
                throw new RuntimeException("Size not match, actual size: " + actualSize + ", expert size: " + size);
            }
            byte[] bytes = new byte[size];
            inputStream.readFully(bytes);
            int checkSum = this.calculateChecksum(bytes);
            int actualCheckSum = inputStream.readInt();
            if (actualCheckSum != checkSum) {
                throw new RuntimeException("Checksum not match, actual checksum: " + actualCheckSum + ", expected checksum: " + checkSum);
            }
            return DeletionVector.deserializeFromBytes(bytes);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to read deletion vector", e);
        }
    }

    private int calculateChecksum(byte[] bytes) {
        CRC32 crc = new CRC32();
        crc.update(bytes);
        return (int)crc.getValue();
    }
}

