/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.data;

import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalMap;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.types.RowKind;

@Public
public class JoinedRow
implements InternalRow {
    private RowKind rowKind = RowKind.INSERT;
    private InternalRow row1;
    private InternalRow row2;

    public JoinedRow() {
    }

    public JoinedRow(@Nullable InternalRow row1, @Nullable InternalRow row2) {
        this(RowKind.INSERT, row1, row2);
    }

    public JoinedRow(RowKind rowKind, @Nullable InternalRow row1, @Nullable InternalRow row2) {
        this.rowKind = rowKind;
        this.row1 = row1;
        this.row2 = row2;
    }

    public static JoinedRow join(InternalRow row1, InternalRow row2) {
        return new JoinedRow(row1, row2);
    }

    public JoinedRow replace(InternalRow row1, InternalRow row2) {
        this.row1 = row1;
        this.row2 = row2;
        return this;
    }

    public InternalRow row1() {
        return this.row1;
    }

    public InternalRow row2() {
        return this.row2;
    }

    @Override
    public int getFieldCount() {
        return this.row1.getFieldCount() + this.row2.getFieldCount();
    }

    @Override
    public RowKind getRowKind() {
        return this.rowKind;
    }

    @Override
    public void setRowKind(RowKind kind) {
        this.rowKind = kind;
    }

    @Override
    public boolean isNullAt(int pos) {
        if (pos < this.row1.getFieldCount()) {
            return this.row1.isNullAt(pos);
        }
        return this.row2.isNullAt(pos - this.row1.getFieldCount());
    }

    @Override
    public boolean getBoolean(int pos) {
        if (pos < this.row1.getFieldCount()) {
            return this.row1.getBoolean(pos);
        }
        return this.row2.getBoolean(pos - this.row1.getFieldCount());
    }

    @Override
    public byte getByte(int pos) {
        if (pos < this.row1.getFieldCount()) {
            return this.row1.getByte(pos);
        }
        return this.row2.getByte(pos - this.row1.getFieldCount());
    }

    @Override
    public short getShort(int pos) {
        if (pos < this.row1.getFieldCount()) {
            return this.row1.getShort(pos);
        }
        return this.row2.getShort(pos - this.row1.getFieldCount());
    }

    @Override
    public int getInt(int pos) {
        if (pos < this.row1.getFieldCount()) {
            return this.row1.getInt(pos);
        }
        return this.row2.getInt(pos - this.row1.getFieldCount());
    }

    @Override
    public long getLong(int pos) {
        if (pos < this.row1.getFieldCount()) {
            return this.row1.getLong(pos);
        }
        return this.row2.getLong(pos - this.row1.getFieldCount());
    }

    @Override
    public float getFloat(int pos) {
        if (pos < this.row1.getFieldCount()) {
            return this.row1.getFloat(pos);
        }
        return this.row2.getFloat(pos - this.row1.getFieldCount());
    }

    @Override
    public double getDouble(int pos) {
        if (pos < this.row1.getFieldCount()) {
            return this.row1.getDouble(pos);
        }
        return this.row2.getDouble(pos - this.row1.getFieldCount());
    }

    @Override
    public BinaryString getString(int pos) {
        if (pos < this.row1.getFieldCount()) {
            return this.row1.getString(pos);
        }
        return this.row2.getString(pos - this.row1.getFieldCount());
    }

    @Override
    public Decimal getDecimal(int pos, int precision, int scale) {
        if (pos < this.row1.getFieldCount()) {
            return this.row1.getDecimal(pos, precision, scale);
        }
        return this.row2.getDecimal(pos - this.row1.getFieldCount(), precision, scale);
    }

    @Override
    public Timestamp getTimestamp(int pos, int precision) {
        if (pos < this.row1.getFieldCount()) {
            return this.row1.getTimestamp(pos, precision);
        }
        return this.row2.getTimestamp(pos - this.row1.getFieldCount(), precision);
    }

    @Override
    public byte[] getBinary(int pos) {
        if (pos < this.row1.getFieldCount()) {
            return this.row1.getBinary(pos);
        }
        return this.row2.getBinary(pos - this.row1.getFieldCount());
    }

    @Override
    public InternalArray getArray(int pos) {
        if (pos < this.row1.getFieldCount()) {
            return this.row1.getArray(pos);
        }
        return this.row2.getArray(pos - this.row1.getFieldCount());
    }

    @Override
    public InternalMap getMap(int pos) {
        if (pos < this.row1.getFieldCount()) {
            return this.row1.getMap(pos);
        }
        return this.row2.getMap(pos - this.row1.getFieldCount());
    }

    @Override
    public InternalRow getRow(int pos, int numFields) {
        if (pos < this.row1.getFieldCount()) {
            return this.row1.getRow(pos, numFields);
        }
        return this.row2.getRow(pos - this.row1.getFieldCount(), numFields);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JoinedRow that = (JoinedRow)o;
        return Objects.equals((Object)this.rowKind, (Object)that.rowKind) && Objects.equals(this.row1, that.row1) && Objects.equals(this.row2, that.row2);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.rowKind, this.row1, this.row2});
    }

    public String toString() {
        return this.rowKind.shortString() + "{row1=" + this.row1 + ", row2=" + this.row2 + '}';
    }
}

