/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.service.messages;

import java.util.Random;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.service.messages.KvRequestTest;
import org.apache.paimon.service.messages.KvResponse;
import org.apache.paimon.shade.netty4.io.netty.buffer.ByteBuf;
import org.apache.paimon.shade.netty4.io.netty.buffer.UnpooledByteBufAllocator;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class KvResponseTest {
    @Test
    void testSerialization() {
        KvResponse request = KvResponseTest.random();
        byte[] serialize = request.serialize();
        ByteBuf byteBuf = UnpooledByteBufAllocator.DEFAULT.heapBuffer();
        byteBuf.writeBytes(serialize);
        KvResponse newRequest = new KvResponse.KvResponseDeserializer().deserializeMessage(byteBuf);
        Assertions.assertThat((Object)newRequest).isEqualTo((Object)request);
    }

    public static KvResponse random() {
        Random rnd = new Random();
        BinaryRow[] values = new BinaryRow[rnd.nextInt(100)];
        for (int i = 0; i < values.length; ++i) {
            if (rnd.nextInt(10) == 0) continue;
            values[i] = KvRequestTest.row(rnd.nextInt());
        }
        return new KvResponse(values);
    }
}

