/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree.compact;

import javax.annotation.Nullable;
import org.apache.paimon.KeyValue;
import org.apache.paimon.data.serializer.InternalRowSerializer;
import org.apache.paimon.mergetree.compact.MergeFunction;
import org.apache.paimon.mergetree.compact.MergeFunctionFactory;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.Preconditions;

public class FirstRowMergeFunction
implements MergeFunction<KeyValue> {
    private final InternalRowSerializer keySerializer;
    private final InternalRowSerializer valueSerializer;
    private KeyValue first;
    public boolean containsHighLevel;

    protected FirstRowMergeFunction(RowType keyType, RowType valueType) {
        this.keySerializer = new InternalRowSerializer(keyType);
        this.valueSerializer = new InternalRowSerializer(valueType);
    }

    @Override
    public void reset() {
        this.first = null;
        this.containsHighLevel = false;
    }

    @Override
    public void add(KeyValue kv) {
        Preconditions.checkArgument(kv.valueKind().isAdd(), "By default, First row merge engine can not accept DELETE/UPDATE_BEFORE records.\nYou can config 'ignore-delete' to ignore the DELETE/UPDATE_BEFORE records.");
        if (this.first == null) {
            this.first = kv.copy(this.keySerializer, this.valueSerializer);
        }
        if (kv.level() > 0) {
            this.containsHighLevel = true;
        }
    }

    @Override
    public KeyValue getResult() {
        return this.first;
    }

    public static MergeFunctionFactory<KeyValue> factory(RowType keyType, RowType valueType) {
        return new Factory(keyType, valueType);
    }

    private static class Factory
    implements MergeFunctionFactory<KeyValue> {
        private static final long serialVersionUID = 1L;
        private final RowType keyType;
        private final RowType valueType;

        public Factory(RowType keyType, RowType valueType) {
            this.keyType = keyType;
            this.valueType = valueType;
        }

        @Override
        public MergeFunction<KeyValue> create(@Nullable int[][] projection) {
            return new FirstRowMergeFunction(this.keyType, this.valueType);
        }
    }
}

