/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.manifest;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.paimon.data.serializer.VersionedSerializer;
import org.apache.paimon.io.DataInputDeserializer;
import org.apache.paimon.io.DataOutputViewStreamWrapper;
import org.apache.paimon.manifest.ManifestCommittable;
import org.apache.paimon.table.sink.CommitMessage;
import org.apache.paimon.table.sink.CommitMessageSerializer;

public class ManifestCommittableSerializer
implements VersionedSerializer<ManifestCommittable> {
    private static final int CURRENT_VERSION = 2;
    private final CommitMessageSerializer commitMessageSerializer = new CommitMessageSerializer();

    @Override
    public int getVersion() {
        return 2;
    }

    @Override
    public byte[] serialize(ManifestCommittable obj) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputViewStreamWrapper view = new DataOutputViewStreamWrapper(out);
        view.writeLong(obj.identifier());
        Long watermark = obj.watermark();
        if (watermark == null) {
            view.writeBoolean(true);
        } else {
            view.writeBoolean(false);
            view.writeLong(watermark);
        }
        this.serializeOffsets(view, obj.logOffsets());
        view.writeInt(this.commitMessageSerializer.getVersion());
        this.commitMessageSerializer.serializeList(obj.fileCommittables(), view);
        return out.toByteArray();
    }

    private void serializeOffsets(DataOutputViewStreamWrapper view, Map<Integer, Long> offsets) throws IOException {
        view.writeInt(offsets.size());
        for (Map.Entry<Integer, Long> entry : offsets.entrySet()) {
            view.writeInt(entry.getKey());
            view.writeLong(entry.getValue());
        }
    }

    @Override
    public ManifestCommittable deserialize(int version, byte[] serialized) throws IOException {
        if (version != 2) {
            throw new UnsupportedOperationException("Expecting ManifestCommittable version to be 2, but found " + version + ".\nManifestCommittable is not a compatible data structure. Please restart the job afresh (do not recover from savepoint).");
        }
        DataInputDeserializer view = new DataInputDeserializer(serialized);
        long identifier = view.readLong();
        Long watermark = view.readBoolean() ? null : Long.valueOf(view.readLong());
        Map<Integer, Long> offsets = this.deserializeOffsets(view);
        int fileCommittableSerializerVersion = view.readInt();
        List<CommitMessage> fileCommittables = this.commitMessageSerializer.deserializeList(fileCommittableSerializerVersion, view);
        return new ManifestCommittable(identifier, watermark, offsets, fileCommittables);
    }

    private Map<Integer, Long> deserializeOffsets(DataInputDeserializer view) throws IOException {
        int size = view.readInt();
        HashMap<Integer, Long> offsets = new HashMap<Integer, Long>(size);
        for (int i = 0; i < size; ++i) {
            offsets.put(view.readInt(), view.readLong());
        }
        return offsets;
    }
}

