/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive.objectinspector;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.hive.objectinspector.PaimonObjectInspectorFactory;
import org.apache.paimon.types.DataType;

public class PaimonListObjectInspector
implements ListObjectInspector {
    private final ObjectInspector elementObjectInspector;
    private final InternalArray.ElementGetter elementGetter;

    public PaimonListObjectInspector(DataType elementType) {
        this.elementObjectInspector = PaimonObjectInspectorFactory.create(elementType);
        this.elementGetter = InternalArray.createElementGetter(elementType);
    }

    public ObjectInspector getListElementObjectInspector() {
        return this.elementObjectInspector;
    }

    public Object getListElement(Object o, int i) {
        if (o == null) {
            return null;
        }
        return this.elementGetter.getElementOrNull((InternalArray)o, i);
    }

    public int getListLength(Object o) {
        if (o == null) {
            return -1;
        }
        return ((InternalArray)o).size();
    }

    public List<?> getList(Object o) {
        if (o == null) {
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i = 0; i < this.getListLength(o); ++i) {
            result.add(this.getListElement(o, i));
        }
        return result;
    }

    public String getTypeName() {
        return "array<" + this.elementObjectInspector.getTypeName() + ">";
    }

    public ObjectInspector.Category getCategory() {
        return ObjectInspector.Category.LIST;
    }
}

