/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive.objectinspector;

import java.math.BigDecimal;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.hive.objectinspector.WriteableObjectInspector;

public class PaimonDecimalObjectInspector
extends AbstractPrimitiveJavaObjectInspector
implements HiveDecimalObjectInspector,
WriteableObjectInspector {
    public PaimonDecimalObjectInspector(int precision, int scale) {
        super((PrimitiveTypeInfo)TypeInfoFactory.getDecimalTypeInfo((int)precision, (int)scale));
    }

    public HiveDecimal getPrimitiveJavaObject(Object o) {
        return o == null ? null : HiveDecimal.create((BigDecimal)((Decimal)o).toBigDecimal());
    }

    public HiveDecimalWritable getPrimitiveWritableObject(Object o) {
        HiveDecimal decimal = this.getPrimitiveJavaObject(o);
        return decimal == null ? null : new HiveDecimalWritable(decimal);
    }

    public Object copyObject(Object o) {
        if (o instanceof Decimal) {
            return ((Decimal)o).copy();
        }
        if (o instanceof HiveDecimal) {
            HiveDecimal hiveDecimal = (HiveDecimal)o;
            return HiveDecimal.create((BigDecimal)hiveDecimal.bigDecimalValue());
        }
        return o;
    }

    @Override
    public Decimal convert(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof HiveDecimalWritable) {
            o = ((HiveDecimalWritable)o).getHiveDecimal();
        }
        BigDecimal result = ((HiveDecimal)o).bigDecimalValue();
        result = result.setScale(this.scale());
        return Decimal.fromBigDecimal(result, result.precision(), result.scale());
    }
}

