/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive.mapred;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.JoinedRow;
import org.apache.paimon.hive.RowDataContainer;
import org.apache.paimon.hive.mapred.PaimonInputSplit;
import org.apache.paimon.hive.utils.HiveUtils;
import org.apache.paimon.reader.RecordReaderIterator;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.source.ReadBuilder;
import org.apache.paimon.utils.ProjectedRow;

public class PaimonRecordReader
implements RecordReader<Void, RowDataContainer> {
    private final RecordReaderIterator<InternalRow> iterator;
    private final long splitLength;
    @Nullable
    private final ProjectedRow reusedProjectedRow;
    @Nullable
    private final JoinedRow addTagToPartFieldRow;
    private float progress;

    public PaimonRecordReader(ReadBuilder readBuilder, PaimonInputSplit split, List<String> paimonColumns, List<String> hiveColumns, List<String> selectedColumns, @Nullable String tagToPartField) throws IOException {
        LinkedHashMap paimonColumnIndexMap = IntStream.range(0, paimonColumns.size()).boxed().collect(Collectors.toMap(index -> ((String)paimonColumns.get((int)index)).toLowerCase(), index -> index, (existing, replacement) -> existing, LinkedHashMap::new));
        if (!new ArrayList(paimonColumnIndexMap.keySet()).equals(selectedColumns)) {
            readBuilder.withProjection(selectedColumns.stream().mapToInt(paimonColumnIndexMap::get).toArray());
        }
        this.reusedProjectedRow = hiveColumns.equals(selectedColumns) ? null : ProjectedRow.from(hiveColumns.stream().mapToInt(selectedColumns::indexOf).toArray());
        this.iterator = new RecordReaderIterator<InternalRow>(readBuilder.newRead().createReader(split.split()));
        this.splitLength = split.getLength();
        if (tagToPartField != null) {
            String tag = HiveUtils.extractTagName(split.getPath().getName(), tagToPartField);
            this.addTagToPartFieldRow = new JoinedRow();
            this.addTagToPartFieldRow.replace(null, GenericRow.of(BinaryString.fromString(tag)));
        } else {
            this.addTagToPartFieldRow = null;
        }
        this.progress = 0.0f;
    }

    public boolean next(Void key, RowDataContainer value) throws IOException {
        InternalRow rowData = this.iterator.next();
        if (rowData == null) {
            this.progress = 1.0f;
            return false;
        }
        if (this.reusedProjectedRow != null) {
            value.set(this.reusedProjectedRow.replaceRow(rowData));
        } else {
            value.set(rowData);
        }
        if (this.addTagToPartFieldRow != null) {
            value.set(this.addTagToPartFieldRow.replace(value.get(), this.addTagToPartFieldRow.row2()));
        }
        return true;
    }

    public Void createKey() {
        return null;
    }

    public RowDataContainer createValue() {
        return new RowDataContainer();
    }

    public long getPos() throws IOException {
        return (long)((float)this.splitLength * this.getProgress());
    }

    public void close() throws IOException {
        try {
            this.iterator.close();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public float getProgress() throws IOException {
        return this.progress;
    }

    public static RecordReader<Void, RowDataContainer> createRecordReader(PaimonInputSplit split, JobConf jobConf) throws IOException {
        FileStoreTable table = split.getTable();
        ReadBuilder readBuilder = table.newReadBuilder();
        HiveUtils.createPredicate(table.schema(), jobConf, true).ifPresent(readBuilder::withFilter);
        List<String> paimonColumns = table.schema().fieldNames();
        return new PaimonRecordReader(readBuilder, split, paimonColumns, PaimonRecordReader.getHiveColumns(jobConf).orElse(paimonColumns), Arrays.asList(PaimonRecordReader.getSelectedColumns(jobConf)), table.coreOptions().tagToPartitionField());
    }

    private static Optional<List<String>> getHiveColumns(JobConf jobConf) {
        String columns = jobConf.get("schema.evolution.columns");
        if (columns == null) {
            columns = jobConf.get("columns");
        }
        String delimiter = jobConf.get("column.name.delimite", String.valueOf(','));
        if (columns == null || delimiter == null) {
            return Optional.empty();
        }
        return Optional.of(Arrays.asList(columns.split(delimiter)));
    }

    private static String[] getSelectedColumns(JobConf jobConf) {
        return (String[])Arrays.stream(ColumnProjectionUtils.getReadColumnNames((Configuration)jobConf)).distinct().toArray(String[]::new);
    }
}

