/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaHook;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.catalog.AbstractCatalog;
import org.apache.paimon.catalog.CatalogContext;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.hive.HiveTypeUtils;
import org.apache.paimon.hive.LocationKeyExtractor;
import org.apache.paimon.hive.mapred.PaimonInputFormat;
import org.apache.paimon.hive.mapred.PaimonOutputFormat;
import org.apache.paimon.hive.utils.HiveUtils;
import org.apache.paimon.options.Options;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.schema.TableSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaimonMetaHook
implements HiveMetaHook {
    private static final Logger LOG = LoggerFactory.getLogger(PaimonMetaHook.class);
    private static final String COMMENT = "comment";
    private final Configuration conf;
    private final Set<Identifier> existingPaimonTable = new HashSet<Identifier>();

    public PaimonMetaHook(Configuration conf) {
        this.conf = conf;
    }

    public void preCreateTable(Table table) throws MetaException {
        FileIO fileIO;
        table.getSd().setInputFormat(PaimonInputFormat.class.getCanonicalName());
        table.getSd().setOutputFormat(PaimonOutputFormat.class.getCanonicalName());
        table.setDbName(table.getDbName().toLowerCase());
        table.setTableName(table.getTableName().toLowerCase());
        String location = LocationKeyExtractor.getPaimonLocation(this.conf, table);
        Identifier identifier = Identifier.create(table.getDbName(), table.getTableName());
        if (location == null) {
            String warehouse = this.conf.get(HiveConf.ConfVars.METASTOREWAREHOUSE.varname);
            org.apache.hadoop.fs.Path hadoopPath = Warehouse.getDnsPath((org.apache.hadoop.fs.Path)new org.apache.hadoop.fs.Path(warehouse), (Configuration)this.conf);
            warehouse = hadoopPath.toUri().toString();
            location = AbstractCatalog.newTableLocation(warehouse, identifier).toUri().toString();
            table.getSd().setLocation(location);
        }
        Path path = new Path(location);
        CatalogContext context = this.catalogContext(table, location);
        try {
            fileIO = FileIO.get(path, context);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        SchemaManager schemaManager = new SchemaManager(fileIO, path);
        Optional<TableSchema> tableSchema = schemaManager.latest();
        if (tableSchema.isPresent()) {
            this.existingPaimonTable.add(identifier);
            return;
        }
        List cols = table.getSd().getCols();
        Schema.Builder schemaBuilder = Schema.newBuilder().comment((String)table.getParameters().get(COMMENT));
        cols.iterator().forEachRemaining(fieldSchema -> schemaBuilder.column(fieldSchema.getName().toLowerCase(), HiveTypeUtils.toPaimonType(fieldSchema.getType()), fieldSchema.getComment()));
        if (table.getPartitionKeysSize() > 0) {
            context.options().set(CoreOptions.METASTORE_PARTITIONED_TABLE, true);
            table.getPartitionKeys().iterator().forEachRemaining(fieldSchema -> schemaBuilder.column(fieldSchema.getName().toLowerCase(), HiveTypeUtils.toPaimonType(fieldSchema.getType()), fieldSchema.getComment()));
            List<String> partitionKeys = table.getPartitionKeys().stream().map(FieldSchema::getName).map(String::toLowerCase).collect(Collectors.toList());
            schemaBuilder.partitionKeys(partitionKeys);
        }
        schemaBuilder.options(context.options().toMap());
        try {
            schemaManager.createTable(schemaBuilder.build());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void rollbackCreateTable(Table table) throws MetaException {
        Identifier identifier = Identifier.create(table.getDbName(), table.getTableName());
        if (this.existingPaimonTable.contains(identifier)) {
            return;
        }
        String location = LocationKeyExtractor.getPaimonLocation(this.conf, table);
        Path path = new Path(location);
        CatalogContext context = this.catalogContext(table, location);
        try {
            FileIO fileIO = FileIO.get(path, context);
            if (fileIO.exists(path)) {
                fileIO.deleteDirectoryQuietly(path);
            }
        }
        catch (IOException e) {
            LOG.error("Delete directory [{}] fail for the paimon table.", (Object)path, (Object)e);
        }
    }

    public void commitCreateTable(Table table) throws MetaException {
    }

    public void preDropTable(Table table) throws MetaException {
    }

    public void rollbackDropTable(Table table) throws MetaException {
    }

    public void commitDropTable(Table table, boolean b) throws MetaException {
    }

    private CatalogContext catalogContext(Table table, String location) {
        Options options = HiveUtils.extractCatalogConfig(this.conf);
        options.set(CoreOptions.PATH, location);
        table.getParameters().forEach(options::set);
        return CatalogContext.create(options, this.conf);
    }
}

