/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.data;

import java.nio.ByteOrder;
import javax.annotation.Nullable;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.data.BinaryRowWriter;
import org.apache.paimon.data.BinarySection;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.DataSetters;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalMap;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.NestedRow;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.memory.MemorySegment;
import org.apache.paimon.memory.MemorySegmentUtils;
import org.apache.paimon.types.RowKind;
import org.apache.paimon.utils.Preconditions;

@Public
public final class BinaryRow
extends BinarySection
implements InternalRow,
DataSetters {
    private static final long serialVersionUID = 1L;
    public static final boolean LITTLE_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;
    private static final long FIRST_BYTE_ZERO = LITTLE_ENDIAN ? -256L : 0xFFFFFFFFFFFFFFL;
    public static final int HEADER_SIZE_IN_BITS = 8;
    public static final BinaryRow EMPTY_ROW = new BinaryRow(0);
    private final int arity;
    private final int nullBitsSizeInBytes;

    public static int calculateBitSetWidthInBytes(int arity) {
        return (arity + 63 + 8) / 64 * 8;
    }

    public static int calculateFixPartSizeInBytes(int arity) {
        return BinaryRow.calculateBitSetWidthInBytes(arity) + 8 * arity;
    }

    public BinaryRow(int arity) {
        Preconditions.checkArgument(arity >= 0);
        this.arity = arity;
        this.nullBitsSizeInBytes = BinaryRow.calculateBitSetWidthInBytes(arity);
    }

    private int getFieldOffset(int pos) {
        return this.offset + this.nullBitsSizeInBytes + pos * 8;
    }

    private void assertIndexIsValid(int index) {
        assert (index >= 0) : "index (" + index + ") should >= 0";
        assert (index < this.arity) : "index (" + index + ") should < " + this.arity;
    }

    public int getFixedLengthPartSize() {
        return this.nullBitsSizeInBytes + 8 * this.arity;
    }

    @Override
    public int getFieldCount() {
        return this.arity;
    }

    @Override
    public RowKind getRowKind() {
        byte kindValue = this.segments[0].get(this.offset);
        return RowKind.fromByteValue(kindValue);
    }

    @Override
    public void setRowKind(RowKind kind) {
        this.segments[0].put(this.offset, kind.toByteValue());
    }

    public void setTotalSize(int sizeInBytes) {
        this.sizeInBytes = sizeInBytes;
    }

    @Override
    public boolean isNullAt(int pos) {
        this.assertIndexIsValid(pos);
        return MemorySegmentUtils.bitGet(this.segments[0], this.offset, pos + 8);
    }

    private void setNotNullAt(int i) {
        this.assertIndexIsValid(i);
        MemorySegmentUtils.bitUnSet(this.segments[0], this.offset, i + 8);
    }

    @Override
    public void setNullAt(int i) {
        this.assertIndexIsValid(i);
        MemorySegmentUtils.bitSet(this.segments[0], this.offset, i + 8);
        this.segments[0].putLong(this.getFieldOffset(i), 0L);
    }

    @Override
    public void setInt(int pos, int value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        this.segments[0].putInt(this.getFieldOffset(pos), value);
    }

    @Override
    public void setLong(int pos, long value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        this.segments[0].putLong(this.getFieldOffset(pos), value);
    }

    @Override
    public void setDouble(int pos, double value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        this.segments[0].putDouble(this.getFieldOffset(pos), value);
    }

    @Override
    public void setDecimal(int pos, Decimal value, int precision) {
        this.assertIndexIsValid(pos);
        if (Decimal.isCompact(precision)) {
            this.setLong(pos, value.toUnscaledLong());
        } else {
            int fieldOffset = this.getFieldOffset(pos);
            int cursor = (int)(this.segments[0].getLong(fieldOffset) >>> 32);
            assert (cursor > 0) : "invalid cursor " + cursor;
            MemorySegmentUtils.setLong(this.segments, this.offset + cursor, 0L);
            MemorySegmentUtils.setLong(this.segments, this.offset + cursor + 8, 0L);
            if (value == null) {
                this.setNullAt(pos);
                this.segments[0].putLong(fieldOffset, (long)cursor << 32);
            } else {
                byte[] bytes = value.toUnscaledBytes();
                assert (bytes.length <= 16);
                MemorySegmentUtils.copyFromBytes(this.segments, this.offset + cursor, bytes, 0, bytes.length);
                this.setLong(pos, (long)cursor << 32 | (long)bytes.length);
            }
        }
    }

    @Override
    public void setTimestamp(int pos, Timestamp value, int precision) {
        this.assertIndexIsValid(pos);
        if (Timestamp.isCompact(precision)) {
            this.setLong(pos, value.getMillisecond());
        } else {
            int fieldOffset = this.getFieldOffset(pos);
            int cursor = (int)(this.segments[0].getLong(fieldOffset) >>> 32);
            assert (cursor > 0) : "invalid cursor " + cursor;
            if (value == null) {
                this.setNullAt(pos);
                MemorySegmentUtils.setLong(this.segments, this.offset + cursor, 0L);
                this.segments[0].putLong(fieldOffset, (long)cursor << 32);
            } else {
                MemorySegmentUtils.setLong(this.segments, this.offset + cursor, value.getMillisecond());
                this.setLong(pos, (long)cursor << 32 | (long)value.getNanoOfMillisecond());
            }
        }
    }

    @Override
    public void setBoolean(int pos, boolean value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        this.segments[0].putBoolean(this.getFieldOffset(pos), value);
    }

    @Override
    public void setShort(int pos, short value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        this.segments[0].putShort(this.getFieldOffset(pos), value);
    }

    @Override
    public void setByte(int pos, byte value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        this.segments[0].put(this.getFieldOffset(pos), value);
    }

    @Override
    public void setFloat(int pos, float value) {
        this.assertIndexIsValid(pos);
        this.setNotNullAt(pos);
        this.segments[0].putFloat(this.getFieldOffset(pos), value);
    }

    @Override
    public boolean getBoolean(int pos) {
        this.assertIndexIsValid(pos);
        return this.segments[0].getBoolean(this.getFieldOffset(pos));
    }

    @Override
    public byte getByte(int pos) {
        this.assertIndexIsValid(pos);
        return this.segments[0].get(this.getFieldOffset(pos));
    }

    @Override
    public short getShort(int pos) {
        this.assertIndexIsValid(pos);
        return this.segments[0].getShort(this.getFieldOffset(pos));
    }

    @Override
    public int getInt(int pos) {
        this.assertIndexIsValid(pos);
        return this.segments[0].getInt(this.getFieldOffset(pos));
    }

    @Override
    public long getLong(int pos) {
        this.assertIndexIsValid(pos);
        return this.segments[0].getLong(this.getFieldOffset(pos));
    }

    @Override
    public float getFloat(int pos) {
        this.assertIndexIsValid(pos);
        return this.segments[0].getFloat(this.getFieldOffset(pos));
    }

    @Override
    public double getDouble(int pos) {
        this.assertIndexIsValid(pos);
        return this.segments[0].getDouble(this.getFieldOffset(pos));
    }

    @Override
    public BinaryString getString(int pos) {
        this.assertIndexIsValid(pos);
        int fieldOffset = this.getFieldOffset(pos);
        long offsetAndLen = this.segments[0].getLong(fieldOffset);
        return MemorySegmentUtils.readBinaryString(this.segments, this.offset, fieldOffset, offsetAndLen);
    }

    @Override
    public Decimal getDecimal(int pos, int precision, int scale) {
        this.assertIndexIsValid(pos);
        if (Decimal.isCompact(precision)) {
            return Decimal.fromUnscaledLong(this.segments[0].getLong(this.getFieldOffset(pos)), precision, scale);
        }
        int fieldOffset = this.getFieldOffset(pos);
        long offsetAndSize = this.segments[0].getLong(fieldOffset);
        return MemorySegmentUtils.readDecimal(this.segments, this.offset, offsetAndSize, precision, scale);
    }

    @Override
    public Timestamp getTimestamp(int pos, int precision) {
        this.assertIndexIsValid(pos);
        if (Timestamp.isCompact(precision)) {
            return Timestamp.fromEpochMillis(this.segments[0].getLong(this.getFieldOffset(pos)));
        }
        int fieldOffset = this.getFieldOffset(pos);
        long offsetAndNanoOfMilli = this.segments[0].getLong(fieldOffset);
        return MemorySegmentUtils.readTimestampData(this.segments, this.offset, offsetAndNanoOfMilli);
    }

    @Override
    public byte[] getBinary(int pos) {
        this.assertIndexIsValid(pos);
        int fieldOffset = this.getFieldOffset(pos);
        long offsetAndLen = this.segments[0].getLong(fieldOffset);
        return MemorySegmentUtils.readBinary(this.segments, this.offset, fieldOffset, offsetAndLen);
    }

    @Override
    public InternalArray getArray(int pos) {
        this.assertIndexIsValid(pos);
        return MemorySegmentUtils.readArrayData(this.segments, this.offset, this.getLong(pos));
    }

    @Override
    public InternalMap getMap(int pos) {
        this.assertIndexIsValid(pos);
        return MemorySegmentUtils.readMapData(this.segments, this.offset, this.getLong(pos));
    }

    @Override
    public InternalRow getRow(int pos, int numFields) {
        this.assertIndexIsValid(pos);
        return MemorySegmentUtils.readRowData(this.segments, numFields, this.offset, this.getLong(pos));
    }

    public boolean anyNull() {
        if ((this.segments[0].getLong(0) & FIRST_BYTE_ZERO) != 0L) {
            return true;
        }
        for (int i = 8; i < this.nullBitsSizeInBytes; i += 8) {
            if (this.segments[0].getLong(i) == 0L) continue;
            return true;
        }
        return false;
    }

    public boolean anyNull(int[] fields) {
        for (int field : fields) {
            if (!this.isNullAt(field)) continue;
            return true;
        }
        return false;
    }

    public BinaryRow copy() {
        return this.copy(new BinaryRow(this.arity));
    }

    public BinaryRow copy(BinaryRow reuse) {
        return this.copyInternal(reuse);
    }

    private BinaryRow copyInternal(BinaryRow reuse) {
        byte[] bytes = MemorySegmentUtils.copyToBytes(this.segments, this.offset, this.sizeInBytes);
        reuse.pointTo(MemorySegment.wrap(bytes), 0, this.sizeInBytes);
        return reuse;
    }

    public void clear() {
        this.segments = null;
        this.offset = 0;
        this.sizeInBytes = 0;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BinaryRow) && !(o instanceof NestedRow)) {
            return false;
        }
        BinarySection that = (BinarySection)o;
        return this.sizeInBytes == that.sizeInBytes && MemorySegmentUtils.equals(this.segments, this.offset, that.segments, that.offset, this.sizeInBytes);
    }

    @Override
    public int hashCode() {
        return MemorySegmentUtils.hashByWords(this.segments, this.offset, this.sizeInBytes);
    }

    public static BinaryRow singleColumn(@Nullable Integer i) {
        BinaryRow row = new BinaryRow(1);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        writer.reset();
        if (i == null) {
            writer.setNullAt(0);
        } else {
            writer.writeInt(0, i);
        }
        writer.complete();
        return row;
    }

    public static BinaryRow singleColumn(@Nullable String string) {
        BinaryString binaryString = string == null ? null : BinaryString.fromString(string);
        return BinaryRow.singleColumn(binaryString);
    }

    public static BinaryRow singleColumn(@Nullable BinaryString string) {
        BinaryRow row = new BinaryRow(1);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        writer.reset();
        if (string == null) {
            writer.setNullAt(0);
        } else {
            writer.writeString(0, string);
        }
        writer.complete();
        return row;
    }

    static {
        int size = EMPTY_ROW.getFixedLengthPartSize();
        byte[] bytes = new byte[size];
        EMPTY_ROW.pointTo(MemorySegment.wrap(bytes), 0, size);
    }
}

