/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive.procedure;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.table.api.SqlDialect;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.paimon.flink.action.ActionITCaseBase;
import org.apache.paimon.flink.action.MigrateDatabaseAction;
import org.apache.paimon.hive.TestHiveMetastore;
import org.apache.paimon.hive.procedure.MigrateTableProcedureITCase;
import org.apache.paimon.shade.guava30.com.google.common.collect.ImmutableList;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class MigrateDatabaseProcedureITCase
extends ActionITCaseBase {
    private static final TestHiveMetastore TEST_HIVE_METASTORE = new TestHiveMetastore();
    private static final int PORT = 9086;

    @BeforeEach
    public void beforeEach() {
        TEST_HIVE_METASTORE.start(9086);
    }

    @AfterEach
    public void afterEach() throws Exception {
        TEST_HIVE_METASTORE.stop();
    }

    @Test
    public void testOrc() throws Exception {
        this.testUpgradeNonPartitionTable("orc");
        this.resetMetastore();
        this.testUpgradePartitionTable("orc");
    }

    @Test
    public void testAvro() throws Exception {
        this.testUpgradeNonPartitionTable("avro");
        this.resetMetastore();
        this.testUpgradePartitionTable("avro");
    }

    @Test
    public void testParquet() throws Exception {
        this.testUpgradeNonPartitionTable("parquet");
        this.resetMetastore();
        this.testUpgradePartitionTable("parquet");
    }

    private void resetMetastore() throws Exception {
        TEST_HIVE_METASTORE.stop();
        TEST_HIVE_METASTORE.reset();
        TEST_HIVE_METASTORE.start(9086);
    }

    public void testUpgradePartitionTable(String format) throws Exception {
        TableEnvironment tEnv = this.tableEnvironmentBuilder().batchMode().build();
        tEnv.executeSql("CREATE CATALOG HIVE WITH ('type'='hive')");
        tEnv.useCatalog("HIVE");
        tEnv.getConfig().setSqlDialect(SqlDialect.HIVE);
        tEnv.executeSql("CREATE DATABASE my_database");
        tEnv.executeSql("USE my_database");
        tEnv.executeSql("CREATE TABLE hivetable1 (id string) PARTITIONED BY (id2 int, id3 int) STORED AS " + format);
        tEnv.executeSql("INSERT INTO hivetable1 VALUES" + MigrateTableProcedureITCase.data(100)).await();
        tEnv.executeSql("SHOW CREATE TABLE hivetable1");
        tEnv.executeSql("CREATE TABLE hivetable2 (id string) PARTITIONED BY (id2 int, id3 int) STORED AS " + format);
        tEnv.executeSql("INSERT INTO hivetable2 VALUES" + MigrateTableProcedureITCase.data(100)).await();
        tEnv.executeSql("SHOW CREATE TABLE hivetable2");
        tEnv.getConfig().setSqlDialect(SqlDialect.DEFAULT);
        tEnv.executeSql("CREATE CATALOG PAIMON_GE WITH ('type'='paimon-generic')");
        tEnv.useCatalog("PAIMON_GE");
        ImmutableList r1 = ImmutableList.copyOf((Iterator)tEnv.executeSql("SELECT * FROM my_database.hivetable1").collect());
        ImmutableList r3 = ImmutableList.copyOf((Iterator)tEnv.executeSql("SELECT * FROM my_database.hivetable2").collect());
        tEnv.executeSql("CREATE CATALOG PAIMON WITH ('type'='paimon', 'metastore' = 'hive', 'uri' = 'thrift://localhost:9086' , 'warehouse' = '" + System.getProperty(HiveConf.ConfVars.METASTOREWAREHOUSE.varname) + "')");
        tEnv.useCatalog("PAIMON");
        tEnv.executeSql("CALL sys.migrate_database('hive', 'my_database', 'file.format=" + format + "')").await();
        ImmutableList r2 = ImmutableList.copyOf((Iterator)tEnv.executeSql("SELECT * FROM my_database.hivetable1").collect());
        ImmutableList r4 = ImmutableList.copyOf((Iterator)tEnv.executeSql("SELECT * FROM my_database.hivetable2").collect());
        Assertions.assertThatList((List)r1).containsExactlyInAnyOrderElementsOf((Iterable)r2);
        Assertions.assertThatList((List)r3).containsExactlyInAnyOrderElementsOf((Iterable)r4);
    }

    public void testUpgradeNonPartitionTable(String format) throws Exception {
        TableEnvironment tEnv = this.tableEnvironmentBuilder().batchMode().build();
        tEnv.executeSql("CREATE CATALOG HIVE WITH ('type'='hive')");
        tEnv.useCatalog("HIVE");
        tEnv.getConfig().setSqlDialect(SqlDialect.HIVE);
        tEnv.executeSql("CREATE DATABASE my_database");
        tEnv.executeSql("USE my_database");
        tEnv.executeSql("CREATE TABLE hivetable1 (id string, id2 int, id3 int) STORED AS " + format);
        tEnv.executeSql("INSERT INTO hivetable1 VALUES" + MigrateTableProcedureITCase.data(100)).await();
        tEnv.executeSql("SHOW CREATE TABLE hivetable1");
        tEnv.executeSql("CREATE TABLE hivetable2 (id string, id2 int, id3 int) STORED AS " + format);
        tEnv.executeSql("INSERT INTO hivetable2 VALUES" + MigrateTableProcedureITCase.data(100)).await();
        tEnv.executeSql("SHOW CREATE TABLE hivetable2");
        tEnv.getConfig().setSqlDialect(SqlDialect.DEFAULT);
        tEnv.executeSql("CREATE CATALOG PAIMON_GE WITH ('type'='paimon-generic')");
        tEnv.useCatalog("PAIMON_GE");
        ImmutableList r1 = ImmutableList.copyOf((Iterator)tEnv.executeSql("SELECT * FROM my_database.hivetable1").collect());
        ImmutableList r3 = ImmutableList.copyOf((Iterator)tEnv.executeSql("SELECT * FROM my_database.hivetable2").collect());
        tEnv.executeSql("CREATE CATALOG PAIMON WITH ('type'='paimon', 'metastore' = 'hive', 'uri' = 'thrift://localhost:9086' , 'warehouse' = '" + System.getProperty(HiveConf.ConfVars.METASTOREWAREHOUSE.varname) + "')");
        tEnv.useCatalog("PAIMON");
        tEnv.executeSql("CALL sys.migrate_database('hive', 'my_database', 'file.format=" + format + "')").await();
        ImmutableList r2 = ImmutableList.copyOf((Iterator)tEnv.executeSql("SELECT * FROM my_database.hivetable1").collect());
        ImmutableList r4 = ImmutableList.copyOf((Iterator)tEnv.executeSql("SELECT * FROM my_database.hivetable2").collect());
        Assertions.assertThatList((List)r1).containsExactlyInAnyOrderElementsOf((Iterable)r2);
        Assertions.assertThatList((List)r3).containsExactlyInAnyOrderElementsOf((Iterable)r4);
    }

    @ParameterizedTest
    @ValueSource(strings={"orc", "parquet", "avro"})
    public void testMigrateDatabaseAction(String format) throws Exception {
        TableEnvironment tEnv = this.tableEnvironmentBuilder().batchMode().build();
        tEnv.executeSql("CREATE CATALOG HIVE WITH ('type'='hive')");
        tEnv.useCatalog("HIVE");
        tEnv.getConfig().setSqlDialect(SqlDialect.HIVE);
        tEnv.executeSql("CREATE DATABASE my_database");
        tEnv.executeSql("USE my_database");
        tEnv.executeSql("CREATE TABLE hivetable1 (id string) PARTITIONED BY (id2 int, id3 int) STORED AS " + format);
        tEnv.executeSql("INSERT INTO hivetable1 VALUES" + MigrateTableProcedureITCase.data(100)).await();
        tEnv.executeSql("SHOW CREATE TABLE hivetable1");
        tEnv.executeSql("CREATE TABLE hivetable2 (id string) PARTITIONED BY (id2 int, id3 int) STORED AS " + format);
        tEnv.executeSql("INSERT INTO hivetable2 VALUES" + MigrateTableProcedureITCase.data(100)).await();
        tEnv.executeSql("SHOW CREATE TABLE hivetable2");
        tEnv.getConfig().setSqlDialect(SqlDialect.DEFAULT);
        tEnv.executeSql("CREATE CATALOG PAIMON_GE WITH ('type'='paimon-generic')");
        tEnv.useCatalog("PAIMON_GE");
        ImmutableList r1 = ImmutableList.copyOf((Iterator)tEnv.executeSql("SELECT * FROM my_database.hivetable1").collect());
        ImmutableList r3 = ImmutableList.copyOf((Iterator)tEnv.executeSql("SELECT * FROM my_database.hivetable2").collect());
        HashMap<String, String> catalogConf = new HashMap<String, String>();
        catalogConf.put("metastore", "hive");
        catalogConf.put("uri", "thrift://localhost:9086");
        MigrateDatabaseAction migrateDatabaseAction = new MigrateDatabaseAction("hive", System.getProperty(HiveConf.ConfVars.METASTOREWAREHOUSE.varname), "my_database", catalogConf, "");
        migrateDatabaseAction.run();
        tEnv.executeSql("CREATE CATALOG PAIMON WITH ('type'='paimon', 'metastore' = 'hive', 'uri' = 'thrift://localhost:9086' , 'warehouse' = '" + System.getProperty(HiveConf.ConfVars.METASTOREWAREHOUSE.varname) + "')");
        tEnv.useCatalog("PAIMON");
        ImmutableList r2 = ImmutableList.copyOf((Iterator)tEnv.executeSql("SELECT * FROM my_database.hivetable1").collect());
        ImmutableList r4 = ImmutableList.copyOf((Iterator)tEnv.executeSql("SELECT * FROM my_database.hivetable2").collect());
        Assertions.assertThatList((List)r1).containsExactlyInAnyOrderElementsOf((Iterable)r2);
        Assertions.assertThatList((List)r3).containsExactlyInAnyOrderElementsOf((Iterable)r4);
    }
}

