/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive.objectinspector;

import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.io.Text;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.hive.objectinspector.PaimonStringObjectInspector;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class PaimonStringObjectInspectorTest {
    @Test
    public void testCategoryAndClass() {
        PaimonStringObjectInspector oi = new PaimonStringObjectInspector();
        Assertions.assertThat((Comparable)oi.getCategory()).isEqualTo((Object)ObjectInspector.Category.PRIMITIVE);
        Assertions.assertThat((Comparable)oi.getPrimitiveCategory()).isEqualTo((Object)PrimitiveObjectInspector.PrimitiveCategory.STRING);
        Assertions.assertThat((Class)oi.getJavaPrimitiveClass()).isEqualTo(String.class);
        Assertions.assertThat((Class)oi.getPrimitiveWritableClass()).isEqualTo(Text.class);
    }

    @Test
    public void testGetPrimitiveJavaObject() {
        PaimonStringObjectInspector oi = new PaimonStringObjectInspector();
        BinaryString input = BinaryString.fromString((String)"testString");
        String expected = "testString";
        Assertions.assertThat((String)oi.getPrimitiveJavaObject((Object)input)).isEqualTo(expected);
        Assertions.assertThat((String)oi.getPrimitiveJavaObject(null)).isNull();
    }

    @Test
    public void testGetPrimitiveWritableObject() {
        PaimonStringObjectInspector oi = new PaimonStringObjectInspector();
        BinaryString input = BinaryString.fromString((String)"testString");
        Text expected = new Text("testString");
        Assertions.assertThat((Comparable)oi.getPrimitiveWritableObject((Object)input)).isEqualTo((Object)expected);
        Assertions.assertThat((Comparable)oi.getPrimitiveWritableObject(null)).isNull();
    }

    @Test
    public void testCopyObject() {
        PaimonStringObjectInspector oi = new PaimonStringObjectInspector();
        BinaryString input = BinaryString.fromString((String)"testString");
        Object copy = oi.copyObject((Object)input);
        Assertions.assertThat((Object)copy).isEqualTo((Object)input);
        Assertions.assertThat((Object)copy).isNotSameAs((Object)input);
        Assertions.assertThat((Object)oi.copyObject((Object)"testString")).isEqualTo((Object)"testString");
        Assertions.assertThat((Object)oi.copyObject(null)).isNull();
    }
}

