/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive.mapred;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.hive.FileStoreTestUtils;
import org.apache.paimon.hive.RowDataContainer;
import org.apache.paimon.hive.mapred.PaimonInputSplit;
import org.apache.paimon.hive.mapred.PaimonRecordReader;
import org.apache.paimon.options.CatalogOptions;
import org.apache.paimon.options.Options;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.sink.StreamTableCommit;
import org.apache.paimon.table.sink.StreamTableWrite;
import org.apache.paimon.table.sink.StreamWriteBuilder;
import org.apache.paimon.table.source.DataSplit;
import org.apache.paimon.table.source.Split;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.RowKind;
import org.apache.paimon.types.RowType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class PaimonRecordReaderTest {
    @TempDir
    Path tempDir;

    @Test
    public void testPk() throws Exception {
        Options conf = new Options();
        conf.set(CatalogOptions.WAREHOUSE, (Object)this.tempDir.toString());
        conf.set(CoreOptions.FILE_FORMAT, (Object)CoreOptions.FileFormatType.AVRO);
        conf.set("bucket", "1");
        Table table = FileStoreTestUtils.createFileStoreTable(conf, RowType.of((DataType[])new DataType[]{DataTypes.BIGINT(), DataTypes.STRING()}, (String[])new String[]{"a", "b"}), Collections.emptyList(), Collections.singletonList("a"));
        StreamWriteBuilder streamWriteBuilder = table.newStreamWriteBuilder();
        StreamTableWrite write = streamWriteBuilder.newWrite();
        StreamTableCommit commit = streamWriteBuilder.newCommit();
        write.write((InternalRow)GenericRow.of((Object[])new Object[]{1L, BinaryString.fromString((String)"Hi")}));
        write.write((InternalRow)GenericRow.of((Object[])new Object[]{2L, BinaryString.fromString((String)"Hello")}));
        write.write((InternalRow)GenericRow.of((Object[])new Object[]{3L, BinaryString.fromString((String)"World")}));
        write.write((InternalRow)GenericRow.of((Object[])new Object[]{1L, BinaryString.fromString((String)"Hi again")}));
        write.write((InternalRow)GenericRow.ofKind((RowKind)RowKind.DELETE, (Object[])new Object[]{2L, BinaryString.fromString((String)"Hello")}));
        commit.commit(0L, write.prepareCommit(true, 0L));
        write.close();
        commit.close();
        PaimonRecordReader reader = this.read(table, BinaryRow.EMPTY_ROW, 0);
        RowDataContainer container = reader.createValue();
        HashSet<String> actual = new HashSet<String>();
        while (reader.next(null, container)) {
            InternalRow rowData = container.get();
            String value = rowData.getLong(0) + "|" + rowData.getString(1).toString();
            actual.add(value);
        }
        HashSet<String> expected = new HashSet<String>();
        expected.add("1|Hi again");
        expected.add("3|World");
        Assertions.assertThat(actual).isEqualTo(expected);
    }

    @Test
    public void testProjectionPushdown() throws Exception {
        Options conf = new Options();
        conf.set(CatalogOptions.WAREHOUSE, (Object)this.tempDir.toString());
        conf.set(CoreOptions.FILE_FORMAT, (Object)CoreOptions.FileFormatType.AVRO);
        Table table = FileStoreTestUtils.createFileStoreTable(conf, RowType.of((DataType[])new DataType[]{DataTypes.INT(), DataTypes.BIGINT(), DataTypes.STRING()}, (String[])new String[]{"a", "b", "c"}), Collections.emptyList(), Collections.emptyList());
        StreamWriteBuilder streamWriteBuilder = table.newStreamWriteBuilder();
        StreamTableWrite write = streamWriteBuilder.newWrite();
        StreamTableCommit commit = streamWriteBuilder.newCommit();
        write.write((InternalRow)GenericRow.of((Object[])new Object[]{1, 10L, BinaryString.fromString((String)"Hi")}));
        write.write((InternalRow)GenericRow.of((Object[])new Object[]{2, 20L, BinaryString.fromString((String)"Hello")}));
        write.write((InternalRow)GenericRow.of((Object[])new Object[]{1, 10L, BinaryString.fromString((String)"Hi")}));
        commit.commit(0L, write.prepareCommit(true, 0L));
        write.close();
        commit.close();
        PaimonRecordReader reader = this.read(table, BinaryRow.EMPTY_ROW, 0, Arrays.asList("c", "a"));
        RowDataContainer container = reader.createValue();
        HashMap<String, Integer> actual = new HashMap<String, Integer>();
        while (reader.next(null, container)) {
            InternalRow rowData = container.get();
            String key = rowData.getInt(0) + "|" + rowData.getString(2).toString();
            actual.compute(key, (k, v) -> (v == null ? 0 : v) + 1);
        }
        HashMap<String, Integer> expected = new HashMap<String, Integer>();
        expected.put("1|Hi", 2);
        expected.put("2|Hello", 1);
        Assertions.assertThat(actual).isEqualTo(expected);
    }

    private PaimonRecordReader read(Table table, BinaryRow partition, int bucket) throws Exception {
        return this.read(table, partition, bucket, ((FileStoreTable)table).schema().fieldNames());
    }

    private PaimonRecordReader read(Table table, BinaryRow partition, int bucket, List<String> selectedColumns) throws Exception {
        for (Split split : table.newReadBuilder().newScan().plan().splits()) {
            DataSplit dataSplit = (DataSplit)split;
            if (!dataSplit.partition().equals((Object)partition) || dataSplit.bucket() != bucket) continue;
            List originalColumns = ((FileStoreTable)table).schema().fieldNames();
            return new PaimonRecordReader(table.newReadBuilder(), new PaimonInputSplit(this.tempDir.toString(), dataSplit, (FileStoreTable)table), originalColumns, originalColumns, selectedColumns, null);
        }
        throw new IllegalArgumentException("Input split not found for partition " + partition + " and bucket " + bucket);
    }
}

