/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.io.Writable;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.fs.local.LocalFileIO;
import org.apache.paimon.hive.PaimonSerDe;
import org.apache.paimon.hive.RandomGenericRowDataGenerator;
import org.apache.paimon.hive.RowDataContainer;
import org.apache.paimon.hive.objectinspector.PaimonInternalRowObjectInspector;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.schema.SchemaManager;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class PaimonSerDeTest {
    @TempDir
    java.nio.file.Path tempDir;

    @Test
    public void testInitialize() throws Exception {
        PaimonSerDe serDe = this.createInitializedSerDe();
        ObjectInspector o = serDe.getObjectInspector();
        Assertions.assertThat((Object)o).isInstanceOf(PaimonInternalRowObjectInspector.class);
        PaimonInternalRowObjectInspector oi = (PaimonInternalRowObjectInspector)o;
        GenericRow rowData = RandomGenericRowDataGenerator.generate();
        List structFields = oi.getAllStructFieldRefs();
        for (int i = 0; i < structFields.size(); ++i) {
            Assertions.assertThat((Object)oi.getStructFieldData((Object)rowData, (StructField)structFields.get(i))).isEqualTo(rowData.getField(i));
            Assertions.assertThat((String)((StructField)structFields.get(i)).getFieldName()).isEqualTo(RandomGenericRowDataGenerator.FIELD_NAMES.get(i));
            Assertions.assertThat((String)((StructField)structFields.get(i)).getFieldComment()).isEqualTo(RandomGenericRowDataGenerator.FIELD_COMMENTS.get(i));
        }
    }

    @Test
    public void testDeserialize() throws Exception {
        PaimonSerDe serDe = this.createInitializedSerDe();
        GenericRow rowData = RandomGenericRowDataGenerator.generate();
        RowDataContainer container = new RowDataContainer();
        container.set((InternalRow)rowData);
        Assertions.assertThat((Object)serDe.deserialize((Writable)container)).isEqualTo((Object)rowData);
    }

    private PaimonSerDe createInitializedSerDe() throws Exception {
        new SchemaManager((FileIO)LocalFileIO.create(), new Path(this.tempDir.toString())).createTable(new Schema(RandomGenericRowDataGenerator.ROW_TYPE.getFields(), Collections.emptyList(), Collections.emptyList(), new HashMap(), ""));
        Properties properties = new Properties();
        properties.setProperty("location", this.tempDir.toString());
        PaimonSerDe serDe = new PaimonSerDe();
        serDe.initialize(null, properties);
        return serDe;
    }
}

