/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree.compact.aggregate;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.paimon.data.GenericMap;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalMap;
import org.apache.paimon.mergetree.compact.aggregate.FieldAggregator;
import org.apache.paimon.types.MapType;

public class FieldMergeMapAgg
extends FieldAggregator {
    public static final String NAME = "merge_map";
    private final InternalArray.ElementGetter keyGetter;
    private final InternalArray.ElementGetter valueGetter;

    public FieldMergeMapAgg(MapType dataType) {
        super(dataType);
        this.keyGetter = InternalArray.createElementGetter(dataType.getKeyType());
        this.valueGetter = InternalArray.createElementGetter(dataType.getValueType());
    }

    @Override
    String name() {
        return NAME;
    }

    @Override
    public Object agg(Object accumulator, Object inputField) {
        if (accumulator == null || inputField == null) {
            return accumulator == null ? inputField : accumulator;
        }
        HashMap<Object, Object> resultMap = new HashMap<Object, Object>();
        this.putToMap(resultMap, accumulator);
        this.putToMap(resultMap, inputField);
        return new GenericMap(resultMap);
    }

    private void putToMap(Map<Object, Object> map, Object data) {
        InternalMap mapData = (InternalMap)data;
        InternalArray keyArray = mapData.keyArray();
        InternalArray valueArray = mapData.valueArray();
        for (int i = 0; i < keyArray.size(); ++i) {
            map.put(this.keyGetter.getElementOrNull(keyArray, i), this.valueGetter.getElementOrNull(valueArray, i));
        }
    }

    @Override
    public Object retract(Object accumulator, Object retractField) {
        if (accumulator == null) {
            return null;
        }
        InternalMap acc2 = (InternalMap)accumulator;
        InternalMap retract = (InternalMap)retractField;
        InternalArray retractKeyArray = retract.keyArray();
        HashSet<Object> retractKeys = new HashSet<Object>();
        for (int i = 0; i < retractKeyArray.size(); ++i) {
            retractKeys.add(this.keyGetter.getElementOrNull(retractKeyArray, i));
        }
        HashMap<Object, Object> resultMap = new HashMap<Object, Object>();
        InternalArray accKeyArray = acc2.keyArray();
        InternalArray accValueArray = acc2.valueArray();
        for (int i = 0; i < accKeyArray.size(); ++i) {
            Object accKey = this.keyGetter.getElementOrNull(accKeyArray, i);
            if (retractKeys.contains(accKey)) continue;
            resultMap.put(accKey, this.valueGetter.getElementOrNull(accValueArray, i));
        }
        return new GenericMap(resultMap);
    }
}

