/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io.cache;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.paimon.data.AbstractPagedInputView;
import org.apache.paimon.io.PageFileInput;
import org.apache.paimon.io.SeekableDataInputView;
import org.apache.paimon.io.cache.CacheKey;
import org.apache.paimon.io.cache.CacheManager;
import org.apache.paimon.memory.MemorySegment;
import org.apache.paimon.utils.MathUtils;

public class FileBasedRandomInputView
extends AbstractPagedInputView
implements SeekableDataInputView,
Closeable {
    private final PageFileInput input;
    private final CacheManager cacheManager;
    private final Map<Integer, SegmentContainer> segments;
    private final int segmentSizeBits;
    private final int segmentSizeMask;
    private int currentSegmentIndex;

    public FileBasedRandomInputView(PageFileInput input, CacheManager cacheManager) {
        this.input = input;
        this.cacheManager = cacheManager;
        this.segments = new HashMap<Integer, SegmentContainer>();
        int segmentSize = input.pageSize();
        this.segmentSizeBits = MathUtils.log2strict(segmentSize);
        this.segmentSizeMask = segmentSize - 1;
        this.currentSegmentIndex = -1;
    }

    @Override
    public void setReadPosition(long position) {
        int offset = (int)(position & (long)this.segmentSizeMask);
        this.currentSegmentIndex = (int)(position >>> this.segmentSizeBits);
        MemorySegment segment = this.getCurrentPage();
        this.seekInput(segment, offset, this.getLimitForSegment(segment));
    }

    private MemorySegment getCurrentPage() {
        SegmentContainer container = this.segments.get(this.currentSegmentIndex);
        if (container == null || container.accessCount == 10) {
            int pageIndex = this.currentSegmentIndex;
            MemorySegment segment = this.cacheManager.getPage(CacheKey.forPageIndex(this.input.file(), this.input.pageSize(), pageIndex), key -> this.input.readPage(pageIndex), this::invalidPage);
            container = new SegmentContainer(segment);
            this.segments.put(this.currentSegmentIndex, container);
        }
        return container.access();
    }

    @Override
    protected MemorySegment nextSegment(MemorySegment current) throws EOFException {
        ++this.currentSegmentIndex;
        if ((long)this.currentSegmentIndex << this.segmentSizeBits >= this.input.uncompressBytes()) {
            throw new EOFException();
        }
        return this.getCurrentPage();
    }

    @Override
    protected int getLimitForSegment(MemorySegment segment) {
        return segment.size();
    }

    private void invalidPage(CacheKey key) {
        this.segments.remove(((CacheKey.PageIndexCacheKey)key).pageIndex());
    }

    @Override
    public void close() throws IOException {
        ArrayList<Integer> pages = new ArrayList<Integer>(this.segments.keySet());
        pages.forEach(page -> this.cacheManager.invalidPage(CacheKey.forPageIndex(this.input.file(), this.input.pageSize(), page)));
        this.input.close();
    }

    private static class SegmentContainer {
        private final MemorySegment segment;
        private int accessCount;

        private SegmentContainer(MemorySegment segment) {
            this.segment = segment;
            this.accessCount = 0;
        }

        private MemorySegment access() {
            ++this.accessCount;
            return this.segment;
        }
    }
}

