/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.source;

import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;

public class RecordLimiter {
    private final long limit;
    private final AtomicLong counter;

    public RecordLimiter(long limit) {
        this.limit = limit;
        this.counter = new AtomicLong(0L);
    }

    public boolean reachLimit() {
        return this.counter.get() >= this.limit;
    }

    public void increment() {
        this.counter.incrementAndGet();
    }

    public void add(long delta) {
        this.counter.addAndGet(delta);
    }

    @Nullable
    public static RecordLimiter create(@Nullable Long limit) {
        return limit == null ? null : new RecordLimiter(limit);
    }
}

