/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.metrics;

import java.util.Collections;
import java.util.Map;
import org.apache.flink.metrics.Histogram;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.metrics.DescriptiveStatisticsHistogram;
import org.apache.flink.runtime.metrics.groups.AbstractMetricGroup;
import org.apache.paimon.flink.metrics.FlinkCounter;
import org.apache.paimon.flink.metrics.FlinkGauge;
import org.apache.paimon.flink.metrics.FlinkHistogram;
import org.apache.paimon.metrics.Counter;
import org.apache.paimon.metrics.Gauge;
import org.apache.paimon.metrics.Metric;

public class FlinkMetricGroup
implements org.apache.paimon.metrics.MetricGroup {
    private static final String PAIMON_GROUP_NAME = "paimon";
    private final MetricGroup wrapped;
    private final String groupName;
    private final Map<String, String> variables;

    public FlinkMetricGroup(MetricGroup wrapped, String groupName, Map<String, String> variables) {
        wrapped = wrapped.addGroup(PAIMON_GROUP_NAME);
        for (Map.Entry<String, String> entry : variables.entrySet()) {
            wrapped = wrapped.addGroup(entry.getKey(), entry.getValue());
        }
        this.wrapped = wrapped = wrapped.addGroup(groupName);
        this.groupName = groupName;
        this.variables = variables;
    }

    @Override
    public Counter counter(String name) {
        return new FlinkCounter(this.wrapped.counter(name));
    }

    @Override
    public <T> Gauge<T> gauge(String name, Gauge<T> gauge) {
        return new FlinkGauge(this.wrapped.gauge(name, gauge::getValue));
    }

    @Override
    public org.apache.paimon.metrics.Histogram histogram(String name, int windowSize) {
        return new FlinkHistogram(this.wrapped.histogram(name, (Histogram)new DescriptiveStatisticsHistogram(windowSize)));
    }

    @Override
    public Map<String, String> getAllVariables() {
        return Collections.unmodifiableMap(this.variables);
    }

    @Override
    public String getGroupName() {
        return this.groupName;
    }

    @Override
    public Map<String, Metric> getMetrics() {
        throw new UnsupportedOperationException("FlinkMetricGroup does not support fetching all metrics. Please read the metrics through Flink's metric system.");
    }

    @Override
    public void close() {
        if (this.wrapped instanceof AbstractMetricGroup) {
            ((AbstractMetricGroup)this.wrapped).close();
        }
    }
}

