/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.lookup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.IntUnaryOperator;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.flink.FlinkConnectorOptions;
import org.apache.paimon.io.SplitsParallelReadUtil;
import org.apache.paimon.mergetree.compact.ConcatRecordReader;
import org.apache.paimon.options.ConfigOption;
import org.apache.paimon.options.Options;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateBuilder;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.shade.guava30.com.google.common.primitives.Ints;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.source.ReadBuilder;
import org.apache.paimon.table.source.Split;
import org.apache.paimon.table.source.StreamTableScan;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.FunctionWithIOException;
import org.apache.paimon.utils.TypeUtils;

public class LookupStreamingReader {
    private final Table table;
    private final int[] projection;
    private final ReadBuilder readBuilder;
    @Nullable
    private final Predicate projectedPredicate;
    private final StreamTableScan scan;
    private static final List<ConfigOption<?>> TIME_TRAVEL_OPTIONS = Arrays.asList(CoreOptions.SCAN_TIMESTAMP_MILLIS, CoreOptions.SCAN_FILE_CREATION_TIME_MILLIS, CoreOptions.SCAN_SNAPSHOT_ID, CoreOptions.SCAN_TAG_NAME, CoreOptions.SCAN_VERSION);

    public LookupStreamingReader(Table table, int[] projection, @Nullable Predicate predicate) {
        this.table = this.unsetTimeTravelOptions(table);
        this.projection = projection;
        this.readBuilder = this.table.newReadBuilder().withProjection(projection).withFilter(predicate);
        this.scan = this.readBuilder.newStreamScan();
        if (predicate != null) {
            List<String> fieldNames = table.rowType().getFieldNames();
            List<String> primaryKeys = table.primaryKeys();
            IntUnaryOperator operator = i -> {
                int index = Ints.indexOf(projection, i);
                boolean safeFilter = primaryKeys.isEmpty() || primaryKeys.contains(fieldNames.get(i));
                return safeFilter ? index : -1;
            };
            int[] fieldIdxToProjectionIdx = IntStream.range(0, table.rowType().getFieldCount()).map(operator).toArray();
            this.projectedPredicate = PredicateBuilder.transformFieldMapping(predicate, fieldIdxToProjectionIdx).orElse(null);
        } else {
            this.projectedPredicate = null;
        }
    }

    private Table unsetTimeTravelOptions(Table origin) {
        FileStoreTable fileStoreTable = (FileStoreTable)origin;
        HashMap<String, String> newOptions = new HashMap<String, String>(fileStoreTable.options());
        TIME_TRAVEL_OPTIONS.stream().map(ConfigOption::key).forEach(newOptions::remove);
        CoreOptions.StartupMode startupMode = CoreOptions.fromMap(newOptions).startupMode();
        if (startupMode != CoreOptions.StartupMode.COMPACTED_FULL) {
            startupMode = CoreOptions.StartupMode.LATEST_FULL;
        }
        newOptions.put(CoreOptions.SCAN_MODE.key(), startupMode.toString());
        TableSchema newSchema = fileStoreTable.schema().copy(newOptions);
        return fileStoreTable.copy(newSchema);
    }

    public RecordReader<InternalRow> nextBatch(boolean useParallelism) throws Exception {
        RecordReader<InternalRow> reader;
        List<Split> splits = this.scan.plan().splits();
        CoreOptions options = CoreOptions.fromMap(this.table.options());
        FunctionWithIOException readerSupplier = split -> this.readBuilder.newRead().createReader((Split)split);
        RowType readType = TypeUtils.project(this.table.rowType(), this.projection);
        if (useParallelism) {
            reader = SplitsParallelReadUtil.parallelExecute(readType, readerSupplier, splits, options.pageSize(), new Options(this.table.options()).get(FlinkConnectorOptions.LOOKUP_BOOTSTRAP_PARALLELISM));
        } else {
            ArrayList readers = new ArrayList();
            for (Split split2 : splits) {
                readers.add(() -> (RecordReader)readerSupplier.apply(split2));
            }
            reader = ConcatRecordReader.create(readers);
        }
        if (this.projectedPredicate != null) {
            reader = reader.filter(this.projectedPredicate::test);
        }
        return reader;
    }
}

