/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.utils;

import java.io.Serializable;
import java.util.Objects;
import java.util.Random;
import org.apache.flink.api.common.typeutils.SerializerTestBase;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.paimon.flink.utils.JavaSerializer;

public class JavaSerializerTest
extends SerializerTestBase<TestClass> {
    protected TypeSerializer<TestClass> createSerializer() {
        return new JavaSerializer(TestClass.class);
    }

    protected int getLength() {
        return -1;
    }

    protected Class<TestClass> getTypeClass() {
        return TestClass.class;
    }

    protected TestClass[] getTestData() {
        Random rnd = new Random();
        int rndInt = rnd.nextInt();
        Integer[] integers = new Integer[]{0, 1, -1, Integer.MAX_VALUE, Integer.MIN_VALUE, rndInt, -rndInt};
        TestClass[] testClasses = new TestClass[integers.length];
        for (int i = 0; i < integers.length; ++i) {
            testClasses[i] = new TestClass(integers[i]);
        }
        return testClasses;
    }

    static class TestClass
    implements Serializable {
        int v;

        public TestClass() {
        }

        public TestClass(int v) {
            this.v = v;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestClass testClass = (TestClass)o;
            return this.v == testClass.v;
        }

        public int hashCode() {
            return Objects.hash(this.v);
        }
    }
}

