/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.source.metrics;

import org.apache.flink.metrics.testutils.MetricListener;
import org.apache.paimon.flink.source.metrics.FileStoreSourceReaderMetrics;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class FileStoreSourceReaderMetricsTest {
    FileStoreSourceReaderMetricsTest() {
    }

    @Test
    public void testRecordSnapshotUpdate() {
        MetricListener metricListener = new MetricListener();
        FileStoreSourceReaderMetrics sourceReaderMetrics = new FileStoreSourceReaderMetrics(metricListener.getMetricGroup());
        Assertions.assertThat((long)sourceReaderMetrics.getLatestFileCreationTime()).isEqualTo(-1L);
        Assertions.assertThat((long)sourceReaderMetrics.getLastSplitUpdateTime()).isEqualTo(-1L);
        sourceReaderMetrics.recordSnapshotUpdate(123L);
        Assertions.assertThat((long)sourceReaderMetrics.getLatestFileCreationTime()).isEqualTo(123L);
        Assertions.assertThat((long)sourceReaderMetrics.getLastSplitUpdateTime()).isGreaterThan(-1L);
    }

    @Test
    public void testCurrentFetchLagUpdated() {
        MetricListener metricListener = new MetricListener();
        FileStoreSourceReaderMetrics sourceReaderMetrics = new FileStoreSourceReaderMetrics(metricListener.getMetricGroup());
        Assertions.assertThat((long)sourceReaderMetrics.getFetchTimeLag()).isEqualTo(-1L);
        sourceReaderMetrics.recordSnapshotUpdate(123L);
        Assertions.assertThat((long)sourceReaderMetrics.getFetchTimeLag()).isNotEqualTo(-1L);
    }
}

