/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.source;

import java.util.Arrays;
import org.apache.flink.connector.file.src.util.RecordAndPosition;
import org.apache.paimon.flink.source.FileStoreSourceSplit;
import org.apache.paimon.flink.source.FileStoreSourceSplitSerializerTest;
import org.apache.paimon.flink.source.FileStoreSourceSplitState;
import org.apache.paimon.mergetree.compact.MergeTreeCompactManagerTest;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileStoreSourceSplitStateTest {
    @Test
    public void testRoundTripWithoutModification() {
        FileStoreSourceSplit split = FileStoreSourceSplitStateTest.getTestSplit();
        FileStoreSourceSplitState state = new FileStoreSourceSplitState(split);
        FileStoreSourceSplit resultSplit = state.toSourceSplit();
        Assertions.assertThat((long)resultSplit.recordsToSkip()).isEqualTo(split.recordsToSkip());
    }

    @Test
    public void testStateStartsWithSplitValues() {
        FileStoreSourceSplit split = FileStoreSourceSplitStateTest.getTestSplit(456L);
        FileStoreSourceSplitState state = new FileStoreSourceSplitState(split);
        Assertions.assertThat((long)state.recordsToSkip()).isEqualTo(456L);
    }

    @Test
    public void testNewSplitTakesModifiedOffsetAndCount() {
        FileStoreSourceSplit split = FileStoreSourceSplitStateTest.getTestSplit();
        FileStoreSourceSplitState state = new FileStoreSourceSplitState(split);
        state.setPosition(new RecordAndPosition(null, -1L, 7566L));
        Assertions.assertThat((long)state.toSourceSplit().recordsToSkip()).isEqualTo(7566L);
    }

    private static FileStoreSourceSplit getTestSplit() {
        return FileStoreSourceSplitStateTest.getTestSplit(0L);
    }

    private static FileStoreSourceSplit getTestSplit(long recordsToSkip) {
        return FileStoreSourceSplitSerializerTest.newSourceSplit("id", MergeTreeCompactManagerTest.row((int)1), 2, Arrays.asList(FileStoreSourceSplitSerializerTest.newFile(0), FileStoreSourceSplitSerializerTest.newFile(1)), recordsToSkip);
    }
}

