/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sorter;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.flink.sorter.SortOperator;
import org.apache.paimon.options.MemorySize;
import org.apache.paimon.sort.BinaryExternalSortBuffer;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.VarCharType;
import org.apache.paimon.utils.MutableObjectIterator;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class SortOperatorTest {
    @Test
    public void testSort() throws Exception {
        BinaryRow row;
        RowType keyRowType = new RowType(Collections.singletonList(new DataField(0, "a", (DataType)new BigIntType(), "Someone's desc.")));
        RowType rowType = new RowType(Arrays.asList(new DataField(0, "a", (DataType)new BigIntType()), new DataField(1, "b", (DataType)new VarCharType(), "Someone's desc."), new DataField(2, "c", (DataType)new VarCharType(), "Someone's desc.")));
        SortOperator sortOperator = new SortOperator(keyRowType, rowType, MemorySize.parse((String)"10 mb").getBytes(), (int)MemorySize.parse((String)"16 kb").getBytes(), 128, "lz4", 1, MemorySize.MAX_VALUE){};
        OneInputStreamOperatorTestHarness harness = this.createTestHarness(sortOperator);
        harness.open();
        for (int i = 0; i < 10000; ++i) {
            harness.processElement(new StreamRecord((Object)GenericRow.of((Object[])new Object[]{10000L - (long)i, BinaryString.fromString((String)""), BinaryString.fromString((String)"")})));
        }
        BinaryExternalSortBuffer externalSortBuffer = sortOperator.getBuffer();
        MutableObjectIterator iterator = externalSortBuffer.sortedIterator();
        BinaryRow reuse = new BinaryRow(3);
        long i = 1L;
        while ((row = (BinaryRow)iterator.next((Object)reuse)) != null) {
            Assertions.assertThat((long)row.getLong(0)).isEqualTo(i++);
        }
        harness.close();
    }

    @Test
    public void testCloseSortOperator() throws Exception {
        int i;
        RowType keyRowType = new RowType(Collections.singletonList(new DataField(0, "a", (DataType)new VarCharType(), "Someone's desc.")));
        RowType rowType = new RowType(Arrays.asList(new DataField(0, "a", (DataType)new VarCharType(), "Someone's desc."), new DataField(0, "b", (DataType)new VarCharType(), "Someone's desc."), new DataField(1, "c", (DataType)new BigIntType())));
        SortOperator sortOperator = new SortOperator(keyRowType, rowType, MemorySize.parse((String)"10 mb").getBytes(), (int)MemorySize.parse((String)"16 kb").getBytes(), 128, "lz4", 1, MemorySize.MAX_VALUE){};
        OneInputStreamOperatorTestHarness harness = this.createTestHarness(sortOperator);
        harness.open();
        File[] files = harness.getEnvironment().getIOManager().getSpillingDirectories();
        char[] data = new char[1024];
        for (i = 0; i < 1024; ++i) {
            data[i] = (char)(97 + i % 26);
        }
        for (i = 0; i < 10000; ++i) {
            harness.processElement(new StreamRecord((Object)GenericRow.of((Object[])new Object[]{BinaryString.fromString((String)String.valueOf(data)), BinaryString.fromString((String)String.valueOf(data)), (long)i})));
        }
        harness.close();
        for (File file : files) {
            this.assertNoDataFile(file);
        }
    }

    private void assertNoDataFile(File fileDir) {
        if (fileDir.exists()) {
            Assertions.assertThat((boolean)fileDir.isDirectory()).isTrue();
            for (File file : fileDir.listFiles()) {
                this.assertNoDataFile(file);
            }
        }
    }

    private OneInputStreamOperatorTestHarness createTestHarness(SortOperator operator) throws Exception {
        OneInputStreamOperatorTestHarness testHarness = new OneInputStreamOperatorTestHarness((OneInputStreamOperator)operator);
        return testHarness;
    }
}

