/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.util.Arrays;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.sink.Committable;
import org.apache.paimon.flink.sink.MultiTableCommittable;
import org.apache.paimon.flink.sink.MultiTableCommittableSerializer;
import org.apache.paimon.io.CompactIncrement;
import org.apache.paimon.io.DataIncrement;
import org.apache.paimon.manifest.ManifestCommittableSerializerTest;
import org.apache.paimon.mergetree.compact.MergeTreeCompactManagerTest;
import org.apache.paimon.table.sink.CommitMessageImpl;
import org.apache.paimon.table.sink.CommitMessageSerializer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class MultiTableCommittableSerializerTest {
    private final CommitMessageSerializer fileSerializer = new CommitMessageSerializer();
    private final MultiTableCommittableSerializer serializer = new MultiTableCommittableSerializer(this.fileSerializer);

    MultiTableCommittableSerializerTest() {
    }

    @Test
    public void testDeserialize() {
        DataIncrement dataIncrement = ManifestCommittableSerializerTest.randomNewFilesIncrement();
        CompactIncrement compactIncrement = ManifestCommittableSerializerTest.randomCompactIncrement();
        CommitMessageImpl commitMessage = new CommitMessageImpl(MergeTreeCompactManagerTest.row((int)0), 1, dataIncrement, compactIncrement);
        Committable committable = new Committable(9L, Committable.Kind.FILE, (Object)commitMessage);
        Arrays.asList(Tuple2.of((Object)"\u6d4b\u8bd5\u6570\u636e\u5e93", (Object)"\u7528\u6237\u4fe1\u606f\u8868"), Tuple2.of((Object)"database", (Object)"table")).forEach(tuple2 -> {
            MultiTableCommittable deserializeCommittable;
            String database = (String)tuple2.f0;
            String table = (String)tuple2.f1;
            MultiTableCommittable multiTableCommittable = MultiTableCommittable.fromCommittable((Identifier)Identifier.create((String)database, (String)table), (Committable)committable);
            try {
                deserializeCommittable = this.serializer.deserialize(2, this.serializer.serialize(multiTableCommittable));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            Assertions.assertThat((Object)deserializeCommittable).isInstanceOf(MultiTableCommittable.class);
            Assertions.assertThat((String)deserializeCommittable.getDatabase()).isEqualTo(database);
            Assertions.assertThat((String)deserializeCommittable.getTable()).isEqualTo(table);
        });
    }

    @Test
    public void testSerialize() {
        DataIncrement newFilesIncrement = ManifestCommittableSerializerTest.randomNewFilesIncrement();
        CompactIncrement compactIncrement = ManifestCommittableSerializerTest.randomCompactIncrement();
        CommitMessageImpl commitMessage = new CommitMessageImpl(MergeTreeCompactManagerTest.row((int)0), 1, newFilesIncrement, compactIncrement);
        Committable committable = new Committable(9L, Committable.Kind.FILE, (Object)commitMessage);
        Arrays.asList(Tuple2.of((Object)"\u6d4b\u8bd5\u6570\u636e\u5e93", (Object)"\u7528\u6237\u4fe1\u606f\u8868"), Tuple2.of((Object)"database", (Object)"table")).forEach(tuple2 -> {
            byte[] serializedData;
            block4: {
                String database = (String)tuple2.f0;
                String table = (String)tuple2.f1;
                MultiTableCommittable multiTableCommittable = MultiTableCommittable.fromCommittable((Identifier)Identifier.create((String)database, (String)table), (Committable)committable);
                serializedData = null;
                try {
                    serializedData = this.serializer.serialize(multiTableCommittable);
                }
                catch (BufferOverflowException e) {
                    e.printStackTrace();
                    assert (false) : "Should not throw BufferOverflowException";
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if ($assertionsDisabled) break block4;
                    throw new AssertionError((Object)"IOException occurred");
                }
            }
            Assertions.assertThat((byte[])serializedData).isNotNull();
        });
    }
}

