/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.paimon.consumer.Consumer;
import org.apache.paimon.consumer.ConsumerManager;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.flink.action.ActionITCaseBase;
import org.apache.paimon.flink.action.ResetConsumerAction;
import org.apache.paimon.flink.util.ReadWriteTableTestUtil;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.sink.StreamWriteBuilder;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.RowType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class ConsumerActionITCase
extends ActionITCaseBase {
    @Test
    public void testResetConsumer() throws Exception {
        ReadWriteTableTestUtil.init(this.warehouse);
        RowType rowType = RowType.of((DataType[])new DataType[]{DataTypes.BIGINT(), DataTypes.STRING()}, (String[])new String[]{"pk1", "col1"});
        FileStoreTable table = this.createFileStoreTable(rowType, Collections.emptyList(), Collections.singletonList("pk1"), Collections.emptyMap());
        StreamWriteBuilder writeBuilder = table.newStreamWriteBuilder().withCommitUser(this.commitUser);
        this.write = writeBuilder.newWrite();
        this.commit = writeBuilder.newCommit();
        this.writeData(this.rowData(1L, BinaryString.fromString((String)"Hi")));
        this.writeData(this.rowData(2L, BinaryString.fromString((String)"Hello")));
        this.writeData(this.rowData(3L, BinaryString.fromString((String)"Paimon")));
        ReadWriteTableTestUtil.testStreamingRead("SELECT * FROM `" + this.tableName + "` /*+ OPTIONS('consumer-id'='myid') */", Arrays.asList(TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{1L, "Hi"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{2L, "Hello"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{3L, "Paimon"}))).close();
        ConsumerManager consumerManager = new ConsumerManager(table.fileIO(), table.location());
        Optional consumer1 = consumerManager.consumer("myid");
        Assertions.assertThat((Optional)consumer1).isPresent();
        Assertions.assertThat((long)((Consumer)consumer1.get()).nextSnapshot()).isEqualTo(4L);
        List<String> args = Arrays.asList("reset_consumer", "--warehouse", this.warehouse, "--database", this.database, "--table", this.tableName, "--consumer_id", "myid", "--next_snapshot", "1");
        if (ThreadLocalRandom.current().nextBoolean()) {
            this.createAction(ResetConsumerAction.class, args).run();
        } else {
            this.callProcedure(String.format("CALL sys.reset_consumer('%s.%s', 'myid', 1)", this.database, this.tableName));
        }
        Optional consumer2 = consumerManager.consumer("myid");
        Assertions.assertThat((Optional)consumer2).isPresent();
        Assertions.assertThat((long)((Consumer)consumer2.get()).nextSnapshot()).isEqualTo(1L);
        if (ThreadLocalRandom.current().nextBoolean()) {
            this.createAction(ResetConsumerAction.class, args.subList(0, 9)).run();
        } else {
            this.callProcedure(String.format("CALL sys.reset_consumer('%s.%s', 'myid')", this.database, this.tableName));
        }
        Optional consumer3 = consumerManager.consumer("myid");
        Assertions.assertThat((Optional)consumer3).isNotPresent();
    }
}

