/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink;

import org.apache.flink.types.Row;
import org.apache.paimon.flink.CatalogITCaseBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class PredicateITCase
extends CatalogITCaseBase {
    @Test
    public void testPkFilterBucket() throws Exception {
        this.sql("CREATE TABLE T (a INT PRIMARY KEY NOT ENFORCED, b INT) WITH ('bucket' = '5')", new Object[0]);
        this.writeRecords();
        this.innerTestSingleField();
        this.innerTestAllFields();
    }

    @Test
    public void testNoPkFilterBucket() throws Exception {
        this.sql("CREATE TABLE T (a INT, b INT) WITH ('bucket' = '5', 'bucket-key'='a')", new Object[0]);
        this.writeRecords();
        this.innerTestSingleField();
        this.innerTestAllFields();
    }

    @Test
    public void testAppendFilterBucket() throws Exception {
        this.sql("CREATE TABLE T (a INT, b INT) WITH ('bucket' = '5', 'bucket-key'='a')", new Object[0]);
        this.writeRecords();
        this.innerTestSingleField();
        this.innerTestAllFields();
    }

    @Test
    public void testAppendNoBucketKey() throws Exception {
        this.sql("CREATE TABLE T (a INT, b INT) WITH ('bucket' = '5')", new Object[0]);
        this.writeRecords();
        this.innerTestSingleField();
        this.innerTestAllFields();
    }

    private void writeRecords() throws Exception {
        this.sql("INSERT INTO T VALUES (1, 2), (3, 4), (5, 6), (7, 8), (9, 10)", new Object[0]);
    }

    private void innerTestSingleField() throws Exception {
        Assertions.assertThat(this.sql("SELECT * FROM T WHERE a = 1", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, 2})});
        Assertions.assertThat(this.sql("SELECT * FROM T WHERE a = 3", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{3, 4})});
        Assertions.assertThat(this.sql("SELECT * FROM T WHERE a = 5", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{5, 6})});
        Assertions.assertThat(this.sql("SELECT * FROM T WHERE a = 7", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{7, 8})});
        Assertions.assertThat(this.sql("SELECT * FROM T WHERE a = 9", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{9, 10})});
    }

    private void innerTestAllFields() throws Exception {
        Assertions.assertThat(this.sql("SELECT * FROM T WHERE a = 1 and b = 2", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, 2})});
        Assertions.assertThat(this.sql("SELECT * FROM T WHERE a = 3 and b = 4", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{3, 4})});
        Assertions.assertThat(this.sql("SELECT * FROM T WHERE a = 5 and b = 6", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{5, 6})});
        Assertions.assertThat(this.sql("SELECT * FROM T WHERE a = 7 and b = 8", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{7, 8})});
        Assertions.assertThat(this.sql("SELECT * FROM T WHERE a = 9 and b = 10", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{9, 10})});
    }
}

