/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.types.Row;
import org.apache.paimon.flink.util.AbstractTestBase;
import org.apache.paimon.shade.guava30.com.google.common.collect.ImmutableList;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MappingTableITCase
extends AbstractTestBase {
    private TableEnvironment tEnv;
    private String path;

    @BeforeEach
    public void before() throws IOException {
        this.tEnv = this.tableEnvironmentBuilder().batchMode().build();
        this.path = this.getTempDirPath();
    }

    @Test
    public void testCreateEmptyMappingTable() {
        this.tEnv.executeSql(String.format("CREATE TABLE T (i INT, j INT) WITH ('connector'='paimon', 'path'='%s')", this.path));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.tEnv.executeSql("INSERT INTO T VALUES (1, 2), (3, 4)").await()).isInstanceOf(ValidationException.class)).hasRootCauseMessage("Schema file not found in location %s. Please create table first.", new Object[]{this.path});
    }

    @Test
    public void testCreateMappingTable() throws ExecutionException, InterruptedException {
        this.tEnv.executeSql(String.format("CREATE TABLE T (i INT, j INT) WITH ('connector'='paimon', 'path'='%s', 'auto-create'='true')", this.path));
        this.tEnv.executeSql("INSERT INTO T VALUES (1, 2), (3, 4)").await();
        this.tEnv.executeSql("DROP TABLE T");
        this.tEnv.executeSql(String.format("CREATE TABLE T (i INT, j INT) WITH ('connector'='paimon', 'path'='%s')", this.path));
        ImmutableList result = ImmutableList.copyOf((Iterator)this.tEnv.executeSql("SELECT * FROM T").collect());
        Assertions.assertThat((List)result).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, 2}), Row.of((Object[])new Object[]{3, 4})});
    }

    @Test
    public void testCreateTemporaryTableRepeat() throws Exception {
        for (int i = 0; i < 5; ++i) {
            this.tEnv.executeSql(String.format("CREATE TABLE T (i INT, j INT) WITH ('connector'='paimon', 'path'='%s', 'auto-create'='true')", this.path));
            this.tEnv.executeSql("SELECT * FROM T").collect().close();
            this.tEnv.executeSql("DROP TABLE T");
        }
    }

    @Test
    public void testCreateTemporaryTableConflict() throws Exception {
        this.tEnv.executeSql(String.format("CREATE TABLE T (i INT, j INT) WITH ('connector'='paimon', 'path'='%s', 'auto-create'='true')", this.path));
        this.tEnv.executeSql("SELECT * FROM T").collect().close();
        this.tEnv.executeSql("DROP TABLE T");
        this.tEnv.executeSql(String.format("CREATE TABLE T (i INT, j INT, k INT) WITH ('connector'='paimon', 'path'='%s', 'auto-create'='true')", this.path));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.tEnv.executeSql("SELECT * FROM T").collect().close()).isInstanceOf(ValidationException.class)).hasRootCauseMessage("Flink schema and store schema are not the same, store schema is ROW<`i` INT, `j` INT>, Flink schema is ROW<`i` INT, `j` INT, `k` INT> NOT NULL");
    }
}

