/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink;

import java.io.File;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.io.FileUtils;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.UniqueConstraint;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.types.Row;
import org.apache.paimon.flink.util.AbstractTestBase;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public abstract class FlinkTestBase
extends AbstractTestBase {
    public static final String CURRENT_CATALOG = "catalog";
    public static final String CURRENT_DATABASE = "default";
    protected ObjectIdentifier tableIdentifier;
    protected ExpectedResult expectedResult;
    protected boolean ignoreException;
    protected TableEnvironment tEnv;
    protected String rootPath;
    protected ResolvedCatalogTable resolvedTable = FlinkTestBase.createResolvedTable(Collections.emptyMap(), RowType.of((LogicalType[])new LogicalType[]{new IntType(), new VarCharType()}), Collections.emptyList(), Collections.emptyList());

    protected void prepareEnv(RuntimeExecutionMode executionMode, String tableName, boolean ignoreException, String manualCause, ExpectedResult expectedResult) {
        this.tableIdentifier = ObjectIdentifier.of((String)CURRENT_CATALOG, (String)CURRENT_DATABASE, (String)tableName);
        this.ignoreException = ignoreException;
        this.expectedResult = expectedResult;
        this.tEnv = executionMode == RuntimeExecutionMode.STREAMING ? this.tableEnvironmentBuilder().streamingMode().checkpointIntervalMs(100).build() : this.tableEnvironmentBuilder().batchMode().build();
        this.rootPath = this.getTempDirPath();
        this.tEnv.executeSql(String.format("CREATE CATALOG %s WITH ('type' = 'paimon', 'warehouse' = '%s')", CURRENT_CATALOG, this.rootPath));
        this.tEnv.useCatalog(CURRENT_CATALOG);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void test(RuntimeExecutionMode executionMode, String tableName, boolean ignoreException, String manualCause, ExpectedResult expectedResult) {
        this.prepareEnv(executionMode, tableName, ignoreException, manualCause, expectedResult);
        this.testCore();
    }

    protected abstract void testCore();

    protected static ResolvedCatalogTable createResolvedTable(Map<String, String> options, RowType rowType, List<String> partitionKeys, List<String> primaryKeys) {
        List fieldNames = rowType.getFieldNames();
        List fieldDataTypes = rowType.getChildren().stream().map(TypeConversions::fromLogicalToDataType).collect(Collectors.toList());
        List<Column> resolvedColumns = IntStream.range(0, fieldNames.size()).mapToObj(i -> Column.physical((String)((String)fieldNames.get(i)), (DataType)((DataType)fieldDataTypes.get(i)))).collect(Collectors.toList());
        return FlinkTestBase.createResolvedTable(options, resolvedColumns, partitionKeys, primaryKeys);
    }

    protected static ResolvedCatalogTable createResolvedTable(Map<String, String> options, List<Column> resolvedColumns, List<String> partitionKeys, List<String> primaryKeys) {
        UniqueConstraint constraint = primaryKeys.isEmpty() ? null : UniqueConstraint.primaryKey((String)"pk", primaryKeys);
        ResolvedSchema resolvedSchema = new ResolvedSchema(resolvedColumns, Collections.emptyList(), constraint);
        CatalogTable origin = CatalogTable.of((Schema)Schema.newBuilder().fromResolvedSchema(resolvedSchema).build(), (String)"a comment", partitionKeys, options);
        return new ResolvedCatalogTable(origin, resolvedSchema);
    }

    protected void deleteTablePath() {
        FileUtils.deleteQuietly((File)Paths.get(this.rootPath, this.relativeTablePath(this.tableIdentifier)).toFile());
    }

    protected String relativeTablePath(ObjectIdentifier tableIdentifier) {
        return String.format("%s.db/%s", tableIdentifier.getDatabaseName(), tableIdentifier.getObjectName());
    }

    protected static class ExpectedResult {
        protected boolean success;
        protected List<Row> expectedRecords;
        protected boolean failureHasCause;
        protected Class<? extends Throwable> expectedType;
        protected String expectedMessage;

        protected ExpectedResult() {
        }

        ExpectedResult success(boolean success) {
            this.success = success;
            return this;
        }

        ExpectedResult expectedRecords(List<Row> expectedRecords) {
            this.expectedRecords = expectedRecords;
            return this;
        }

        ExpectedResult failureHasCause(boolean failureHasCause) {
            this.failureHasCause = failureHasCause;
            return this;
        }

        ExpectedResult expectedType(Class<? extends Throwable> exceptionClazz) {
            this.expectedType = exceptionClazz;
            return this;
        }

        ExpectedResult expectedMessage(String exceptionMessage) {
            this.expectedMessage = exceptionMessage;
            return this;
        }

        public String toString() {
            return "ExpectedResult{success=" + this.success + ", expectedRecords=" + this.expectedRecords + ", failureHasCause=" + this.failureHasCause + ", expectedType=" + this.expectedType + ", expectedMessage='" + this.expectedMessage + '\'' + '}';
        }
    }
}

