/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableColumn;
import org.apache.flink.table.api.WatermarkSpec;
import org.apache.flink.table.types.DataType;
import org.apache.paimon.flink.utils.FlinkCatalogPropertiesUtil;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class FlinkCatalogPropertiesUtilTest {
    @Test
    public void testSerDeNonPhysicalColumns() {
        HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
        indexMap.put("comp", 2);
        indexMap.put("meta1", 3);
        indexMap.put("meta2", 5);
        ArrayList<Object> columns = new ArrayList<Object>();
        columns.add(TableColumn.computed((String)"comp", (DataType)DataTypes.INT(), (String)"`k` * 2"));
        columns.add(TableColumn.metadata((String)"meta1", (DataType)DataTypes.VARCHAR((int)10)));
        columns.add(TableColumn.metadata((String)"meta2", (DataType)((DataType)DataTypes.BIGINT().notNull()), (String)"price", (boolean)true));
        Map serialized = FlinkCatalogPropertiesUtil.serializeNonPhysicalColumns(indexMap, columns);
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put(FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{"schema", 2, "name"}), "comp");
        expected.put(FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{"schema", 2, "data-type"}), "INT");
        expected.put(FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{"schema", 2, "expr"}), "`k` * 2");
        expected.put(FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{"schema", 3, "name"}), "meta1");
        expected.put(FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{"schema", 3, "data-type"}), "VARCHAR(10)");
        expected.put(FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{"schema", 3, "metadata"}), "meta1");
        expected.put(FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{"schema", 3, "virtual"}), "false");
        expected.put(FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{"schema", 5, "name"}), "meta2");
        expected.put(FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{"schema", 5, "data-type"}), "BIGINT NOT NULL");
        expected.put(FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{"schema", 5, "metadata"}), "price");
        expected.put(FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{"schema", 5, "virtual"}), "true");
        Assertions.assertThat((Map)serialized).containsExactlyInAnyOrderEntriesOf(expected);
        ArrayList<TableColumn> deserialized = new ArrayList<TableColumn>();
        deserialized.add(FlinkCatalogPropertiesUtil.deserializeNonPhysicalColumn((Map)serialized, (int)2));
        deserialized.add(FlinkCatalogPropertiesUtil.deserializeNonPhysicalColumn((Map)serialized, (int)3));
        deserialized.add(FlinkCatalogPropertiesUtil.deserializeNonPhysicalColumn((Map)serialized, (int)5));
        Assertions.assertThat(deserialized).isEqualTo(columns);
    }

    @Test
    public void testSerDeWatermarkSpec() {
        WatermarkSpec watermarkSpec = new WatermarkSpec("test_time", "`test_time` - INTERVAL '0.001' SECOND", DataTypes.TIMESTAMP((int)3));
        Map serialized = FlinkCatalogPropertiesUtil.serializeWatermarkSpec((WatermarkSpec)watermarkSpec);
        HashMap<String, String> expected = new HashMap<String, String>();
        String watermarkPrefix = FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{"schema", "watermark", 0});
        expected.put(FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{watermarkPrefix, "rowtime"}), "test_time");
        expected.put(FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{watermarkPrefix, "strategy.expr"}), "`test_time` - INTERVAL '0.001' SECOND");
        expected.put(FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{watermarkPrefix, "strategy.data-type"}), "TIMESTAMP(3)");
        Assertions.assertThat((Map)serialized).containsExactlyInAnyOrderEntriesOf(expected);
        WatermarkSpec deserialized = FlinkCatalogPropertiesUtil.deserializeWatermarkSpec((Map)serialized);
        Assertions.assertThat((Object)deserialized).isEqualTo((Object)watermarkSpec);
    }

    @Test
    public void testNonPhysicalColumnsCount() {
        HashMap<String, String> oldStyleOptions = new HashMap<String, String>();
        oldStyleOptions.put(FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{"schema", 0, "name"}), "phy1");
        oldStyleOptions.put(FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{"schema", 0, "data-type"}), "INT");
        oldStyleOptions.put(FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{"schema", 1, "name"}), "phy2");
        oldStyleOptions.put(FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{"schema", 1, "data-type"}), "INT NOT NULL");
        oldStyleOptions.put(FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{"schema", 2, "name"}), "comp");
        oldStyleOptions.put(FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{"schema", 2, "data-type"}), "INT");
        oldStyleOptions.put(FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{"schema", 2, "expr"}), "`k` * 2");
        oldStyleOptions.put(FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{"schema", 3, "name"}), "meta1");
        oldStyleOptions.put(FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{"schema", 3, "data-type"}), "VARCHAR(10)");
        oldStyleOptions.put(FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{"schema", 3, "metadata"}), "meta1");
        oldStyleOptions.put(FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{"schema", 3, "virtual"}), "false");
        oldStyleOptions.put(FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{"schema", 4, "name"}), "meta2");
        oldStyleOptions.put(FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{"schema", 4, "data-type"}), "BIGINT NOT NULL");
        oldStyleOptions.put(FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{"schema", 4, "metadata"}), "price");
        oldStyleOptions.put(FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{"schema", 4, "virtual"}), "true");
        oldStyleOptions.put("schema.unknown.name", "test");
        Assertions.assertThat((int)FlinkCatalogPropertiesUtil.nonPhysicalColumnsCount(oldStyleOptions, Arrays.asList("phy1", "phy2"))).isEqualTo(3);
    }
}

